/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.internal.intro.impl.model.util;

import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.ccdt.internal.intro.impl.model.AbstractIntroPage;
import org.ccdt.internal.intro.impl.model.IntroExtensionContent;
import org.ccdt.internal.intro.impl.model.url.IntroURLParser;
import org.ccdt.internal.intro.impl.model.util.BundleUtil;
import org.ccdt.internal.intro.impl.util.Log;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelUtil {
    private static String TAG_BODY = "body";
    private static String TAG_HEAD = "head";
    private static String TAG_BASE = "base";
    public static String TAG_DIV = "div";
    public static String TAG_HEAD_LINK = "link";
    private static String TAG_PARAM = "param";
    private static String ATT_SRC = "src";
    private static String ATT_HREF = "href";
    private static String ATT_CITE = "cite";
    private static String ATT_LONGDESC = "longdesc";
    private static String ATT_DATA = "data";
    private static String ATT_CODEBASE = "codebase";
    private static String ATT_VALUE = "value";
    private static String ATT_VALUE_TYPE = "valuetype";
    private static String ATT_REL = "rel";
    private static String ATT_TYPE = "type";

    public static String resolveURL(String url, String pluginId) {
        Bundle bundle = null;
        if (pluginId != null) {
            bundle = Platform.getBundle((String)pluginId);
        }
        return ModelUtil.resolveURL("", url, bundle);
    }

    public static String resolveURL(String url, IConfigurationElement element) {
        Bundle bundle = BundleUtil.getBundleFromConfigurationElement(element);
        return ModelUtil.resolveURL("", url, bundle);
    }

    public static String resolveURL(String base, String url, Bundle bundle) {
        if (url == null) {
            return null;
        }
        IntroURLParser parser = new IntroURLParser(url);
        if (parser.hasProtocol()) {
            return url;
        }
        return BundleUtil.getResolvedResourceLocation(base, url, bundle);
    }

    public static void ensureFileURLsExist(Bundle bundle, String contentFile) {
        block2: {
            try {
                FileLocator.toFileURL((URL)bundle.getEntry("/"));
            }
            catch (Exception e) {
                if (contentFile == null) break block2;
                Log.error("Failed to extract Intro content folder for: " + contentFile, e);
            }
        }
    }

    public static String getParentFolderToString(String contentFilePath) {
        IPath path = ModelUtil.getParentFolderPath(contentFilePath);
        return path.toString();
    }

    public static String getParentFolderOSString(String contentFilePath) {
        IPath path = ModelUtil.getParentFolderPath(contentFilePath);
        return path.toOSString();
    }

    public static IPath getParentFolderPath(String contentFilePath) {
        Path path = new Path(contentFilePath);
        path = path.removeLastSegments(1).addTrailingSeparator();
        return path;
    }

    public static void insertBase(Document dom, String baseURL) {
        NodeList headList = dom.getElementsByTagName(TAG_HEAD);
        Element head = (Element)headList.item(0);
        NodeList baseList = head.getElementsByTagName(TAG_BASE);
        if (baseList.getLength() == 0) {
            Element base = dom.createElement(TAG_BASE);
            base.setAttribute(ATT_HREF, baseURL);
            head.insertBefore(base, head.getFirstChild());
        }
    }

    public static Element getBase(Document dom) {
        NodeList headList = dom.getElementsByTagName(TAG_HEAD);
        Element head = (Element)headList.item(0);
        NodeList baseList = head.getElementsByTagName(TAG_BASE);
        if (baseList.getLength() == 0) {
            return null;
        }
        return (Element)baseList.item(baseList.getLength() - 1);
    }

    public static void insertStyle(Document dom, String cssUrl) {
        NodeList headList = dom.getElementsByTagName(TAG_HEAD);
        Element head = null;
        NodeList styleList = null;
        if (headList.getLength() >= 1) {
            head = (Element)headList.item(0);
            styleList = head.getElementsByTagName(TAG_HEAD_LINK);
            int i = 0;
            while (i < styleList.getLength()) {
                Element style = (Element)styleList.item(0);
                String styleString = style.getAttribute(ATT_HREF);
                if (styleString.equals(cssUrl)) {
                    return;
                }
                ++i;
            }
        }
        Element styleToAdd = dom.createElement(TAG_HEAD_LINK);
        styleToAdd.setAttribute(ATT_HREF, cssUrl);
        styleToAdd.setAttribute(ATT_REL, "stylesheet");
        styleToAdd.setAttribute(ATT_TYPE, "text/css");
        if (styleList != null && styleList.getLength() >= 1) {
            styleList.item(0).getParentNode().insertBefore(styleToAdd, styleList.item(0));
        } else {
            head.appendChild(styleToAdd);
        }
    }

    public static Element getBodyElement(Document dom) {
        NodeList bodyList = dom.getElementsByTagName(TAG_BODY);
        Element body = (Element)bodyList.item(0);
        return body;
    }

    public static Element createElement(Document dom, String elementName, Properties attributes) {
        Element element = dom.createElementNS("", elementName);
        if (attributes != null) {
            Enumeration<Object> e = attributes.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                element.setAttribute(key, attributes.getProperty(key));
            }
        }
        return element;
    }

    public static Element createAndAppendChild(Element parentElement, String elementName, Properties attributes) {
        Element element = ModelUtil.createElement(parentElement.getOwnerDocument(), elementName, attributes);
        parentElement.appendChild(element);
        return element;
    }

    public static Element[] getElementsByTagName(Element parent, String tagName) {
        NodeList allChildElements = parent.getElementsByTagName(tagName);
        Vector<Element> vector = new Vector<Element>();
        int i = 0;
        while (i < allChildElements.getLength()) {
            Element aElement = (Element)allChildElements.item(i);
            if (aElement.getParentNode().equals(parent)) {
                vector.add(aElement);
            }
            ++i;
        }
        Object[] filteredElements = new Element[vector.size()];
        vector.copyInto(filteredElements);
        return filteredElements;
    }

    public static Element[] getElementsByTagName(Document dom, String tagName) {
        NodeList allChildElements = dom.getElementsByTagName(tagName);
        Vector<Element> vector = new Vector<Element>();
        int i = 0;
        while (i < allChildElements.getLength()) {
            Element aElement = (Element)allChildElements.item(i);
            if (aElement.getParentNode().equals(dom.getDocumentElement())) {
                vector.add(aElement);
            }
            ++i;
        }
        Object[] filteredElements = new Element[vector.size()];
        vector.copyInto(filteredElements);
        return filteredElements;
    }

    public static Element getElementById(Document dom, String id, String localElementName) {
        NodeList children = dom.getElementsByTagNameNS("*", localElementName);
        int i = 0;
        while (i < children.getLength()) {
            Element element = (Element)children.item(i);
            if (element.getAttribute("id").equals(id)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static Element getElementById(Document dom, String id) {
        return ModelUtil.getElementById(dom, id, "*");
    }

    public static void updateResourceAttributes(Element element, AbstractIntroPage page) {
        ModelUtil.updateResourceAttributes(element, page.getBase(), page.getBundle());
    }

    public static void updateResourceAttributes(Element element, IntroExtensionContent extensionContent) {
        ModelUtil.updateResourceAttributes(element, extensionContent.getBase(), extensionContent.getBundle());
    }

    private static void updateResourceAttributes(Element element, String base, Bundle bundle) {
        NodeList children = element.getElementsByTagName("*");
        int i = 0;
        while (i < children.getLength()) {
            Element child = (Element)children.item(i);
            ModelUtil.doUpdateResourceAttributes(child, base, bundle);
            ++i;
        }
    }

    private static void doUpdateResourceAttributes(Element element, String base, Bundle bundle) {
        ModelUtil.qualifyAttribute(element, ATT_SRC, base, bundle);
        ModelUtil.qualifyAttribute(element, ATT_HREF, base, bundle);
        ModelUtil.qualifyAttribute(element, ATT_CITE, base, bundle);
        ModelUtil.qualifyAttribute(element, ATT_LONGDESC, base, bundle);
        ModelUtil.qualifyAttribute(element, ATT_CODEBASE, base, bundle);
        ModelUtil.qualifyAttribute(element, ATT_DATA, base, bundle);
        ModelUtil.qualifyValueAttribute(element, base, bundle);
    }

    private static void qualifyAttribute(Element element, String attributeName, String base, Bundle bundle) {
        if (element.hasAttribute(attributeName)) {
            String attributeValue = element.getAttribute(attributeName);
            if (new IntroURLParser(attributeValue).hasProtocol()) {
                return;
            }
            String attributePath = BundleUtil.getResolvedResourceLocation(base, attributeValue, bundle);
            element.setAttribute(attributeName, attributePath);
        }
    }

    private static void qualifyValueAttribute(Element element, String base, Bundle bundle) {
        if (element.hasAttribute(ATT_VALUE) && element.hasAttribute(ATT_VALUE_TYPE) && element.getAttribute(ATT_VALUE_TYPE).equals("ref") && element.getLocalName().equals(TAG_PARAM)) {
            String value = element.getAttribute(ATT_VALUE);
            if (new IntroURLParser(value).hasProtocol()) {
                return;
            }
            String attributePath = BundleUtil.getResolvedResourceLocation(base, value, bundle);
            element.setAttribute(ATT_VALUE, attributePath);
        }
    }

    public static Node[] getArray(NodeList nodeList) {
        Node[] nodes = new Node[nodeList.getLength()];
        int i = 0;
        while (i < nodeList.getLength()) {
            nodes[i] = nodeList.item(i);
            ++i;
        }
        return nodes;
    }

    public static void removeAllElements(Document dom, String elementLocalName) {
        NodeList elements = dom.getElementsByTagNameNS("*", elementLocalName);
        Node[] elementsArray = ModelUtil.getArray(elements);
        int i = 0;
        while (i < elementsArray.length) {
            Node element = elementsArray[i];
            element.getParentNode().removeChild(element);
            ++i;
        }
    }
}

