/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.internal.intro.impl.model.loader;

import java.util.Enumeration;
import java.util.Hashtable;
import org.ccdt.internal.intro.config.IIntroContentProvider;
import org.ccdt.internal.intro.config.IIntroContentProviderSite;
import org.ccdt.internal.intro.impl.model.AbstractIntroPage;
import org.ccdt.internal.intro.impl.model.IntroContentProvider;
import org.ccdt.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.ccdt.internal.intro.impl.util.Log;

public class ContentProviderManager {
    private static ContentProviderManager inst = new ContentProviderManager();
    private Hashtable contentProviders = new Hashtable();

    protected ContentProviderManager() {
    }

    public static ContentProviderManager getInst() {
        return inst;
    }

    public IIntroContentProvider getContentProvider(IntroContentProvider provider) {
        ContentProviderWrapper providerWrapper = (ContentProviderWrapper)this.contentProviders.get(provider.getId());
        if (providerWrapper == null) {
            return null;
        }
        IIntroContentProvider providerClass = providerWrapper.getIIntroContentProvider();
        return providerClass;
    }

    public IIntroContentProvider createContentProvider(IntroContentProvider provider, IIntroContentProviderSite site) {
        String pluginId = provider.getPluginId() != null ? provider.getPluginId() : provider.getBundle().getSymbolicName();
        Object aClass = ModelLoaderUtil.createClassInstance(pluginId, provider.getClassName());
        IIntroContentProvider providerClass = null;
        if (aClass != null && aClass instanceof IIntroContentProvider) {
            providerClass = (IIntroContentProvider)aClass;
            providerClass.init(site);
            if (provider.getId() != null) {
                ContentProviderWrapper wrapper = new ContentProviderWrapper(providerClass, provider.getParentPage());
                this.contentProviders.put(provider.getId(), wrapper);
            }
        } else {
            Log.warning("Failed to create Intro model content provider: " + provider.getClassName());
        }
        return providerClass;
    }

    public AbstractIntroPage getContentProviderParentPage(IIntroContentProvider provider) {
        Enumeration keys = this.contentProviders.keys();
        while (keys.hasMoreElements()) {
            boolean foundKey;
            String key = (String)keys.nextElement();
            ContentProviderWrapper wrapper = (ContentProviderWrapper)this.contentProviders.get(key);
            boolean bl = foundKey = wrapper.getIIntroContentProvider().equals(provider);
            if (!foundKey) continue;
            return wrapper.getParentPage();
        }
        return null;
    }

    public void clear() {
        for (ContentProviderWrapper providerWrapper : this.contentProviders.values()) {
            IIntroContentProvider provider = providerWrapper.getIIntroContentProvider();
            provider.dispose();
        }
        this.contentProviders.clear();
        if (Log.logInfo) {
            Log.info("Cleared Intro model content providers");
        }
    }

    class ContentProviderWrapper {
        IIntroContentProvider provider;
        AbstractIntroPage parentPage;

        ContentProviderWrapper(IIntroContentProvider provider, AbstractIntroPage parentPage) {
            this.provider = provider;
            this.parentPage = parentPage;
        }

        IIntroContentProvider getIIntroContentProvider() {
            return this.provider;
        }

        AbstractIntroPage getParentPage() {
            return this.parentPage;
        }
    }
}

