/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.internal.intro.impl.html;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.ccdt.internal.intro.impl.html.HTMLUtil;

public class HTMLElement {
    private String elementName;
    private Map elementAttributes;
    private Vector elementContent;

    public HTMLElement(String name) {
        this.elementName = name;
        this.elementAttributes = new Hashtable();
        this.elementContent = new Vector();
    }

    public HTMLElement(String name, Map attributes, Vector content) {
        this.elementName = name;
        this.elementAttributes = attributes;
        this.elementContent = content;
    }

    public void addAttribute(String attributeName, String attributeValue) {
        if (attributeName != null && attributeValue != null) {
            this.getElementAttributes().put(attributeName, attributeValue);
        }
    }

    public void addContent(Object content) {
        this.getElementContent().add(content);
    }

    public Map getElementAttributes() {
        if (this.elementAttributes == null) {
            this.elementAttributes = new Hashtable();
        }
        return this.elementAttributes;
    }

    public void setElementAttributes(Map elementAttributes) {
        this.elementAttributes = elementAttributes;
    }

    public Vector getElementContent() {
        if (this.elementContent == null) {
            this.elementContent = new Vector();
        }
        return this.elementContent;
    }

    public void setElementContent(Vector elementContent) {
        this.elementContent = elementContent;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String toString() {
        StringBuffer element = new StringBuffer();
        element.append(HTMLUtil.createHTMLStartTag(this.getElementName(), this.getElementAttributes(), false));
        for (Object content : this.getElementContent()) {
            element.append(content);
        }
        element.append(HTMLUtil.createHTMLEndTag(this.getElementName(), false));
        return element.toString();
    }
}

