/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.internal.intro.contentproviders;

import java.io.PrintWriter;
import java.util.Properties;
import org.ccdt.internal.intro.config.IIntroAction;
import org.ccdt.internal.intro.config.IIntroContentProvider;
import org.ccdt.internal.intro.config.IIntroContentProviderSite;
import org.ccdt.internal.intro.impl.Messages;
import org.ccdt.internal.intro.impl.util.ReopenUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.intro.IIntroSite;

public class AlwaysWelcomeCheckbox
implements IIntroContentProvider,
IIntroAction {
    public static final String ALWAYS_SHOW_INTRO = "alwaysShowIntro";
    private boolean disposed = false;

    protected String getText() {
        return Messages.AlwaysWelcomeCheckbox_Text;
    }

    @Override
    public void createContent(String id, PrintWriter out) {
        boolean alwaysShowIntro = this.getAlwaysShowIntroPref();
        out.print("<div id=\"" + id + "\"><input type=\"checkbox\" " + "onClick=window.location=" + "\"http://org.eclipse.ui.intro/runAction?" + "pluginId=org.eclipse.ui.intro&" + "class=" + this.getClass().getName() + "\" ");
        if (alwaysShowIntro) {
            out.print(" checked=\"checked\"");
            PlatformUI.getPreferenceStore().setValue("showIntro", alwaysShowIntro);
        }
        out.println("/>" + this.getText() + "</div>");
    }

    @Override
    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        if (this.disposed) {
            return;
        }
        boolean alwaysShowIntro = this.getAlwaysShowIntroPref();
        Button checkBox = new Button(parent, 32);
        toolkit.adapt((Control)checkBox, false, false);
        checkBox.setText(this.getText());
        checkBox.setSelection(alwaysShowIntro);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlwaysWelcomeCheckbox.this.reverseShowIntroState();
            }
        });
        if (alwaysShowIntro) {
            PlatformUI.getPreferenceStore().setValue("showIntro", alwaysShowIntro);
        }
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @Override
    public void init(IIntroContentProviderSite site) {
    }

    @Override
    public void run(IIntroSite site, Properties params) {
        this.reverseShowIntroState();
    }

    private void reverseShowIntroState() {
        boolean alwaysShowIntro = !this.getAlwaysShowIntroPref();
        this.setAlwaysShowIntroPref(alwaysShowIntro);
        PlatformUI.getPreferenceStore().setValue("showIntro", alwaysShowIntro);
    }

    public boolean getAlwaysShowIntroPref() {
        if (!ReopenUtil.isReopenPreferenceInitialized()) {
            this.setAlwaysShowIntroPref(true);
        }
        return ReopenUtil.isReopenPreference();
    }

    public void setAlwaysShowIntroPref(boolean val) {
        ReopenUtil.setReopenPreference(val);
    }
}

