/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl17;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ISVNRepos;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.ReposNotifyCallback;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.Version;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.javahl17.SVNClientImpl;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAdapter;
import org.tmatesoft.svn.core.wc.admin.SVNUUIDAction;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNReposImpl {
    private SVNClientImpl client = SVNClientImpl.newInstance();
    private SVNAdminClient svnAdminClient;
    private boolean cancelOperation = false;
    public static final String BDB = "bdb";
    public static final String FSFS = "fsfs";

    public void dispose() {
        this.client.dispose();
        this.svnAdminClient = null;
    }

    public Version getVersion() {
        return this.client.getVersion();
    }

    protected SVNAdminClient getAdminClient() {
        if (this.svnAdminClient == null) {
            this.svnAdminClient = new SVNAdminClient(SVNWCUtil.createDefaultAuthenticationManager(), (ISVNOptions)SVNWCUtil.createDefaultOptions(true));
        }
        return this.svnAdminClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(File path, boolean disableFsyncCommit, boolean keepLog, File configPath, String fstype) throws ClientException {
        this.beforeOperation();
        if (BDB.equalsIgnoreCase(fstype)) {
            this.notImplementedYet("Only fsfs type of repositories are supported by " + this.getVersion().toString());
        }
        try {
            SVNRepositoryFactory.createLocalRepository(path, false, false);
            if (configPath != null) {
                // empty if block
            }
        }
        catch (SVNException e) {
            SVNReposImpl.throwException(e, this.client);
        }
        finally {
            this.afterOperation();
        }
    }

    public void deltify(File path, Revision start, Revision end) throws ClientException {
        this.notImplementedYet();
    }

    public void dump(File path, OutputStream dataOut, Revision start, Revision end, boolean incremental, boolean useDeltas, ReposNotifyCallback callback) throws ClientException {
        this.dump(path, dataOut, null, start, end, incremental, useDeltas, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(File path, OutputStream dataOut, final OutputStream errorOut, Revision start, Revision end, boolean incremental, boolean useDeltas, ReposNotifyCallback callback) throws ClientException {
        this.beforeOperation();
        OutputStream os = dataOut;
        try {
            this.getAdminClient().setEventHandler(new SVNAdminEventAdapter(){

                public void checkCancelled() throws SVNCancelException {
                    SVNReposImpl.this.checkCancelled();
                }

                public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
                    if (errorOut != null && event.getAction() == SVNAdminEventAction.REVISION_DUMPED) {
                        try {
                            errorOut.write(event.getMessage().getBytes());
                            errorOut.write(SVNReposImpl.this.client.getOptions().getNativeEOL());
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            });
            this.getAdminClient().doDump(path.getAbsoluteFile(), os, SVNClientImpl.getSVNRevision(start), SVNClientImpl.getSVNRevision(end), incremental, useDeltas);
        }
        catch (SVNException e) {
            try {
                if (errorOut != null) {
                    errorOut.write(e.getErrorMessage().getFullMessage().getBytes("UTF-8"));
                    errorOut.write(this.client.getOptions().getNativeEOL());
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            SVNReposImpl.throwException(e, this.client);
        }
        finally {
            this.afterOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hotcopy(File path, File targetPath, boolean cleanLogs) throws ClientException {
        this.beforeOperation();
        try {
            this.getAdminClient().setEventHandler(new SVNAdminEventAdapter(){

                public void checkCancelled() throws SVNCancelException {
                    SVNReposImpl.this.checkCancelled();
                }
            });
            this.getAdminClient().doHotCopy(path.getAbsoluteFile(), targetPath.getAbsoluteFile());
        }
        catch (SVNException e) {
            SVNReposImpl.throwException(e, this.client);
        }
        finally {
            this.afterOperation();
        }
    }

    public void listDBLogs(File path, ISVNRepos.MessageReceiver receiver) throws ClientException {
        this.notImplementedYet("Only fsfs type of repositories are supported by " + this.getVersion().toString());
    }

    public void listUnusedDBLogs(File path, ISVNRepos.MessageReceiver receiver) throws ClientException {
        this.notImplementedYet("Only fsfs type of repositories are supported by " + this.getVersion().toString());
    }

    public void load(File path, InputStream dataInput, boolean ignoreUUID, boolean forceUUID, String relativePath, ReposNotifyCallback callback) throws ClientException {
        this.load(path, dataInput, ignoreUUID, forceUUID, false, false, relativePath, callback);
    }

    public void load(File path, InputStream dataInput, boolean ignoreUUID, boolean forceUUID, boolean usePreCommitHook, boolean usePostCommitHook, String relativePath, ReposNotifyCallback callback) throws ClientException {
        this.load(path, dataInput, null, ignoreUUID, forceUUID, usePreCommitHook, usePostCommitHook, relativePath, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File path, InputStream dataInput, final OutputStream messageOutput, boolean ignoreUUID, boolean forceUUID, boolean usePreCommitHook, boolean usePostCommitHook, String relativePath, ReposNotifyCallback callback) throws ClientException {
        this.beforeOperation();
        InputStream is = dataInput;
        try {
            SVNUUIDAction uuidAction = SVNUUIDAction.DEFAULT;
            if (ignoreUUID) {
                uuidAction = SVNUUIDAction.IGNORE_UUID;
            } else if (forceUUID) {
                uuidAction = SVNUUIDAction.FORCE_UUID;
            }
            this.getAdminClient().setEventHandler(new SVNAdminEventAdapter(){
                private boolean myIsNodeOpened;

                public void checkCancelled() throws SVNCancelException {
                    SVNReposImpl.this.checkCancelled();
                }

                public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
                    if (messageOutput != null) {
                        try {
                            messageOutput.write(this.getLoadMessage(event).getBytes("UTF-8"));
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }

                protected String getLoadMessage(SVNAdminEvent event) {
                    StringBuffer message = new StringBuffer();
                    if (event.getAction() != SVNAdminEventAction.REVISION_LOAD && this.myIsNodeOpened) {
                        message.append(" done.");
                        message.append(SVNReposImpl.this.client.getOptions().getNativeEOL());
                        this.myIsNodeOpened = false;
                    }
                    if (event.getAction() == SVNAdminEventAction.REVISION_LOADED) {
                        message.append(SVNReposImpl.this.client.getOptions().getNativeEOL());
                    }
                    message.append(event.getMessage());
                    message.append(SVNReposImpl.this.client.getOptions().getNativeEOL());
                    if (event.getAction() == SVNAdminEventAction.REVISION_LOADED) {
                        message.append(SVNReposImpl.this.client.getOptions().getNativeEOL());
                    }
                    this.myIsNodeOpened = event.getAction() != SVNAdminEventAction.REVISION_LOAD;
                    return message.toString();
                }
            });
            this.getAdminClient().doLoad(path.getAbsoluteFile(), is, usePreCommitHook, usePostCommitHook, uuidAction, relativePath);
        }
        catch (SVNException e) {
            if (messageOutput != null) {
                try {
                    messageOutput.write(e.getErrorMessage().getFullMessage().getBytes("UTF-8"));
                    messageOutput.write(this.client.getOptions().getNativeEOL());
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            SVNReposImpl.throwException(e, this.client);
        }
        finally {
            this.afterOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lstxns(File path, final ISVNRepos.MessageReceiver receiver) throws ClientException {
        this.beforeOperation();
        this.getAdminClient().setEventHandler(new SVNAdminEventAdapter(){

            public void checkCancelled() throws SVNCancelException {
                SVNReposImpl.this.checkCancelled();
            }

            public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
                if (receiver != null && event.getTxnName() != null) {
                    receiver.receiveMessageLine(event.getTxnName());
                }
            }
        });
        try {
            this.getAdminClient().doListTransactions(path.getAbsoluteFile());
        }
        catch (SVNException e) {
            SVNReposImpl.throwException(e, this.client);
        }
        finally {
            this.afterOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long recover(File path, ReposNotifyCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            File repositoryRoot = path.getAbsoluteFile();
            this.getAdminClient().doRecover(repositoryRoot);
            this.getAdminClient().setEventHandler(new SVNAdminEventAdapter(){

                public void checkCancelled() throws SVNCancelException {
                    SVNReposImpl.this.checkCancelled();
                }
            });
            long l = this.getAdminClient().getYoungestRevision(repositoryRoot);
            return l;
        }
        catch (SVNException e) {
            SVNReposImpl.throwException(e, this.client);
        }
        finally {
            this.afterOperation();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rmtxns(File path, String[] transactions) throws ClientException {
        this.beforeOperation();
        try {
            this.getAdminClient().setEventHandler(new SVNAdminEventAdapter(){

                public void checkCancelled() throws SVNCancelException {
                    SVNReposImpl.this.checkCancelled();
                }
            });
            this.getAdminClient().doRemoveTransactions(path.getAbsoluteFile(), transactions);
        }
        catch (SVNException e) {
            SVNReposImpl.throwException(e, this.client);
        }
        finally {
            this.afterOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevProp(File path, Revision rev, String propName, String propValue, boolean usePreRevPropChangeHook, boolean usePostRevPropChangeHook) throws SubversionException {
        this.beforeOperation();
        try {
            SVNReposImpl.setRevisionProperty(path, rev, propName, propValue, !usePreRevPropChangeHook, !usePostRevPropChangeHook);
        }
        catch (SVNException e) {
            SVNReposImpl.throwException(e, this.client);
        }
        finally {
            this.afterOperation();
        }
    }

    public void verify(File path, Revision start, Revision end, ReposNotifyCallback callback) throws ClientException {
        this.verify(path, null, start, end, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify(File path, final OutputStream messageOut, Revision start, Revision end, ReposNotifyCallback callback) throws ClientException {
        this.beforeOperation();
        try {
            this.getAdminClient().setEventHandler(new SVNAdminEventAdapter(){

                public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
                    if (messageOut != null && event.getAction() == SVNAdminEventAction.REVISION_DUMPED) {
                        try {
                            messageOut.write(event.getMessage().getBytes());
                            messageOut.write(SVNReposImpl.this.client.getOptions().getNativeEOL());
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            });
            this.getAdminClient().doVerify(path.getAbsoluteFile(), SVNClientImpl.getSVNRevision(start), SVNClientImpl.getSVNRevision(end));
        }
        catch (SVNException e) {
            try {
                if (messageOut != null) {
                    messageOut.write(e.getErrorMessage().getFullMessage().getBytes("UTF-8"));
                    messageOut.write(this.client.getOptions().getNativeEOL());
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            SVNReposImpl.throwException(e, this.client);
        }
        finally {
            this.afterOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Lock> lslocks(File path, Depth depth) throws ClientException {
        this.beforeOperation();
        final HashSet<Lock> locks = new HashSet<Lock>();
        this.getAdminClient().setEventHandler(new SVNAdminEventAdapter(){

            public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
                if (event.getAction() == SVNAdminEventAction.LOCK_LISTED) {
                    SVNLock svnLock = event.getLock();
                    Lock lock = SVNClientImpl.getLock(svnLock);
                    locks.add(lock);
                }
            }
        });
        try {
            this.getAdminClient().doListLocks(path.getAbsoluteFile());
        }
        catch (SVNException e) {
            SVNReposImpl.throwException(e, this.client);
        }
        finally {
            this.afterOperation();
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rmlocks(File path, String[] locks) throws ClientException {
        this.beforeOperation();
        try {
            this.getAdminClient().doRemoveLocks(path.getAbsoluteFile(), locks);
        }
        catch (SVNException e) {
            SVNReposImpl.throwException(e, this.client);
        }
        finally {
            this.afterOperation();
        }
    }

    public void upgrade(File path, ReposNotifyCallback callback) throws ClientException {
        this.notImplementedYet();
    }

    public void pack(File path, ReposNotifyCallback callback) throws ClientException {
        this.notImplementedYet();
    }

    public void cancelOperation() throws ClientException {
        this.cancelOperation = true;
    }

    private void checkCancelled() throws SVNCancelException {
        if (this.cancelOperation) {
            this.cancelOperation = false;
            SVNErrorManager.cancel("operation cancelled", SVNLogType.DEFAULT);
        }
    }

    private static void setRevisionProperty(File path, Revision rev, String propName, String propValue, boolean bypassPreRevPropChangeHook, boolean bypassPostRevPropChangeHook) throws SVNException {
        SVNRepository repository = SVNRepositoryFactory.create(SVNURL.fromFile(path.getAbsoluteFile()));
        ((FSRepository)repository).setRevisionPropertyValue(SVNClientImpl.getSVNRevision(rev).getNumber(), propName, SVNPropertyValue.create(propValue), bypassPreRevPropChangeHook, bypassPostRevPropChangeHook);
    }

    private void notImplementedYet() throws ClientException {
        this.notImplementedYet(null);
    }

    private void notImplementedYet(String message) throws ClientException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, message == null ? "Requested SVNAdmin functionality is not yet implemented" : message);
        SVNReposImpl.throwException(new SVNException(err), this.client);
    }

    public static void throwException(SVNException e, SVNClientImpl svnClient) throws ClientException {
        ClientException ec = SVNClientImpl.getClientException(e);
        svnClient.getDebugLog().logFine(SVNLogType.DEFAULT, ec);
        svnClient.getDebugLog().logFine(SVNLogType.DEFAULT, e);
        throw ec;
    }

    private void beforeOperation() {
        this.cancelOperation = false;
    }

    private void afterOperation() {
        this.cancelOperation = false;
        this.getAdminClient().setEventHandler(null);
    }
}

