/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.javahl17;

import java.io.File;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNSSLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNSSLPasspharsePromptSupport;
import org.tmatesoft.svn.core.javahl17.UserPasswordSSHCallback;
import org.tmatesoft.svn.core.javahl17.UserPasswordSSLCallback;

class JavaHLAuthenticationProvider
implements ISVNAuthenticationProvider,
ISVNSSLPasspharsePromptSupport {
    private static final String ADAPTER_DEFAULT_PROMPT_CLASS = "org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter$DefaultPromptUserPassword";
    private UserPasswordCallback prompt;

    public JavaHLAuthenticationProvider(UserPasswordCallback prompt) {
        this.prompt = prompt;
    }

    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        String userName;
        if ("svn.ssh".equals(kind) && this.prompt instanceof UserPasswordSSHCallback) {
            int port;
            UserPasswordSSHCallback prompt4 = (UserPasswordSSHCallback)this.prompt;
            String userName2 = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : JavaHLAuthenticationProvider.getUserName(null, url);
            int n = port = url != null ? url.getPort() : -1;
            if (prompt4.promptSSH(realm, userName2, port, authMayBeStored)) {
                String password = prompt4.getPassword();
                String keyPath = prompt4.getSSHPrivateKeyPath();
                String passphrase = prompt4.getSSHPrivateKeyPassphrase();
                userName2 = JavaHLAuthenticationProvider.getUserName(prompt4.getUsername(), url);
                if ("".equals(passphrase)) {
                    passphrase = null;
                }
                if ((port = prompt4.getSSHPort()) < 0 && url != null) {
                    port = url.getPort();
                }
                if (port < 0) {
                    port = 22;
                }
                boolean save = prompt4.userAllowedSave();
                if (keyPath != null && !"".equals(keyPath)) {
                    return new SVNSSHAuthentication(userName2, new File(keyPath), passphrase, port, save, url, false);
                }
                if (password != null) {
                    return new SVNSSHAuthentication(userName2, password, port, save, url, false);
                }
            }
            return null;
        }
        if ("svn.ssl.client-passphrase".equals(kind) && SVNSSLAuthentication.isCertificatePath(realm)) {
            String passphrase = this.prompt.askQuestion(realm, "SSL Certificate Passphrase", authMayBeStored);
            if (passphrase != null) {
                return new SVNPasswordAuthentication("", passphrase, this.prompt.userAllowedSave(), url, false);
            }
        } else if ("svn.ssl.client-passphrase".equals(kind) && !SVNSSLAuthentication.isCertificatePath(realm) && this.prompt instanceof UserPasswordSSLCallback) {
            UserPasswordSSLCallback prompt4 = (UserPasswordSSLCallback)this.prompt;
            if (prompt4.promptSSL(realm, authMayBeStored)) {
                String cert = prompt4.getSSLClientCertPath();
                String password = prompt4.getSSLClientCertPassword();
                if (cert != null) {
                    if ("".equals(password)) {
                        password = null;
                    }
                    boolean save = this.prompt.userAllowedSave();
                    if (cert.startsWith("MSCAPI")) {
                        String alias = null;
                        if (cert.lastIndexOf(59) > 0) {
                            alias = cert.substring(cert.lastIndexOf(59) + 1);
                        }
                        return new SVNSSLAuthentication("MSCAPI", alias, save, url, false);
                    }
                    SVNSSLAuthentication sslAuth = new SVNSSLAuthentication(new File(cert), password, save, url, false);
                    sslAuth.setCertificatePath(cert);
                    return sslAuth;
                }
            }
            return null;
        }
        if ("svn.ssh".equals(kind) && previousAuth == null) {
            String keyPath = System.getProperty("svnkit.ssh2.key", System.getProperty("javasvn.ssh2.key"));
            String userName3 = JavaHLAuthenticationProvider.getUserName(System.getProperty("svnkit.ssh2.username", System.getProperty("javasvn.ssh2.username")), url);
            String passPhrase = System.getProperty("svnkit.ssh2.passphrase", System.getProperty("javasvn.ssh2.passphrase"));
            if (userName3 == null) {
                return null;
            }
            if (keyPath != null && previousAuth == null) {
                return new SVNSSHAuthentication(userName3, new File(keyPath), passPhrase, -1, true, url, false);
            }
        } else {
            if ("svn.username".equals(kind)) {
                String string = userName = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : JavaHLAuthenticationProvider.getUserName(null, url);
                if (this.prompt.prompt(realm, userName, authMayBeStored)) {
                    return new SVNUserNameAuthentication(this.prompt.getUsername(), this.prompt.userAllowedSave(), url, false);
                }
                return this.getDefaultUserNameCredentials(userName);
            }
            if (!"svn.simple".equals(kind)) {
                return null;
            }
        }
        String string = userName = previousAuth != null && previousAuth.getUserName() != null ? previousAuth.getUserName() : JavaHLAuthenticationProvider.getUserName(null, url);
        if (this.prompt.prompt(realm, userName, authMayBeStored)) {
            if ("svn.ssh".equals(kind)) {
                int portNumber = previousAuth instanceof SVNSSHAuthentication ? ((SVNSSHAuthentication)previousAuth).getPortNumber() : -1;
                return new SVNSSHAuthentication(this.prompt.getUsername(), this.prompt.getPassword(), portNumber, this.prompt.userAllowedSave(), url, false);
            }
            return new SVNPasswordAuthentication(this.prompt.getUsername(), this.prompt.getPassword(), this.prompt.userAllowedSave(), url, false);
        }
        return null;
    }

    private SVNAuthentication getDefaultUserNameCredentials(String userName) {
        if (ADAPTER_DEFAULT_PROMPT_CLASS.equals(this.prompt.getClass().getName())) {
            return new SVNUserNameAuthentication(userName, false, null, false);
        }
        return null;
    }

    public int acceptServerAuthentication(SVNURL url, String realm, Object serverAuth, boolean resultMayBeStored) {
        if (serverAuth instanceof X509Certificate) {
            Object object = serverAuth = serverAuth instanceof X509Certificate ? SVNSSLUtil.getServerCertificatePrompt((X509Certificate)serverAuth, realm, url.getHost()) : serverAuth;
            if (serverAuth == null) {
                serverAuth = "Unsupported certificate type '" + (serverAuth != null ? serverAuth.getClass().getName() : "null") + "'";
            }
            return this.prompt.askTrustSSLServer(serverAuth.toString(), resultMayBeStored);
        }
        if (this.prompt != null && serverAuth instanceof byte[]) {
            String prompt = "The ''{0}'' server''s key fingerprint is:\n{1}\nIf you trust this host, select ''Yes'' to add the key to the SVN cache and carry on connecting.\nIf you do not trust this host, select ''No'' to abandon the connection.";
            if (!this.prompt.askYesNo(realm, prompt = MessageFormat.format(prompt, url.getHost(), SVNSSLUtil.getFingerprint((byte[])serverAuth, "MD5")), false)) {
                return 0;
            }
        }
        return 2;
    }

    public boolean isSSLPassphrasePromtSupported() {
        return true;
    }

    private static String getUserName(String userName, SVNURL url) {
        if (userName == null || "".equals(userName.trim())) {
            String string = userName = url != null ? url.getUserInfo() : null;
        }
        if (userName == null || "".equals(userName.trim())) {
            userName = System.getProperty("user.name");
        }
        return userName;
    }
}

