/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ccdt.common.config.model.JSConfig;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.utils.SystemInfoBase;

public class SystemInfo
extends SystemInfoBase {
    public static final String IDE_VERSION = "v1.0.0.RC0";
    public static final String OS_NAME = SystemInfoBase.OS_NAME;
    public static final String OS_VERSION = SystemInfoBase.OS_VERSION;
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    public static final String ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model");
    public static final String SUN_DESKTOP = System.getProperty("sun.desktop", "");
    public static final boolean isWindows = SystemInfoBase.isWindows;
    public static final boolean isMac = SystemInfoBase.isMac;
    public static final boolean isOS2 = SystemInfoBase.isOS2;
    public static final boolean isLinux = SystemInfoBase.isLinux;
    public static final boolean isFreeBSD = _OS_NAME.startsWith("freebsd");
    public static final boolean isSolaris = _OS_NAME.startsWith("sunos");
    public static final boolean isUnix = SystemInfoBase.isUnix;
    public static final boolean isWin2kOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.0");
    public static final boolean isWinVistaOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.0");
    public static final boolean isWin7OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.1");
    public static final boolean is32Bit = ARCH_DATA_MODEL == null || ARCH_DATA_MODEL.equals("32");
    public static final boolean is64Bit = !is32Bit;
    public static final boolean isAMD64 = "amd64".equals(OS_ARCH);
    public static final boolean isMacIntel64 = isMac && "x86_64".equals(OS_ARCH);
    private static final Pattern pidPattern = Pattern.compile("[0-9]{1,}");
    private static int macHeaderCMDNo = -1;

    public static boolean checkPortBusy(int[] ports, boolean excludeAdb) {
        int usingPID = 0;
        String processName = null;
        int i = 0;
        int usingPort = 0;
        while (processName == null && i < ports.length) {
            usingPort = ports[i];
            String cmd = null;
            Process proc = null;
            try {
                if (isWindows) {
                    cmd = String.format("cmd.exe /c netstat -ano|findstr \":%d \" | findstr LISTENING", usingPort);
                    proc = Runtime.getRuntime().exec(cmd);
                } else {
                    cmd = String.format("lsof -i :%d -sTCP:LISTEN", usingPort);
                    String[] command = new String[]{"/bin/sh", "-c", cmd};
                    proc = Runtime.getRuntime().exec(command);
                }
                InputStream is = proc.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                block3: while (processName == null && (line = br.readLine()) != null) {
                    String[] rows = line.split("\\s+");
                    int j = 0;
                    while (j < rows.length) {
                        if (pidPattern.matcher(rows[j]).matches()) {
                            usingPID = Integer.parseInt(rows[j]);
                            processName = SystemInfo.getCMDNameByPID(usingPID, excludeAdb);
                            continue block3;
                        }
                        ++j;
                    }
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        if (processName != null) {
            CocosLogger.getLogger((String)"SystemInfo").error((Object)String.format("Port %d being used by %s", usingPort, processName));
            Dialogs.showMessageDialog(String.format("Port %d being used by %s, please close it and try again.", usingPort, processName));
            return true;
        }
        return false;
    }

    public static boolean isRuntimeStarted(String keyword) {
        boolean flag = false;
        try {
            String cmd;
            Process proc = null;
            if (isWindows) {
                cmd = String.format("cmd.exe /c tasklist | findstr %s", keyword);
                proc = Runtime.getRuntime().exec(cmd);
            } else {
                cmd = String.format("ps -ef|grep %s", keyword);
                String[] command = new String[]{"/bin/sh", "-c", cmd};
                proc = Runtime.getRuntime().exec(command);
            }
            InputStream is = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.indexOf("grep") >= 0 || line.indexOf(keyword) < 0) continue;
                flag = true;
            }
        }
        catch (Exception exception) {}
        return flag;
    }

    static String getCMDNameByPID(int pid, boolean excludeAdb) {
        String processName = null;
        Process proc = null;
        try {
            String cmd;
            if (isWindows) {
                cmd = String.format("cmd.exe /c tasklist | findstr \" %d \"", pid);
                proc = Runtime.getRuntime().exec(cmd);
            } else {
                cmd = String.format("ps -ef|grep %d", pid);
                String[] command = new String[]{"/bin/sh", "-c", cmd};
                proc = Runtime.getRuntime().exec(command);
            }
            InputStream is = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while (processName == null && (line = br.readLine()) != null) {
                if (line.indexOf("grep") >= 0) continue;
                processName = SystemInfo.getCMDNameFromLine(line, excludeAdb);
            }
        }
        catch (Exception exception) {}
        return processName;
    }

    static String getCMDNameFromLine(String line, boolean excludeAdb) throws IOException {
        String[] rows = line.split("\\s+");
        if (isMac) {
            if (macHeaderCMDNo == -1) {
                macHeaderCMDNo = SystemInfo.getMacHeaderNo("CMD");
            }
            if (macHeaderCMDNo == -1) {
                return null;
            }
            if (excludeAdb && rows[macHeaderCMDNo].equals("adb")) {
                return null;
            }
            return rows[macHeaderCMDNo];
        }
        int i = 0;
        while (i < rows.length) {
            if (!(excludeAdb && rows[i].endsWith("adb.exe") || !rows[i].endsWith(".exe"))) {
                return rows[i];
            }
            ++i;
        }
        return null;
    }

    static int getMacHeaderNo(String header) throws IOException {
        String cmd = String.format("ps -ef|grep %s", header);
        String[] command = new String[]{"/bin/sh", "-c", cmd};
        Process proc = Runtime.getRuntime().exec(command);
        InputStream is = proc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.indexOf("grep") >= 0) continue;
            String[] rows = line.split("\\s+");
            int i = 0;
            while (i < rows.length) {
                if (rows[i].equals(header)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static boolean isOsVersionAtLeast(String version) {
        if (version == null) {
            throw new IllegalArgumentException("parameter version must not null");
        }
        return SystemInfo.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    static int compareVersionNumbers(String v1, String v2) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        int idx = 0;
        while (idx < part1.length && idx < part2.length) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp != 0) {
                return cmp;
            }
            ++idx;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        boolean left = part1.length > idx;
        String[] parts = left ? part1 : part2;
        while (idx < parts.length) {
            String p = parts[idx];
            int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
            if (cmp != 0) {
                return left ? cmp : -cmp;
            }
            ++idx;
        }
        return 0;
    }

    public static String getJSEngineVersion() {
        JSConfig config = ConfigurationManager.COMMON.getConfig(JSConfig.class);
        String enginePath = config.getJsEnginePath();
        String versionPath = String.valueOf(enginePath) + File.separator + "frameworks" + File.separator + "js-bindings" + File.separator + "cocos2d-x" + File.separator + "cocos" + File.separator + "cocos2d.cpp";
        File f = new File(versionPath);
        if (!f.exists() && !(f = new File(versionPath = String.valueOf(enginePath) + File.separator + "frameworks" + File.separator + "js-bindings" + File.separator + "cocos2d-x" + File.separator + "cocos" + File.separator + "2d" + File.separator + "cocos2d.cpp")).exists()) {
            return "";
        }
        FileReader fr = null;
        try {
            fr = new FileReader(versionPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader br = new BufferedReader(fr);
        String line = "";
        StringBuffer buffer = new StringBuffer();
        try {
            while ((line = br.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Pattern pat = Pattern.compile("return \".*\"");
        Matcher mat = pat.matcher(buffer.toString());
        if (!mat.find()) {
            return "";
        }
        String p = mat.group();
        return p.substring(p.indexOf("\"") + 1, p.length() - 1);
    }

    public static String getLuaEngineVersionNumber() {
        String version = SystemInfo.getLuaEngineVersion();
        if (version.length() == 0) {
            return "";
        }
        Pattern pat = Pattern.compile("cocos2d-x [0-9].[0-9]");
        Matcher mat = pat.matcher(version);
        if (!mat.find()) {
            return "";
        }
        String[] vs = mat.group().split(" ");
        if (vs.length == 0) {
            return "";
        }
        return vs[1];
    }

    public static String getLuaEngineVersion() {
        String enginePath = PathManager.instance.getLUAEnginePath();
        String versionPath = String.valueOf(enginePath) + File.separator + "cocos" + File.separator + "cocos2d.cpp";
        File f = new File(versionPath);
        if (!f.exists() && !(f = new File(versionPath = String.valueOf(enginePath) + File.separator + "cocos" + File.separator + "2d" + File.separator + "cocos2d.cpp")).exists()) {
            return "";
        }
        FileReader fr = null;
        try {
            fr = new FileReader(versionPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader br = new BufferedReader(fr);
        String line = "";
        StringBuffer buffer = new StringBuffer();
        try {
            while ((line = br.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Pattern pat = Pattern.compile("return \".*\"");
        Matcher mat = pat.matcher(buffer.toString());
        if (!mat.find()) {
            return "";
        }
        String p = mat.group();
        return p.substring(p.indexOf("\"") + 1, p.length() - 1);
    }

    public static int availableProcessors4Build() {
        int num = Runtime.getRuntime().availableProcessors();
        num = num == 1 ? num : num - 1;
        return num;
    }
}

