/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.utils;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ccdt.common.CommonConstants;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.model.CocosProjectConfig;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class ResourceUtil {
    public static final String NEED_UPLOADED_FILES = "uploaded";
    public static final String NEED_DELETEED_FILES = "deleted";

    public static Map<String, String> getLocalFilesInfo(String projName) {
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        File projDir = proj.getLocation().toFile();
        HashMap<String, String> filesMap = new HashMap<String, String>();
        File[] fileArray = projDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String filename = f.getName();
            if (!ResourceUtil.isIgnoredFileOrFolder(filename) && !ResourceUtil.isCustomIgnoredFileOrFolder(proj, filename)) {
                ResourceUtil.recordToMap(projDir, f, filesMap);
            }
            ++n2;
        }
        return filesMap;
    }

    private static void recordToMap(File projDir, File file, Map<String, String> map) {
        if (file.isFile()) {
            String filePath = file.getAbsolutePath();
            String relativePath = filePath.substring((String.valueOf(projDir.getAbsolutePath()) + File.separator).length()).replaceAll("[\\\\]", "/");
            map.put(relativePath, String.valueOf(file.lastModified()));
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                ResourceUtil.recordToMap(projDir, f, map);
                ++n2;
            }
        }
    }

    public static Map<String, Collection<String>> getChangedFiles(Map<String, String> local, Map<String, String> runtime) {
        Set<String> keySet = runtime.keySet();
        Iterator<String> it = keySet.iterator();
        while (it.hasNext()) {
            String key = it.next();
            String value = local.get(key);
            if (value == null) continue;
            if (local.get(key).equals(runtime.get(key))) {
                local.remove(key);
                it.remove();
                continue;
            }
            it.remove();
        }
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        result.put(NEED_UPLOADED_FILES, local.keySet());
        result.put(NEED_DELETEED_FILES, runtime.keySet());
        return result;
    }

    public static Map<String, Collection<String>> getUploadAndDeleteFiles(String projName, Map runtimeFileInfo) {
        Map<String, String> local = ResourceUtil.getLocalFilesInfo(projName);
        return ResourceUtil.getChangedFiles(local, runtimeFileInfo);
    }

    public static boolean isIgnoredFileOrFolder(String fileName) {
        return CommonConstants.IGNORED_FILE_OR_DIR.contains(fileName) || fileName.substring(fileName.lastIndexOf(File.separator) + 1).startsWith(".");
    }

    public static boolean isCustomIgnoredFileOrFolder(IProject proj, String fileName) {
        CocosProjectConfig cocosProjectConfig = ConfigurationManager.getConfiguration(PathManager.instance.getCocosProjectConfigPath(proj)).getConfig(CocosProjectConfig.class);
        return cocosProjectConfig.getAssets().getIgnores().contains(fileName);
    }
}

