/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.ccdt.common.CommonConsole;
import org.ccdt.common.utils.AndroidUtil;
import org.ccdt.common.utils.CommandHelper;
import org.ccdt.common.utils.ParameterInfo;
import org.ccdt.common.utils.SystemInfo;

public class FileUtil {
    public static void copyFileToPackage(String filePath, String packagePath) throws IOException {
        String jarSigner;
        if (packagePath.endsWith(".app")) {
            File srcFile = new File(filePath);
            File dstFile = new File(String.valueOf(packagePath) + "/" + srcFile.getName());
            FileUtil.copyFile(srcFile, dstFile);
        } else if (packagePath.endsWith(".apk") && (jarSigner = AndroidUtil.getJarSignerPath()) != null) {
            FileUtil.copyFileToAPK(filePath, packagePath, jarSigner);
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        FileInputStream fi = null;
        FileOutputStream fo = null;
        AbstractInterruptibleChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            fi = new FileInputStream(src);
            fo = new FileOutputStream(dst);
            in = fi.getChannel();
            out = fo.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
        }
        finally {
            try {
                fi.close();
                fo.close();
                in.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyDirectory(String src, String dst) throws IOException {
        File[] files;
        File srcFile = new File(src);
        if (!srcFile.exists()) {
            return;
        }
        new File(dst).mkdir();
        File[] fileArray = files = srcFile.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                File dstFile = new File(String.valueOf(new File(dst).getAbsolutePath()) + File.separator + file.getName());
                FileUtil.copyFile(file, dstFile);
            }
            if (file.isDirectory()) {
                FileUtil.copyDirectory(String.valueOf(src) + File.separator + file.getName(), String.valueOf(dst) + File.separator + file.getName());
            }
            ++n2;
        }
    }

    public static void deleteDirectory(String directoryPath) throws IOException {
        File file = new File(directoryPath);
        if (file.exists() && file.isDirectory()) {
            if (file.listFiles().length == 0) {
                file.delete();
            } else {
                File[] files;
                File[] fileArray = files = file.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        FileUtil.deleteDirectory(f.getAbsolutePath());
                    }
                    FileUtil.deleteFile(f);
                    ++n2;
                }
                FileUtil.deleteDirectory(file.getAbsolutePath());
            }
        }
    }

    public static void deleteFile(File file) throws IOException {
        if (file.exists() && file.isFile()) {
            file.delete();
        }
    }

    public static boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    public static String getSymlink(File file) throws IOException {
        if (FileUtil.isSymlink(file)) {
            return file.getCanonicalPath();
        }
        return null;
    }

    private static void copyFileToAPK(String filePath, String packagePath, String jarSigner) throws IOException {
        File packageFile = new File(packagePath);
        File srcFile = new File(filePath);
        if (!srcFile.exists() || !packageFile.exists()) {
            return;
        }
        String workingPath = packageFile.getParent();
        String assetsDirectory = String.valueOf(workingPath) + "/" + "assets";
        FileUtil.deleteDirectory(assetsDirectory);
        File assetsFile = new File(assetsDirectory);
        assetsFile.mkdir();
        File dstFile = new File(String.valueOf(assetsDirectory) + "/" + srcFile.getName());
        FileUtil.copyFile(srcFile, dstFile);
        String aapt = AndroidUtil.getAaptPath();
        File workDir = packageFile.getParentFile();
        String relativePath = "assets/" + srcFile.getName();
        CommandHelper.ProcessListener listener = new CommandHelper.ProcessListener(){

            @Override
            public void readLine(String line) {
            }

            @Override
            public void processComplete() {
            }

            @Override
            public void processFailed() {
            }
        };
        if (SystemInfo.isMac) {
            CommonConsole.getInstance().chmod(aapt);
        }
        CommandHelper.execute(aapt, new ParameterInfo[]{new ParameterInfo(1, "r"), new ParameterInfo(0, packagePath), new ParameterInfo(1, "META-INF/CERT.RSA")}, null, listener, workDir, false);
        CommandHelper.execute(aapt, new ParameterInfo[]{new ParameterInfo(1, "r"), new ParameterInfo(0, packagePath), new ParameterInfo(1, "META-INF/CERT.SF")}, null, listener, workDir, false);
        CommandHelper.execute(aapt, new ParameterInfo[]{new ParameterInfo(1, "r"), new ParameterInfo(0, packagePath), new ParameterInfo(1, "META-INF/MANIFEST.MF")}, null, listener, workDir, false);
        CommandHelper.execute(aapt, new ParameterInfo[]{new ParameterInfo(1, "r"), new ParameterInfo(0, packagePath), new ParameterInfo(0, relativePath)}, null, listener, workDir, false);
        CommandHelper.execute(aapt, new ParameterInfo[]{new ParameterInfo(1, "a"), new ParameterInfo(0, packagePath), new ParameterInfo(0, relativePath)}, null, listener, workDir, false);
        String keystorePath = AndroidUtil.getKeyStorePath();
        if (SystemInfo.isMac) {
            CommonConsole.getInstance().chmod(jarSigner);
        }
        ParameterInfo[] parameters = new ParameterInfo[]{new ParameterInfo(1, "-keystore"), new ParameterInfo(0, keystorePath), new ParameterInfo(1, "-storepass"), new ParameterInfo(1, "android"), new ParameterInfo(1, "-keypass"), new ParameterInfo(1, "android"), new ParameterInfo(0, packageFile.getName()), new ParameterInfo(1, "androiddebugkey"), new ParameterInfo(1, "-sigalg"), new ParameterInfo(1, "MD5withRSA"), new ParameterInfo(1, "-digestalg"), new ParameterInfo(1, "SHA1")};
        CommandHelper.execute(jarSigner, parameters, null, listener, workDir, false);
        FileUtil.deleteDirectory(assetsDirectory);
    }
}

