/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.ccdt.common.utils.ConsoleFactory;
import org.ccdt.common.utils.ParameterInfo;
import org.ccdt.common.utils.SystemInfo;

public class CommandHelper {
    public static void execute(String cmd, ParameterInfo[] parameters, String[] envp, ProcessListener processListener, File dir, boolean output) {
        if (cmd.indexOf(" ") > -1) {
            cmd = "\"" + cmd + "\"";
        }
        if (parameters != null && parameters.length > 0) {
            int i = 0;
            while (i < parameters.length) {
                if (parameters[i].getState() == 0 && parameters[i].getParameter().indexOf(" ") > -1) {
                    parameters[i].setParameter("\"" + parameters[i].getParameter() + "\"");
                }
                cmd = String.valueOf(cmd) + " " + parameters[i].getParameter();
                ++i;
            }
            CommandHelper.execute(cmd, envp, processListener, dir, output);
        } else {
            CommandHelper.execute(cmd, envp, processListener, dir, output);
        }
    }

    public static void execute(String cmd, String[] envp, ProcessListener processListener, File dir) {
        CommandHelper.execute(cmd, envp, processListener, dir, true);
    }

    public static void execute(String cmd, String[] envp, ProcessListener processListener, File dir, boolean output) {
        CommandHelper.execute(cmd, envp, processListener, dir, output, null);
    }

    public static void execute(String cmd, String[] envp, ProcessListener processListener, File dir, String charsetName) {
        CommandHelper.execute(cmd, envp, processListener, dir, true, charsetName);
    }

    public static void execute(String cmd, String[] envp, final ProcessListener processListener, File dir, final boolean output, final String charsetName) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process proc = null;
            if (SystemInfo.isMac) {
                String[] command = new String[]{"/bin/sh", "-c", cmd};
                proc = runtime.exec(command, envp, dir);
            } else {
                proc = runtime.exec(cmd, envp, dir);
            }
            final InputStream inputStream = proc.getInputStream();
            final InputStream errorStream = proc.getErrorStream();
            new Thread(){

                @Override
                public void run() {
                    InputStreamReader is = null;
                    BufferedReader er = null;
                    try {
                        try {
                            is = charsetName != null ? new InputStreamReader(errorStream, charsetName) : new InputStreamReader(errorStream);
                            er = new BufferedReader(is);
                            String line = null;
                            while ((line = er.readLine()) != null) {
                                if (output) {
                                    ConsoleFactory.showLine(line, true);
                                }
                                if (processListener == null) continue;
                                processListener.readLine(line);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                er.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    finally {
                        try {
                            er.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    InputStreamReader is = null;
                    BufferedReader br = null;
                    String line = null;
                    try {
                        try {
                            is = charsetName != null ? new InputStreamReader(inputStream, charsetName) : new InputStreamReader(inputStream);
                            br = new BufferedReader(is);
                            while ((line = br.readLine()) != null) {
                                if (output) {
                                    ConsoleFactory.showLine(line, true);
                                }
                                if (processListener == null) continue;
                                processListener.readLine(line);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                br.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    finally {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
            if (processListener != null) {
                int exitVal = proc.waitFor();
                if (exitVal == 0) {
                    processListener.processComplete();
                } else {
                    processListener.processFailed();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void executeInSynchronous(String cmd, ParameterInfo[] parameters, String[] envp, ProcessListener processListener, File dir, boolean output, String charsetName) {
        if (cmd.indexOf(" ") > -1) {
            cmd = "\"" + cmd + "\"";
        }
        if (parameters != null && parameters.length > 0) {
            int i = 0;
            while (i < parameters.length) {
                if (parameters[i].getState() == 0 && parameters[i].getParameter().indexOf(" ") > -1) {
                    parameters[i].setParameter("\"" + parameters[i].getParameter() + "\"");
                }
                cmd = String.valueOf(cmd) + " " + parameters[i].getParameter();
                ++i;
            }
        }
        try {
            Process proc;
            block38: {
                InputStream inputStream;
                block36: {
                    Runtime runtime = Runtime.getRuntime();
                    proc = null;
                    if (SystemInfo.isMac) {
                        String[] command = new String[]{"/bin/sh", "-c", cmd};
                        proc = runtime.exec(command, envp, dir);
                    } else {
                        proc = runtime.exec(cmd, envp, dir);
                    }
                    inputStream = proc.getInputStream();
                    InputStream errorStream = proc.getErrorStream();
                    BufferedReader er = new BufferedReader(new InputStreamReader(errorStream));
                    String eline = null;
                    try {
                        try {
                            while ((eline = er.readLine()) != null) {
                                if (output) {
                                    ConsoleFactory.showLine(eline, true);
                                }
                                if (processListener == null) continue;
                                processListener.readLine(eline);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                er.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                            break block36;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            er.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        er.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                InputStreamReader is = null;
                BufferedReader br = null;
                String iline = null;
                try {
                    try {
                        is = charsetName != null ? new InputStreamReader(inputStream, charsetName) : new InputStreamReader(inputStream);
                        br = new BufferedReader(is);
                        while ((iline = br.readLine()) != null) {
                            if (output) {
                                ConsoleFactory.showLine(iline, true);
                            }
                            if (processListener == null) continue;
                            processListener.readLine(iline);
                        }
                        br.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            br.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                        break block38;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (processListener != null) {
                int exitVal = proc.waitFor();
                if (exitVal == 0) {
                    processListener.processComplete();
                } else {
                    processListener.processFailed();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getPath(String cmd) {
        if (cmd == null) {
            return "";
        }
        final ArrayList paths = new ArrayList();
        CommandHelper.executeInSynchronous("which", new ParameterInfo[]{new ParameterInfo(cmd)}, null, new ProcessListener(){

            @Override
            public void readLine(String line) {
                File f = new File(line);
                if (f.exists()) {
                    paths.add(f.getAbsolutePath());
                }
            }

            @Override
            public void processFailed() {
            }

            @Override
            public void processComplete() {
            }
        }, null, false, null);
        if (paths.size() == 0) {
            return "";
        }
        return (String)paths.get(0);
    }

    public static interface ProcessListener {
        public void readLine(String var1);

        public void processComplete();

        public void processFailed();
    }
}

