/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.utils.FileUtil;
import org.ccdt.common.utils.Messages;
import org.ccdt.common.utils.SystemInfo;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class AndroidUtil {
    public static final String FD_PLATFORM_TOOLS = "platform-tools";
    public static final String OS_SDK_PLATFORM_TOOLS_FOLDER = "platform-tools" + File.separator;
    public static final String FD_BUILD_TOOLS = "build-tools";
    public static final String OS_SDK_BUILD_TOOLS_FOLDER = "build-tools" + File.separator;
    public static final String FN_AAPT = "aapt" + AndroidUtil.ext(".exe", "");
    public static final String FN_JARSIGNER = "jarsigner" + AndroidUtil.ext(".exe", "");
    public static final String DEBUG_KEYSTORE = "debug.keystore";
    public static final String PLUGIN_TOOLS = "/tools/";
    private static final Pattern packagePattern = Pattern.compile("package\\s*:\\s*name='(\\S*)'\\s*.*");
    private static final Pattern activityPattern = Pattern.compile("launchable-activity\\s*:\\s*name='(\\S*)'\\s*.*");
    private static String packageName = null;
    private static String activityName = null;
    private static IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
    private static String sdk_root = null;

    private static String ext(String windowsExtension, String nonWindowsExtension) {
        if (SystemInfo.isWindows) {
            return windowsExtension;
        }
        return nonWindowsExtension;
    }

    public static String getAaptPath() {
        return AndroidUtil.aaptPath();
    }

    private static String aaptPath() {
        String path = null;
        try {
            path = FileLocator.toFileURL((URL)CommonPlugin.getDefault().getBundle().getEntry(PLUGIN_TOOLS + FN_AAPT)).getFile();
            path = new File(path).getAbsolutePath();
        }
        catch (IOException e) {
            CommonPlugin.logError("get aapt path in plugin error", e);
        }
        return path;
    }

    public static String getJarSignerPath() {
        return AndroidUtil.jarSignerPath();
    }

    private static String jarSignerPath() {
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        String jdk = store.getString("org.ccdt.common.jdk_path");
        if (jdk == null || jdk.equals("")) {
            return null;
        }
        String jarsignerPath = null;
        jarsignerPath = jdk.endsWith("bin") ? String.valueOf(jdk) + File.separator + FN_JARSIGNER : String.valueOf(jdk) + File.separator + "bin" + File.separator + FN_JARSIGNER;
        if (!new File(jarsignerPath).exists()) {
            return null;
        }
        return jarsignerPath;
    }

    public static String getKeyStorePath() {
        return AndroidUtil.keyStorePath();
    }

    private static String keyStorePath() {
        String path = null;
        try {
            path = FileLocator.toFileURL((URL)CommonPlugin.getDefault().getBundle().getEntry("/tools/debug.keystore")).getFile();
            path = new File(path).getAbsolutePath();
        }
        catch (IOException iOException) {}
        return path;
    }

    public static String extractPackageName(String apkPath) {
        AndroidUtil.extractPackageAndActivity(apkPath);
        return packageName;
    }

    public static String extractLaunchableActivity(String apkPath) {
        AndroidUtil.extractPackageAndActivity(apkPath);
        return activityName;
    }

    public static String[] extractPackageAndActivity(String apkPath) {
        packageName = null;
        activityName = null;
        try {
            if (SystemInfo.isMac) {
                Process p = DebugPlugin.exec((String[])new String[]{"chmod", "+x", AndroidUtil.aaptPath()}, null);
                p.waitFor();
            }
            Process proc = DebugPlugin.exec((String[])new String[]{AndroidUtil.aaptPath(), "d", "badging", apkPath}, null);
            InputStream is = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = br.readLine()) != null) {
                Matcher m = packagePattern.matcher(line);
                if (m.matches()) {
                    packageName = m.group(1);
                    continue;
                }
                m = activityPattern.matcher(line);
                if (m.matches()) {
                    activityName = m.group(1);
                    continue;
                }
                if (packageName == null || activityName == null) continue;
                br.close();
                break;
            }
        }
        catch (Exception e) {
            CommonPlugin.logError("extractPackageAndActivity error", e);
        }
        return new String[]{packageName, activityName};
    }

    public static boolean checkAndroidSDK() {
        sdk_root = store.getString("org.ccdt.common.sdk_path");
        if (sdk_root == null || "".equals(sdk_root)) {
            Dialogs.showPreferencesDialog(Messages.android_util_android_sdk_not_setted_msg, "org.ccdt.common.ui.prefs.cocos");
            return false;
        }
        if (!new File(sdk_root).exists()) {
            Dialogs.showPreferencesDialog(Messages.android_util_android_sdk_not_exist_msg, "org.ccdt.common.ui.prefs.cocos");
            return false;
        }
        return true;
    }

    public static String checkKeyStore(String alias, String keypass, String keystore, String storepass) {
        StringBuffer sb;
        block13: {
            File keystoreFile = new File(keystore);
            assert (keystoreFile.exists());
            File keyStoreTempFile = new File(String.valueOf(keystore) + "_temp");
            sb = new StringBuffer("");
            try {
                try {
                    FileUtil.copyFile(keystoreFile, keyStoreTempFile);
                    String cmd = String.format("keytool -keypasswd -alias %s -keypass %s -new %s -keystore %s -storepass %s", alias, keypass, keypass, keyStoreTempFile.getAbsolutePath(), storepass);
                    Process proc = Runtime.getRuntime().exec(cmd);
                    InputStream is = proc.getInputStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        FileUtil.deleteFile(keyStoreTempFile);
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    FileUtil.deleteFile(keyStoreTempFile);
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                FileUtil.deleteFile(keyStoreTempFile);
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    public static boolean checkKeyStoreValidity(String alias, String keystore, String storepass) {
        File keystoreFile = new File(keystore);
        assert (keystoreFile.exists());
        StringBuffer sb = new StringBuffer();
        boolean result = true;
        try {
            String cmd = String.format("keytool -list -v -alias %s -keystore %s -storepass %s", alias, keystoreFile.getAbsolutePath(), storepass);
            Process proc = Runtime.getRuntime().exec(cmd);
            InputStream is = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException iOException) {}
        Pattern datePattern = Pattern.compile("[\\w\\W]*((Mon|Tue|Wed|Thu|Fri|Sat|Sun)\\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s(\\d{2})\\s([01]\\d|2[0-3]):([0-5]\\d):([0-5]\\d)\\s(\\w{3})\\s(\\d{4}))[\\w\\W]*");
        Matcher m = datePattern.matcher(sb.toString());
        if (m.matches()) {
            String datestr = m.group(1);
            try {
                SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                result = format.parse(datestr).after(new Date());
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

