/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.wizard.pages;

import java.io.File;
import org.ccdt.common.CommonProject;
import org.ccdt.common.CommoniOS;
import org.ccdt.common.messages.Messages;
import org.ccdt.common.ui.dialogs.WizardDialogWithCloseButton;
import org.ccdt.common.ui.wizard.pages.PublishiOSWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class PublishiOSWizardOptionPage
extends WizardPage {
    private Group certificateGroup;
    private Group buildGroup;
    private Label certificatesLabel;
    private Label targetsLabel;
    private Combo certificatesCombo;
    private Combo targetsCombo;
    private Button cleanButton;
    private String targetName = "";
    private String certificateName = "";
    private boolean clean = false;

    public PublishiOSWizardOptionPage() {
        super(Messages.publish_ios_config_option_page_title);
        this.setTitle(Messages.publish_ios_config_option_page_title);
    }

    public void setVisible(boolean visible) {
        IWizardContainer container = this.getWizard().getContainer();
        if (container instanceof WizardDialogWithCloseButton) {
            if (visible) {
                ((WizardDialogWithCloseButton)container).getWizardNextButton().setText("Generate >");
                String[] certificates = CommoniOS.getDistributionCertificates();
                if (certificates.length > 0) {
                    this.certificatesCombo.setItems(certificates);
                    this.certificatesCombo.setText(certificates[0]);
                    this.certificateName = this.certificatesCombo.getItem(this.certificatesCombo.getSelectionIndex());
                }
                IProject proj = ((PublishiOSWizard)this.getWizard()).getCurrProject();
                String projectName = String.valueOf(CommonProject.getProjectName(proj)) + ".xcodeproj";
                String projectPath = CommonProject.getNativeProjectPathByPlatform(proj, CommonProject.PlatformMode.IOS_MAC_PLATFORM);
                String[] targets = CommoniOS.getTargetsWithProject(String.valueOf(projectPath) + File.separator + projectName);
                if (targets.length > 0) {
                    this.targetsCombo.setItems(targets);
                    this.targetsCombo.setText(targets[0]);
                    this.targetName = this.targetsCombo.getItem(this.targetsCombo.getSelectionIndex());
                }
                this.onDialogChanged();
            } else {
                ((WizardDialogWithCloseButton)container).getWizardNextButton().setText("Next >");
            }
        }
        super.setVisible(visible);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        this.setControl((Control)container);
        this.certificateGroup = new Group(container, 0);
        this.certificateGroup.setLayout((Layout)new GridLayout(2, false));
        this.certificateGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.certificateGroup.setText(Messages.publish_ios_config_certificates_group);
        this.certificatesLabel = new Label((Composite)this.certificateGroup, 0);
        this.certificatesLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.certificatesLabel.setText(Messages.publish_ios_config_certificates);
        this.certificatesCombo = new Combo((Composite)this.certificateGroup, 12);
        this.certificatesCombo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.certificatesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishiOSWizardOptionPage.this.certificateName = PublishiOSWizardOptionPage.this.certificatesCombo.getItem(PublishiOSWizardOptionPage.this.certificatesCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Link distributionLink = new Link((Composite)this.certificateGroup, 0);
        distributionLink.setText(String.valueOf(Messages.publish_ios_config_distribution_description) + " " + "<a>" + Messages.publish_ios_config_distribution_title + "</a>");
        distributionLink.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        distributionLink.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishiOSWizardOptionPage.this.launchingDistirbutionGuide();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.buildGroup = new Group(container, 0);
        this.buildGroup.setLayout((Layout)new GridLayout(2, false));
        this.buildGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.buildGroup.setText(Messages.publish_ios_config_build_group);
        this.targetsLabel = new Label((Composite)this.buildGroup, 0);
        this.targetsLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.targetsLabel.setText(Messages.publish_ios_config_targets);
        this.targetsCombo = new Combo((Composite)this.buildGroup, 12);
        this.targetsCombo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.targetsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishiOSWizardOptionPage.this.targetName = PublishiOSWizardOptionPage.this.targetsCombo.getItem(PublishiOSWizardOptionPage.this.targetsCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.cleanButton = new Button((Composite)this.buildGroup, 32);
        this.cleanButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.cleanButton.setText(Messages.publish_ios_config_clean);
        this.cleanButton.setSelection(false);
        this.cleanButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishiOSWizardOptionPage.this.clean = PublishiOSWizardOptionPage.this.cleanButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private boolean onDialogChanged() {
        if (this.targetsCombo.getItemCount() == 0) {
            this.updateStatus(Messages.publish_ios_validate_targets, 3);
            return false;
        }
        if (this.certificatesCombo.getItemCount() == 0) {
            this.updateStatus(Messages.publish_ios_validate_certificates, 3);
            return false;
        }
        return true;
    }

    private void updateStatus(String message, int type) {
        this.setMessage(message, type);
        this.setPageComplete(message == null);
    }

    private void launchingDistirbutionGuide() {
        Program.launch((String)Messages.publish_ios_config_distribution_link);
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getCertificateName() {
        return this.certificateName;
    }

    public boolean useClean() {
        return this.clean;
    }
}

