/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.wizard.pages;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.ccdt.common.CommonConsole;
import org.ccdt.common.CommonProject;
import org.ccdt.common.messages.Messages;
import org.ccdt.common.ui.wizard.pages.PublishiOSWizard;
import org.ccdt.common.ui.wizard.pages.PublishiOSWizardOptionPage;
import org.ccdt.common.utils.ParameterInfo;
import org.ccdt.statistics.constant.FeatureEnum;
import org.ccdt.statistics.constant.FeatureValue;
import org.ccdt.statistics.ga.EventInfoFactory;
import org.ccdt.statistics.ga.Tracker;
import org.ccdt.statistics.track.TrackUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PublishiOSWizardLogPage
extends WizardPage {
    private StyledText styledText;
    private Button locationButton;
    private String publishPath = "";
    private boolean buildResult = false;
    private boolean signResult = false;
    private String IOS_PROJECT_EXT = ".xcodeproj";
    private String APP_EXT = ".app";
    private String IPA_EXT = ".ipa";

    public PublishiOSWizardLogPage() {
        super("PublishiOSWizardLogPage");
        this.setTitle("Log Page");
    }

    public IWizardPage getPreviousPage() {
        return null;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.styledText = new StyledText(container, 2048);
        this.styledText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.styledText.setEditable(false);
        Composite comp = new Composite(container, 0);
        comp.setLayout((Layout)new GridLayout(4, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.locationButton = new Button(comp, 8);
        this.locationButton.setText(Messages.publish_ios_config_open_location);
        this.locationButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.locationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishiOSWizardLogPage.this.openPackageLocation(PublishiOSWizardLogPage.this.publishPath);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IProject proj = ((PublishiOSWizard)this.getWizard()).getCurrProject();
            this.publishPath = CommonProject.getPublishPathByPlatform(proj, CommonProject.PlatformMode.IOS_MAC_PLATFORM);
            this.publish();
        }
    }

    private void publish() {
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    PublishiOSWizardOptionPage previousPage = ((PublishiOSWizard)PublishiOSWizardLogPage.this.getWizard()).getOptionsPage();
                    monitor.beginTask("Building...", -1);
                    monitor.subTask("Start to build package of ios platform");
                    IProject proj = ((PublishiOSWizard)PublishiOSWizardLogPage.this.getWizard()).getCurrProject();
                    String xcodebuildPath = ((PublishiOSWizard)PublishiOSWizardLogPage.this.getWizard()).getXCodeBuild();
                    String projectName = CommonProject.getProjectName(proj);
                    String iosProjectName = String.valueOf(projectName) + PublishiOSWizardLogPage.this.IOS_PROJECT_EXT;
                    String projectPath = String.valueOf(CommonProject.getNativeProjectPathByPlatform(proj, CommonProject.PlatformMode.IOS_MAC_PLATFORM)) + File.separator + iosProjectName;
                    ParameterInfo[] parameters = new ParameterInfo[]{new ParameterInfo("-project"), new ParameterInfo(0, projectPath), new ParameterInfo("-target"), new ParameterInfo(0, previousPage.getTargetName()), new ParameterInfo("-sdk"), new ParameterInfo("iphoneos"), new ParameterInfo("CONFIGURATION_BUILD_DIR=\"" + PublishiOSWizardLogPage.this.publishPath + "\""), new ParameterInfo("CODE_SIGN_IDENTITY=\"" + previousPage.getCertificateName() + "\"")};
                    if (previousPage.useClean()) {
                        CommonConsole.getInstance().command(xcodebuildPath, new ParameterInfo[]{new ParameterInfo("clean"), new ParameterInfo("-project"), new ParameterInfo(0, projectPath), new ParameterInfo("-target"), new ParameterInfo(0, previousPage.getTargetName())}, null, null);
                    }
                    PublishiOSWizardLogPage.this.buildResult = CommonConsole.getInstance().command(xcodebuildPath, parameters, null, null);
                    if (PublishiOSWizardLogPage.this.getBuildResult()) {
                        String xcrunPath = ((PublishiOSWizard)PublishiOSWizardLogPage.this.getWizard()).getXCRun();
                        String appPath = String.valueOf(PublishiOSWizardLogPage.this.publishPath) + File.separator + previousPage.getTargetName() + PublishiOSWizardLogPage.this.APP_EXT;
                        String ipaPath = String.valueOf(PublishiOSWizardLogPage.this.publishPath) + File.separator + previousPage.getTargetName() + PublishiOSWizardLogPage.this.IPA_EXT;
                        ParameterInfo[] toipa = new ParameterInfo[]{new ParameterInfo("-sdk"), new ParameterInfo("iphoneos"), new ParameterInfo("PackageApplication"), new ParameterInfo("-v"), new ParameterInfo(0, appPath), new ParameterInfo("-o"), new ParameterInfo(0, ipaPath), new ParameterInfo("--sign"), new ParameterInfo(0, previousPage.getCertificateName())};
                        PublishiOSWizardLogPage.this.signResult = CommonConsole.getInstance().command(xcrunPath, toipa, null, null);
                    }
                    monitor.subTask("Finished");
                    try {
                        ((PublishiOSWizard)PublishiOSWizardLogPage.this.getWizard()).getCurrProject().getProject().refreshLocal(2, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            pmd.run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.buildResult();
    }

    private boolean getBuildResult() {
        return this.buildResult;
    }

    private boolean getSignResult() {
        return this.signResult;
    }

    private void buildResult() {
        String text = null;
        if (this.getSignResult()) {
            String id = ((PublishiOSWizard)this.getWizard()).getPerspectiveId();
            if (id.equals("org.ccdt.js.ui.perspectives.CocosPerspective")) {
                TrackUtils.trackFeatureValue((String)FeatureEnum.PUBLISH_JS_PROJECT.getValue(), (long)FeatureValue.PUBLISH_IOS);
                Tracker.getInstance().sendEvent(EventInfoFactory.getInstance().genPublishJSRuntimeEvent("pb_ios"));
            } else if (id.equals("org.ccdt.lua.ui.perspectives.CocosPerspectives")) {
                TrackUtils.trackFeatureValue((String)FeatureEnum.PUBLISH_LUA_PROJECT.getValue(), (long)FeatureValue.PUBLISH_IOS);
                Tracker.getInstance().sendEvent(EventInfoFactory.getInstance().genPublishLuaRuntimeEvent("pb_ios"));
            }
            text = String.valueOf(Messages.publish_ios_config_build_success) + "\n";
            File f = new File(this.publishPath);
            if (f.exists()) {
                text = String.valueOf(text) + Messages.publish_ios_config_save + " " + f.getPath() + "\n";
            }
        } else {
            text = String.valueOf(Messages.publish_ios_config_build_failed) + "\n";
        }
        String result = "";
        if (text != null) {
            result = String.valueOf(result) + text;
        }
        this.styledText.setText(result);
    }

    private void openPackageLocation(String filePath) {
        Program.launch((String)filePath);
    }
}

