/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.wizard.pages;

import org.ccdt.common.CommonAndroid;
import org.ccdt.common.CommonConsole;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.model.CocosProjectConfig;
import org.ccdt.common.ui.wizard.pages.PublishAndroidWiazrdLogPage;
import org.ccdt.common.ui.wizard.pages.PublishAndroidWiazrdOptionPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PublishAndroidWizard
extends Wizard {
    private PublishAndroidWiazrdOptionPage optionPage;
    private PublishAndroidWiazrdLogPage logPage;
    private IProject currProject;
    private String engineRoot;
    private String perspectiveId;
    private boolean hasSharedObject = false;
    private boolean hasNative = false;
    private float consoleVersion = 0.0f;

    public PublishAndroidWizard(IProject proj) {
        this.setWindowTitle("Publish Android Package Wizard");
        this.currProject = proj;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IPerspectiveDescriptor PerspectiveDescriptor = activePage.getPerspective();
        this.perspectiveId = PerspectiveDescriptor.getId();
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        if (this.perspectiveId.equals("org.ccdt.lua.ui.perspectives.CocosPerspectives")) {
            this.engineRoot = store.getString("org.ccdt.common.lua_engine_path");
        } else if (this.perspectiveId.equals("org.ccdt.js.ui.perspectives.CocosPerspective")) {
            this.engineRoot = store.getString("org.ccdt.common.js_engine_path");
        }
        this.consoleVersion = CommonConsole.getInstance().getConsoleVersion();
        this.setDefaultPageImageDescriptor(CommonPlugin.getImageDescriptor("icons/package_apk_wizard_titlebar.png"));
    }

    public void addPages() {
        try {
            this.hasSharedObject = CommonAndroid.getInstance().checkSharedObject(this.getProject());
            CocosProjectConfig cocosProjectConfig = ConfigurationManager.getConfiguration(PathManager.instance.getCocosProjectConfigPath(this.getProject())).getConfig(CocosProjectConfig.class);
            this.hasNative = cocosProjectConfig.isHasNative();
            this.optionPage = new PublishAndroidWiazrdOptionPage();
            this.addPage((IWizardPage)this.optionPage);
            this.logPage = new PublishAndroidWiazrdLogPage();
            this.addPage((IWizardPage)this.logPage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean performFinish() {
        return false;
    }

    public String getEnginePath() {
        if (this.engineRoot == null) {
            return "";
        }
        return this.engineRoot;
    }

    public String getPerspectiveId() {
        if (this.perspectiveId == null) {
            return "";
        }
        return this.perspectiveId;
    }

    public IProject getProject() {
        return this.currProject;
    }

    public String getProjectPath() {
        if (this.currProject == null) {
            return "";
        }
        return this.currProject.getProject().getLocation().toString();
    }

    public String getProjectName() {
        if (this.currProject == null) {
            return "";
        }
        return this.currProject.getProject().getName();
    }

    public PublishAndroidWiazrdOptionPage getOptionsPage() {
        return this.optionPage;
    }

    public boolean hasNative() {
        return this.hasNative;
    }

    public boolean hasSharedObject() {
        return this.hasSharedObject;
    }

    public float getConsoleVersion() {
        return this.consoleVersion;
    }
}

