/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.wizard.pages;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import org.ccdt.common.CommonAndroid;
import org.ccdt.common.CommonProject;
import org.ccdt.common.messages.Messages;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.ui.dialogs.WizardDialogWithCloseButton;
import org.ccdt.common.ui.wizard.pages.PublishAndroidWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PublishAndroidWiazrdOptionPage
extends WizardPage {
    private Group keystoreGroup;
    private Group buildGroup;
    private Button debugStore;
    private Button releaseStore;
    private Button compile;
    private Label keyPasswordLabel;
    private Label aliasNameLabel;
    private Label aliasPasswordLabel;
    private Label androidSDKLabel;
    private FileFieldEditor keyPath;
    private Text keyPasswordText;
    private Text aliasNameText;
    private Text aliasPasswordText;
    private Combo androidSDKCombo;
    private String androidSDKVersion = "";
    private String keyStorePath = "";
    private String keyStorePass = "";
    private String aliasName = "";
    private String aliasPass = "";
    private boolean useDebugKeystore = false;
    private boolean useNDKCompile = false;
    private static Pattern ksPattern = Pattern.compile("^key.store[ ]{0,}=.*");
    private static Pattern kspPattern = Pattern.compile("^key.store.password[ ]{0,}=.*");
    private static Pattern kaPattern = Pattern.compile("^key.alias[ ]{0,}=.*");
    private static Pattern kapPattern = Pattern.compile("^key.alias.password[ ]{0,}=.*");

    public PublishAndroidWiazrdOptionPage() {
        super("PublishAndroidWiazrdOptionPage");
        this.setTitle(Messages.publish_android_config_option_page_title);
    }

    public void setVisible(boolean visible) {
        IWizardContainer container = this.getWizard().getContainer();
        if (container instanceof WizardDialogWithCloseButton) {
            if (visible) {
                ((WizardDialogWithCloseButton)container).getWizardNextButton().setText("Generate >");
                String[] SDKs = this.loadSDKs();
                this.androidSDKCombo.setItems(SDKs);
                if (SDKs.length > 0) {
                    this.androidSDKCombo.setText(SDKs[0]);
                    this.androidSDKVersion = this.androidSDKCombo.getItem(this.androidSDKCombo.getSelectionIndex());
                }
                this.onDialogChange();
            } else {
                ((WizardDialogWithCloseButton)container).getWizardNextButton().setText("Next >");
            }
        }
        super.setVisible(visible);
    }

    public IWizardPage getPreviousPage() {
        return null;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        this.setControl((Control)container);
        this.keystoreGroup = new Group(container, 0);
        this.keystoreGroup.setLayout((Layout)new GridLayout(3, false));
        this.keystoreGroup.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.keystoreGroup.setText(Messages.publish_android_config_keystore_group);
        Composite radioComposite = new Composite((Composite)this.keystoreGroup, 0);
        radioComposite.setLayout((Layout)new GridLayout(2, true));
        radioComposite.setLayoutData((Object)new GridData(4, 4, false, true, 3, 1));
        this.debugStore = new Button(radioComposite, 16);
        this.debugStore.setText(Messages.publish_android_config_debug_keystore);
        this.debugStore.setSelection(true);
        this.debugStore.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishAndroidWiazrdOptionPage.this.enableDefaultKeystore();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.releaseStore = new Button(radioComposite, 16);
        this.releaseStore.setText(Messages.publish_android_config_private_keystore);
        this.releaseStore.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishAndroidWiazrdOptionPage.this.disableDefaultKeystore();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.readKeyStoreInformation();
        this.keyPath = new FileFieldEditor("keypath", Messages.publish_android_config_keystore_path, (Composite)this.keystoreGroup);
        this.keyPath.getLabelControl((Composite)this.keystoreGroup).setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.keyPath.getTextControl((Composite)this.keystoreGroup).setText(this.keyStorePath);
        this.keyPath.getTextControl((Composite)this.keystoreGroup).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PublishAndroidWiazrdOptionPage.this.onDialogChange();
            }
        });
        this.keyPasswordLabel = new Label((Composite)this.keystoreGroup, 0);
        this.keyPasswordLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.keyPasswordLabel.setText(Messages.publish_android_config_keystore_password);
        this.keyPasswordText = new Text((Composite)this.keystoreGroup, 0x400800);
        this.keyPasswordText.setText(this.keyStorePass);
        this.keyPasswordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.keyPasswordText.setToolTipText(Messages.publish_android_config_keystore_password);
        this.keyPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PublishAndroidWiazrdOptionPage.this.onDialogChange();
            }
        });
        new Label((Composite)this.keystoreGroup, 0);
        this.aliasNameLabel = new Label((Composite)this.keystoreGroup, 0);
        this.aliasNameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.aliasNameLabel.setText(Messages.publish_android_config_keystore_alias_name);
        this.aliasNameText = new Text((Composite)this.keystoreGroup, 2048);
        this.aliasNameText.setText(this.aliasName);
        this.aliasNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.aliasNameText.setToolTipText(Messages.publish_android_config_keystore_alias_name);
        this.aliasNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PublishAndroidWiazrdOptionPage.this.onDialogChange();
            }
        });
        new Label((Composite)this.keystoreGroup, 0);
        this.aliasPasswordLabel = new Label((Composite)this.keystoreGroup, 0);
        this.aliasPasswordLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.aliasPasswordLabel.setText(Messages.publish_android_config_keystore_alias_password);
        this.aliasPasswordText = new Text((Composite)this.keystoreGroup, 0x400800);
        this.aliasPasswordText.setText(this.aliasPass);
        this.aliasPasswordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.aliasPasswordText.setToolTipText(Messages.publish_android_config_keystore_alias_password);
        this.aliasPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PublishAndroidWiazrdOptionPage.this.onDialogChange();
            }
        });
        this.buildGroup = new Group(container, 0);
        this.buildGroup.setLayout((Layout)new GridLayout(3, false));
        this.buildGroup.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.buildGroup.setText("Build Options");
        this.androidSDKLabel = new Label((Composite)this.buildGroup, 131072);
        this.androidSDKLabel.setText(Messages.publish_android_config_android_sdk);
        this.androidSDKCombo = new Combo((Composite)this.buildGroup, 12);
        this.androidSDKCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.androidSDKCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishAndroidWiazrdOptionPage.this.androidSDKVersion = PublishAndroidWiazrdOptionPage.this.androidSDKCombo.getItem(PublishAndroidWiazrdOptionPage.this.androidSDKCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.compile = new Button((Composite)this.buildGroup, 32);
        this.compile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.compile.setText(Messages.publish_android_config_ndk_compile);
        this.compile.setSelection(false);
        this.compile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishAndroidWiazrdOptionPage.this.useNDKCompile = PublishAndroidWiazrdOptionPage.this.compile.getSelection();
                String ndkPath = CommonAndroid.getInstance().getAndroidNDK();
                if (PublishAndroidWiazrdOptionPage.this.useNDKCompile && !CommonAndroid.getInstance().checkAndroidNDK(ndkPath)) {
                    Dialogs.showPreferencesDialog(Messages.warning_ndk, "org.ccdt.common.ui.prefs.cocos", 4);
                    if (!CommonAndroid.getInstance().checkAndroidNDK(ndkPath)) {
                        PublishAndroidWiazrdOptionPage.this.compile.setSelection(false);
                        PublishAndroidWiazrdOptionPage.this.useNDKCompile = false;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PublishAndroidWizard wizard = (PublishAndroidWizard)this.getWizard();
        this.selectionNDKCompile(wizard.hasNative() || !wizard.hasSharedObject() || !(wizard.getConsoleVersion() >= 0.6f));
        this.enableNDKCompile(wizard.hasSharedObject() && wizard.hasNative() && wizard.getConsoleVersion() >= 0.6f);
        this.enableDefaultKeystore();
    }

    public String getSDKVersion() {
        if (this.androidSDKVersion != null) {
            return this.androidSDKVersion;
        }
        return "";
    }

    public boolean useDebugKeyStore() {
        return this.useDebugKeystore;
    }

    public boolean useNDKCompile() {
        return this.useNDKCompile;
    }

    private boolean onDialogChange() {
        this.keyStorePath = this.keyPath.getTextControl((Composite)this.keystoreGroup).getText();
        this.keyStorePass = this.keyPasswordText.getText();
        this.aliasName = this.aliasNameText.getText();
        this.aliasPass = this.aliasPasswordText.getText();
        String[] items = this.androidSDKCombo.getItems();
        if (items.length == 0) {
            this.updateStatus(Messages.publish_android_validate_sdks, 3);
            return false;
        }
        if (!this.useDebugKeyStore()) {
            if (this.keyStorePath.length() == 0) {
                this.updateStatus(Messages.publish_android_validate_keystore_path, 3);
                return false;
            }
            File f = new File(this.keyStorePath);
            if (!f.isFile()) {
                this.updateStatus(Messages.publish_android_validate_keystore_path, 3);
                return false;
            }
            if (this.keyStorePass.length() == 0) {
                this.updateStatus(Messages.publish_android_validate_keystore_password, 3);
                return false;
            }
            if (this.aliasName.length() == 0) {
                this.updateStatus(Messages.publish_android_validate_keystore_alias_name, 3);
                return false;
            }
            if (this.aliasPass.length() == 0) {
                this.updateStatus(Messages.publish_android_validate_keystore_alias_password, 3);
                return false;
            }
        }
        this.updateStatus(null, 3);
        return true;
    }

    private void updateStatus(String message, int type) {
        this.setMessage(message, type);
        this.setPageComplete(message == null);
    }

    private String[] loadSDKs() {
        String androidSDKPath = CommonAndroid.getInstance().getAndroidSDK();
        if (androidSDKPath.length() != 0) {
            String[] fs;
            String platformsPath = String.valueOf(androidSDKPath) + File.separator + "platforms";
            File file = new File(platformsPath);
            if (!file.exists()) {
                return new String[0];
            }
            ArrayList<String> sdkArray = new ArrayList<String>();
            String[] stringArray = fs = file.list();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                String fn = stringArray[n2];
                File folder = new File(String.valueOf(platformsPath) + File.separator + fn);
                if (folder.isDirectory() && fn.indexOf("android-") > -1) {
                    sdkArray.add(fn);
                }
                ++n2;
            }
            String[] sdks = sdkArray.toArray(new String[sdkArray.size()]);
            return sdks;
        }
        return new String[0];
    }

    private void enableDefaultKeystore() {
        this.enableKeystoreInfo(false);
        this.useDebugKeystore = true;
        this.onDialogChange();
    }

    private void disableDefaultKeystore() {
        this.enableKeystoreInfo(true);
        this.useDebugKeystore = false;
        this.onDialogChange();
    }

    private void enableKeystoreInfo(boolean enable) {
        this.keyPath.setEnabled(enable, (Composite)this.keystoreGroup);
        this.keyPasswordLabel.setEnabled(enable);
        this.keyPasswordText.setEnabled(enable);
        this.aliasNameLabel.setEnabled(enable);
        this.aliasNameText.setEnabled(enable);
        this.aliasPasswordLabel.setEnabled(enable);
        this.aliasPasswordText.setEnabled(enable);
    }

    private void enableNDKCompile(boolean enable) {
        this.compile.setEnabled(enable);
    }

    private void selectionNDKCompile(boolean sel) {
        this.compile.setSelection(sel);
        this.useNDKCompile = sel;
    }

    private void readKeyStoreInformation() {
        IProject proj = ((PublishAndroidWizard)this.getWizard()).getProject();
        String path = String.valueOf(CommonProject.getNativeProjectPathByPlatform(proj, CommonProject.PlatformMode.ANDROID_PLATFORM)) + File.separator + "ant.properties";
        File file = new File(path);
        Properties antProps = new Properties();
        try {
            FileInputStream in = new FileInputStream(file);
            antProps.load(in);
            in.close();
        }
        catch (Exception exception) {
            return;
        }
        this.keyStorePath = antProps.getProperty("key.store");
        this.keyStorePath = this.keyStorePath == null ? "" : this.keyStorePath;
        this.keyStorePass = antProps.getProperty("key.store.password");
        this.keyStorePass = this.keyStorePass == null ? "" : this.keyStorePass;
        this.aliasName = antProps.getProperty("key.alias");
        this.aliasName = this.aliasName == null ? "" : this.aliasName;
        this.aliasPass = antProps.getProperty("key.alias.password");
        this.aliasPass = this.aliasPass == null ? "" : this.aliasPass;
    }

    public void writeKeyStoreInformation() {
        if (this.keyStorePath.length() == 0) {
            return;
        }
        IProject proj = ((PublishAndroidWizard)this.getWizard()).getProject();
        String path = String.valueOf(CommonProject.getNativeProjectPathByPlatform(proj, CommonProject.PlatformMode.ANDROID_PLATFORM)) + File.separator + "ant.properties";
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        boolean hasWriteKS = false;
        boolean hasWriteKSP = false;
        boolean hasWriteKA = false;
        boolean hasWriteKAP = false;
        this.keyStorePath = this.keyStorePath.replace("\\", "/");
        String keyStoreCfg = "key.store=" + this.keyStorePath;
        String keyStorePasswordCfg = "key.store.password=" + this.keyStorePass;
        String keyAliasCfg = "key.alias=" + this.aliasName;
        String keyAliasPasswordCfg = "key.alias.password=" + this.aliasPass;
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(fileStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (ksPattern.matcher(line).matches()) {
                    hasWriteKS = true;
                    line = keyStoreCfg;
                }
                if (kspPattern.matcher(line).matches()) {
                    hasWriteKSP = true;
                    line = keyStorePasswordCfg;
                }
                if (kaPattern.matcher(line).matches()) {
                    hasWriteKA = true;
                    line = keyAliasCfg;
                }
                if (kapPattern.matcher(line).matches()) {
                    hasWriteKAP = true;
                    line = keyAliasPasswordCfg;
                }
                stringBuffer.append(String.valueOf(line) + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!hasWriteKS) {
            stringBuffer.append(String.valueOf(keyStoreCfg) + "\n");
        }
        if (!hasWriteKSP) {
            stringBuffer.append(String.valueOf(keyStorePasswordCfg) + "\n");
        }
        if (!hasWriteKA) {
            stringBuffer.append(String.valueOf(keyAliasCfg) + "\n");
        }
        if (!hasWriteKAP) {
            stringBuffer.append(String.valueOf(keyAliasPasswordCfg) + "\n");
        }
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(path));
            output.write(stringBuffer.toString());
            output.flush();
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

