/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.wizard.pages;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.ccdt.common.CommonAndroid;
import org.ccdt.common.CommonConsole;
import org.ccdt.common.CommonProject;
import org.ccdt.common.config.IConfiguration;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.messages.Messages;
import org.ccdt.common.model.InstalledRuntimeConfig;
import org.ccdt.common.ui.wizard.pages.PublishAndroidWiazrdOptionPage;
import org.ccdt.common.ui.wizard.pages.PublishAndroidWizard;
import org.ccdt.common.utils.AndroidUtil;
import org.ccdt.common.utils.ConsoleFactory;
import org.ccdt.common.utils.ParameterInfo;
import org.ccdt.common.utils.SystemInfo;
import org.ccdt.statistics.constant.FeatureEnum;
import org.ccdt.statistics.constant.FeatureValue;
import org.ccdt.statistics.track.TrackUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PublishAndroidWiazrdLogPage
extends WizardPage {
    private PublishAndroidWiazrdOptionPage previousPage = null;
    private StyledText styledText;
    private Combo devicesCombo;
    private Label devicesLabel;
    private Button installButton;
    private Button locationButton;
    private HashMap<String, IDevice> devicesMap = new HashMap();
    private String publishPath = "";
    private final String apkRuntimePath = "runtime" + File.separator + "android";
    private String mode;
    private boolean androidResult = false;

    public PublishAndroidWiazrdLogPage() {
        super("PublishAndroidWiazrdLogPage");
    }

    public IWizardPage getPreviousPage() {
        return null;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.styledText = new StyledText(container, 2112);
        this.styledText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.styledText.setEditable(false);
        Composite comp = new Composite(container, 0);
        comp.setLayout((Layout)new GridLayout(4, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.devicesLabel = new Label(comp, 4);
        this.devicesLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.devicesLabel.setText("Devices: ");
        this.devicesCombo = new Combo(comp, 12);
        this.devicesCombo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.devicesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.installButton = new Button(comp, 8);
        this.installButton.setText(Messages.publish_android_config_install);
        this.installButton.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.installButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (PublishAndroidWiazrdLogPage.this.devicesCombo.getItemCount() == 0) {
                    PublishAndroidWiazrdLogPage.this.refreshDevices();
                    return;
                }
                PublishAndroidWiazrdLogPage.this.installAndroidPackage(PublishAndroidWiazrdLogPage.this.devicesCombo.getItem(PublishAndroidWiazrdLogPage.this.devicesCombo.getSelectionIndex()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite location = new Composite(container, 0);
        location.setLayout((Layout)new GridLayout(1, false));
        GridData locationData = new GridData(4, 0, true, false, 3, 1);
        locationData.widthHint = 300;
        location.setLayoutData((Object)locationData);
        this.locationButton = new Button(location, 8);
        this.locationButton.setText(Messages.publish_android_config_open_location);
        this.locationButton.setLayoutData((Object)new GridData(131072, 4, true, false, 1, 1));
        this.locationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PublishAndroidWiazrdLogPage.this.openPackageLocation(PublishAndroidWiazrdLogPage.this.publishPath);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IProject proj = ((PublishAndroidWizard)this.getWizard()).getProject();
            this.publishPath = CommonProject.getPublishPathByPlatform(proj, CommonProject.PlatformMode.ANDROID_PLATFORM);
            this.publish();
        }
    }

    private void publish() {
        this.enableInstall(false);
        this.enableOpenLcatoin(false);
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    PublishAndroidWiazrdLogPage.this.previousPage = ((PublishAndroidWizard)PublishAndroidWiazrdLogPage.this.getWizard()).getOptionsPage();
                    monitor.beginTask("Building...", -1);
                    monitor.subTask("Start to build package of android platform");
                    String cores = String.valueOf(SystemInfo.availableProcessors4Build());
                    String projectPath = ((PublishAndroidWizard)PublishAndroidWiazrdLogPage.this.getWizard()).getProjectPath();
                    String androidSDKVersion = PublishAndroidWiazrdLogPage.this.previousPage.getSDKVersion().substring(PublishAndroidWiazrdLogPage.this.previousPage.getSDKVersion().indexOf("-") + 1);
                    String ndkMode = PublishAndroidWiazrdLogPage.this.previousPage.useNDKCompile() ? "release" : "none";
                    PublishAndroidWiazrdLogPage.this.mode = PublishAndroidWiazrdLogPage.this.previousPage.useDebugKeyStore() ? "debug" : "release";
                    String[] env = CommonAndroid.getInstance().getSystemEnvironment();
                    ParameterInfo[] others = new ParameterInfo[]{new ParameterInfo("--ap"), new ParameterInfo(androidSDKVersion), new ParameterInfo("--ndk-mode"), new ParameterInfo(ndkMode), new ParameterInfo("-j"), new ParameterInfo(cores)};
                    PublishAndroidWiazrdLogPage.this.previousPage.writeKeyStoreInformation();
                    if (SystemInfo.isMac) {
                        String ant = String.valueOf(CommonAndroid.getInstance().getAnt()) + File.separator + "ant";
                        CommonConsole.getInstance().chmod(ant);
                    }
                    PublishAndroidWiazrdLogPage.this.androidResult = CommonConsole.getInstance().compile(projectPath, "android", PublishAndroidWiazrdLogPage.this.mode, others, env);
                    if (PublishAndroidWiazrdLogPage.this.androidResult && PublishAndroidWiazrdLogPage.this.mode.equals("debug")) {
                        PublishAndroidWiazrdLogPage.this.moveApkToPublish();
                    }
                    try {
                        ((PublishAndroidWizard)PublishAndroidWiazrdLogPage.this.getWizard()).getProject().getProject().refreshLocal(2, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    monitor.subTask("Finished");
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            pmd.run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.buildResult();
    }

    private boolean isAndroidResult() {
        return this.androidResult;
    }

    private void enableInstall(boolean enable) {
        this.devicesLabel.setEnabled(enable);
        this.devicesCombo.setEnabled(enable);
        this.installButton.setEnabled(enable);
    }

    private void enableOpenLcatoin(boolean enable) {
        this.locationButton.setEnabled(enable);
    }

    private void buildResult() {
        String androidText = "";
        if (this.isAndroidResult()) {
            String id = ((PublishAndroidWizard)this.getWizard()).getPerspectiveId();
            if (id.equals("org.ccdt.js.ui.perspectives.CocosPerspective")) {
                TrackUtils.trackFeatureValue((String)FeatureEnum.PUBLISH_JS_PROJECT.getValue(), (long)FeatureValue.PUBLISH_ANDROID);
            } else if (id.equals("org.ccdt.lua.ui.perspectives.CocosPerspectives")) {
                TrackUtils.trackFeatureValue((String)FeatureEnum.PUBLISH_LUA_PROJECT.getValue(), (long)FeatureValue.PUBLISH_ANDROID);
            }
            androidText = String.valueOf(Messages.publish_android_config_build_success) + "\n";
            File f = new File(this.publishPath);
            if (f.exists()) {
                androidText = String.valueOf(androidText) + Messages.publish_android_config_save + " " + f.getPath() + "\n";
            }
            this.refreshDevices();
            this.enableInstall(true);
            this.enableOpenLcatoin(true);
        } else {
            androidText = String.valueOf(Messages.publish_android_config_build_failed) + "\n";
        }
        String result = "";
        if (androidText.length() != 0) {
            result = String.valueOf(result) + androidText;
        }
        if ("".equals(result)) {
            result = "runtime was not built";
        }
        this.styledText.setText(result);
    }

    private void moveApkToPublish() {
        String projectName = ((PublishAndroidWizard)this.previousPage.getWizard()).getProjectName();
        String projectPath = ((PublishAndroidWizard)this.previousPage.getWizard()).getProjectPath();
        File dstDirectory = new File(this.publishPath);
        if (!dstDirectory.exists()) {
            dstDirectory.mkdirs();
        }
        String fileName = String.valueOf(projectName) + "-debug.apk";
        String srcPath = String.valueOf(projectPath) + File.separator + this.apkRuntimePath + File.separator + fileName;
        File srcFile = new File(srcPath);
        if (!srcFile.exists()) {
            return;
        }
        File dstFile = new File(String.valueOf(this.publishPath) + File.separator + fileName);
        if (dstFile.exists()) {
            dstFile.delete();
        }
        srcFile.renameTo(dstFile);
    }

    private void installAndroidPackage(String devicesName) {
        final IDevice device = this.devicesMap.get(devicesName);
        final String projectName = ((PublishAndroidWizard)this.previousPage.getWizard()).getProjectName();
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Install...", -1);
                String result = "";
                String fileName = "";
                try {
                    fileName = PublishAndroidWiazrdLogPage.this.mode.equals("debug") ? String.valueOf(PublishAndroidWiazrdLogPage.this.publishPath) + File.separator + projectName + "-debug.apk" : String.valueOf(PublishAndroidWiazrdLogPage.this.publishPath) + File.separator + projectName + "-release-signed.apk";
                    result = device.installPackage(fileName, true, new String[0]);
                }
                catch (InstallException e) {
                    e.printStackTrace();
                }
                String successMsg = String.format("install %s success!", fileName);
                String logMsg = result == null ? successMsg : "error:" + result;
                ConsoleFactory.showLine(logMsg, true);
                PublishAndroidWiazrdLogPage.this.saveInstalledRuntimeInfo(device, fileName);
                monitor.done();
            }
        };
        try {
            pmd.run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    void saveInstalledRuntimeInfo(IDevice device, String apkPath) {
        String packageName = AndroidUtil.extractPackageName(apkPath);
        if (packageName == null || "".equals(packageName)) {
            return;
        }
        String configFile = String.valueOf(Platform.getInstanceLocation().getURL().getPath()) + device.getName() + ".json";
        IConfiguration configuration = ConfigurationManager.getConfiguration(configFile);
        InstalledRuntimeConfig config = configuration.getConfig(InstalledRuntimeConfig.class);
        if (config == null) {
            config = new InstalledRuntimeConfig();
        }
        long fileModifiedTime = new File(apkPath).lastModified();
        config.setInstalledModifiedTime(packageName, fileModifiedTime);
        configuration.save(config);
    }

    private void openPackageLocation(String filePath) {
        Program.launch((String)filePath);
    }

    private void refreshDevices() {
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask("Searching...", -1);
                monitor.subTask("Searching devices...");
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IDevice[] devices = CommonAndroid.getInstance().getAndroidDevices();
                        if (devices.length > 0) {
                            int i = 0;
                            while (i < devices.length) {
                                PublishAndroidWiazrdLogPage.this.devicesMap.put(devices[i].getName(), devices[i]);
                                ++i;
                            }
                            String[] names = PublishAndroidWiazrdLogPage.this.devicesMap.keySet().toArray(new String[0]);
                            PublishAndroidWiazrdLogPage.this.devicesCombo.setItems(names);
                            if (names.length > 0) {
                                PublishAndroidWiazrdLogPage.this.devicesCombo.select(0);
                                PublishAndroidWiazrdLogPage.this.enableInstall(true);
                            }
                            PublishAndroidWiazrdLogPage.this.installButton.setText(Messages.publish_android_config_install);
                        } else {
                            String[] names = new String[]{};
                            PublishAndroidWiazrdLogPage.this.devicesCombo.setItems(names);
                            PublishAndroidWiazrdLogPage.this.installButton.setText(Messages.publish_android_config_refresh);
                            PublishAndroidWiazrdLogPage.this.installButton.getParent().layout();
                        }
                    }
                });
                monitor.done();
            }
        };
        try {
            pmd.run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

