/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.wizard.pages;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.ccdt.common.CommonConstants;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.DecoupleManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.manager.ProjectManager;
import org.ccdt.common.manager.ResourceManager;
import org.ccdt.common.model.RuntimeConfig;
import org.ccdt.common.ui.Messages;
import org.ccdt.common.ui.dialogs.EntryFileSelectionDialog;
import org.ccdt.common.ui.wizard.pages.CocosProjectUpgradeWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ProjectUpgradeWizardPage
extends WizardDataTransferPage {
    private TreeViewer projectsList;
    private Group entryGroup;
    EntryFileEditor entryEditor;
    private Label title;
    private String initialPattern = "**";
    private IProject project = null;
    private String entryFile = null;

    protected ProjectUpgradeWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Upgrade Cocos Project");
        this.setDescription("the page shows the steps that upgrader do.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, true));
        Label messageLbl = new Label(container, 64);
        String text = Messages.project_upgrade_explain_desc;
        messageLbl.setText(text);
        new Label(container, 64);
        this.project = this.getCurrentProject();
        this.createProjectsList(container);
        this.createUpgradeGroup(container);
        this.initEntryFileEditor();
    }

    private void createProjectsList(Composite workArea) {
        this.title = new Label(workArea, 0);
        this.title.setText("Project:");
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new TreeViewer(listComposite, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                ProjectRecord[] projRecords = ProjectUpgradeWizardPage.this.getProjectRecords();
                if (projRecords.length == 1) {
                    return projRecords[0].getResources().toArray();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ProjectUpgradeWizardPage.this.getProjectRecords();
            }

            public boolean hasChildren(Object element) {
                return element instanceof ProjectRecord;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof ResourceRecord) {
                    if (((ResourceRecord)element).isFolder) {
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
        });
    }

    private void createUpgradeGroup(Composite parent) {
        this.entryGroup = new Group(parent, 0);
        this.entryGroup.setFont(parent.getFont());
        this.entryGroup.setLayout((Layout)new GridLayout(3, false));
        this.entryGroup.setLayoutData((Object)new GridData(4, 1024, true, true, 3, 1));
        this.entryGroup.setText("Entry setting");
        this.entryEditor = new EntryFileEditor("", "Entry file:", (Composite)this.entryGroup);
    }

    private void initEntryFileEditor() {
        String configJsonPath = PathManager.instance.getProjectConfigPath(this.project);
        RuntimeConfig runtimeConfig = ConfigurationManager.getConfiguration(configJsonPath).getConfig(RuntimeConfig.class);
        if (runtimeConfig != null) {
            this.entryFile = runtimeConfig.getInit_cfg().getEntry();
            this.entryEditor.setStringValue(this.entryFile);
        }
        this.updateUpgradeGroup();
    }

    private void updateUpgradeGroup() {
        String value = this.entryEditor.getStringValue();
        if (value == null || "".equals(value)) {
            this.setMessage("Please specify a entry file for the game.", 3);
            this.setPageComplete(false);
        } else {
            IFile file = this.project.getFile(value);
            if (file.exists()) {
                this.setMessage(null);
                this.setPageComplete(true);
            } else {
                this.setMessage("The entry file does not exist in current project, please reselect one.", 3);
                this.setPageComplete(false);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectsList.expandAll();
            this.updateUpgradeGroup();
        }
    }

    public Image getImage() {
        if (this.project != null) {
            Image titleBar = ProjectManager.isCocosLuaProject(this.project.getLocation().toFile()) ? ResourceManager.IMAGE.get("icons/upgrade/upgrade_proj_wizard_titlebar-lua.png") : ResourceManager.IMAGE.get("icons/upgrade/upgrade_proj_wizard_titlebar-js.png");
            return titleBar;
        }
        return super.getImage();
    }

    ProjectRecord[] getProjectRecords() {
        ProjectRecord[] records = new ProjectRecord[1];
        File dotProjectFile = new File(String.valueOf(this.project.getLocation().toFile().getAbsolutePath()) + File.separator + ".project");
        records[0] = new ProjectRecord(dotProjectFile);
        return records;
    }

    void updateEntryFile() {
        File projRoot = this.project.getLocation().toFile();
        final ArrayList result = new ArrayList(1);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result.add(ProjectUpgradeWizardPage.this.entryEditor.getStringValue().trim());
            }
        });
        ProjectManager.updateEntryFile(projRoot, (String)result.get(0));
    }

    public void performUpgrade() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block15: {
                    boolean upgraded;
                    block14: {
                        monitor.beginTask("Upgrading project...", 10);
                        monitor.worked(5);
                        upgraded = ProjectUpgradeWizardPage.this.upgradeCocosProject(ProjectUpgradeWizardPage.this.project, monitor);
                        if (upgraded) break block14;
                        try {
                            ProjectUpgradeWizardPage.this.project.refreshLocal(2, monitor);
                        }
                        catch (CoreException coreException) {}
                        monitor.done();
                        return;
                    }
                    try {
                        try {
                            ProjectUpgradeWizardPage.this.updateEntryFile();
                            DecoupleManager manager = null;
                            String projType = ProjectManager.getProjectType(ProjectUpgradeWizardPage.this.project.getLocation().toFile());
                            if (projType != null) {
                                manager = DecoupleManager.getInstance(projType);
                            }
                            if (manager == null) break block15;
                            manager.postActionForCocosProject(ProjectUpgradeWizardPage.this.project, upgraded, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            try {
                                ProjectUpgradeWizardPage.this.project.refreshLocal(2, monitor);
                            }
                            catch (CoreException coreException) {}
                            monitor.done();
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            ProjectUpgradeWizardPage.this.project.refreshLocal(2, monitor);
                        }
                        catch (CoreException coreException) {}
                        monitor.done();
                        throw throwable;
                    }
                }
                try {
                    ProjectUpgradeWizardPage.this.project.refreshLocal(2, monitor);
                }
                catch (CoreException coreException) {}
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    private boolean upgradeCocosProject(IProject project, IProgressMonitor monitor) {
        boolean result = false;
        File projRoot = project.getLocation().toFile();
        try {
            monitor.subTask("Upgrading runtime/frameworks...");
            result = ProjectManager.upgradeCocosProject(projRoot);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            String title = "Upgrade Error";
            String message = "There were errors during the upgrade process, we will revert to the previous version of the project.";
            Status status = new Status(4, "org.eclipse.ui.ide", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
            monitor.subTask("Reverting...");
            ProjectManager.revertCocosProject(projRoot);
            return false;
        }
        catch (CoreException e1) {
            String message = "Upgrade Problems";
            Status status = new Status(4, "org.ccdt.common", message, (Throwable)e1);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        return result;
    }

    public IProject getCurrentProject() {
        IProject project = null;
        if (this.getWizard() instanceof CocosProjectUpgradeWizard) {
            CocosProjectUpgradeWizard wizard = (CocosProjectUpgradeWizard)this.getWizard();
            project = wizard.getCurrentProject();
        }
        return project;
    }

    public void handleEvent(Event event) {
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    class EntryFileEditor
    extends StringButtonFieldEditor {
        public EntryFileEditor(String name, String labelText, Composite parent) {
            this.init(name, labelText);
            this.setChangeButtonText("Select...");
            this.createControl(parent);
            this.getTextControl().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    ProjectUpgradeWizardPage.this.updateUpgradeGroup();
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            this.getTextControl().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ProjectUpgradeWizardPage.this.updateUpgradeGroup();
                }
            });
        }

        protected String changePressed() {
            return this.chooseEntryFile();
        }

        String chooseEntryFile() {
            File projRoot = ProjectUpgradeWizardPage.this.project.getLocation().toFile();
            EntryFileSelectionDialog dialog = new EntryFileSelectionDialog(this.getShell(), projRoot);
            if (ProjectManager.isCocosJSProject(projRoot)) {
                ProjectUpgradeWizardPage.this.initialPattern = "*.js";
            } else if (ProjectManager.isCocosLuaProject(projRoot)) {
                ProjectUpgradeWizardPage.this.initialPattern = "*.lua";
            }
            dialog.setInitialPattern(ProjectUpgradeWizardPage.this.initialPattern);
            if (dialog.open() == 0) {
                String result = (String)dialog.getFirstResult();
                return result;
            }
            return null;
        }
    }

    private final class ProjectLabelProvider
    extends LabelProvider {
        private ProjectLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ProjectRecord) {
                return ((ProjectRecord)element).getProjectLabel();
            }
            if (element instanceof ResourceRecord) {
                return ((ResourceRecord)element).getLabel();
            }
            return "unknown";
        }

        public Image getImage(Object element) {
            if (element instanceof ProjectRecord) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (element instanceof ResourceRecord) {
                if (((ResourceRecord)element).isFolder) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            return null;
        }
    }

    private class ProjectRecord {
        File projectSystemFile;
        File projectRoot;
        String projectName;
        IProjectDescription description;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.projectRoot = file.getParentFile();
            this.setProjectName();
        }

        private void setProjectName() {
            try {
                if (this.projectName == null) {
                    Path path = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)path)) {
                        this.projectName = path.segment(path.segmentCount() - 2);
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)path);
                        this.projectName = this.description.getName();
                    }
                    ProjectUpgradeWizardPage.this.title.setText("Project: " + this.projectName);
                }
            }
            catch (CoreException coreException) {}
        }

        private boolean isDefaultLocation(IPath path) {
            if (path.segmentCount() < 2) {
                return false;
            }
            return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        public String getProjectLabel() {
            if (this.description == null) {
                return this.projectName;
            }
            String path = this.projectSystemFile == null ? "NotSupportedProject" : this.projectSystemFile.getParent();
            String projType = ProjectManager.isCocosLuaProject(this.projectRoot) ? "lua" : "js";
            return NLS.bind((String)"{0} [{1}] ({2})", (Object[])new String[]{this.projectName, projType, path});
        }

        public List<ResourceRecord> getResources() {
            ArrayList<ResourceRecord> resources = new ArrayList<ResourceRecord>();
            File projRoot = this.projectSystemFile.getParentFile();
            if (projRoot != null && projRoot.exists() && projRoot.isDirectory()) {
                File[] fileArray = projRoot.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!f.getName().startsWith(".") && !CommonConstants.IGNORED_FILE_OR_DIR.contains(f.getName())) {
                        resources.add(new ResourceRecord(f.isDirectory(), f.getName()));
                    }
                    ++n2;
                }
            }
            return resources;
        }
    }

    class ResourceRecord {
        boolean isFolder;
        String name;

        public ResourceRecord(boolean isFolder, String name) {
            this.isFolder = isFolder;
            this.name = name;
        }

        public String getLabel() {
            return this.name;
        }
    }
}

