/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.wizard.pages;

import java.io.File;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.ProjectManager;
import org.ccdt.common.manager.ResourceManager;
import org.ccdt.common.model.RuntimeConfig;
import org.ccdt.common.ui.Messages;
import org.ccdt.common.ui.dialogs.EntryFileSelectionDialog;
import org.ccdt.common.ui.wizard.pages.CocosProjectImportWizard;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProjectUpgradeExplainWizardPage
extends WizardPage {
    private Group entryGroup;
    EntryFileEditor entryEditor;
    private String initialPattern = "**";
    private File projRoot = null;
    private String entryFile = null;
    private boolean isNeedUpdateEntryFile = false;

    protected ProjectUpgradeExplainWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Upgrade Cocos Project");
        this.setDescription("the page shows the steps that upgrader do.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, true));
        Label messageLbl = new Label(container, 64);
        String text = Messages.project_upgrade_explain_desc;
        messageLbl.setText(text);
        this.createUpgradeGroup(container);
    }

    private void createUpgradeGroup(Composite parent) {
        this.entryGroup = new Group(parent, 0);
        this.entryGroup.setFont(parent.getFont());
        this.entryGroup.setLayout((Layout)new GridLayout(3, false));
        this.entryGroup.setLayoutData((Object)new GridData(4, 1024, true, true, 3, 1));
        this.entryGroup.setText("Entry setting");
        this.entryEditor = new EntryFileEditor("", "Entry file:", (Composite)this.entryGroup);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projRoot = this.getProjectRoot();
            this.fillUpdateEntryFile();
        }
    }

    File getProjectRoot() {
        CocosProjectImportWizard importWizard = (CocosProjectImportWizard)this.getWizard();
        return importWizard.getImprtWizardPage().getCurrentProjectRoot();
    }

    void fillUpdateEntryFile() {
        String configJsonPath = String.valueOf(this.projRoot.getAbsolutePath()) + File.separator + "config.json";
        if (!new File(configJsonPath).exists()) {
            this.entryEditor.setStringValue("");
        } else {
            RuntimeConfig runtimeConfig = ConfigurationManager.getConfiguration(configJsonPath).getConfig(RuntimeConfig.class);
            if (runtimeConfig != null) {
                this.entryFile = runtimeConfig.getInit_cfg().getEntry();
                this.entryEditor.setStringValue(this.entryFile);
            }
        }
        this.updateUpgradeGroup();
    }

    public boolean isNeedUpdateEntryFile() {
        return this.isNeedUpdateEntryFile;
    }

    public void updateEntryFile() {
        if (this.isNeedUpdateEntryFile) {
            ProjectManager.updateEntryFile(this.projRoot, this.entryFile);
        }
    }

    public Image getImage() {
        if (this.projRoot != null) {
            Image titleBar = ProjectManager.isCocosLuaProject(this.projRoot) ? ResourceManager.IMAGE.get("icons/import/import_proj_wizard_titlebar-lua.png") : ResourceManager.IMAGE.get("icons/import/import_proj_wizard_titlebar-js.png");
            return titleBar;
        }
        return super.getImage();
    }

    private void updateUpgradeGroup() {
        String value = this.entryEditor.getStringValue();
        if (value == null || "".equals(value)) {
            this.setMessage("Please specify a entry file for the game.", 3);
            this.setPageComplete(false);
        } else {
            File projRoot = this.getProjectRoot();
            if (projRoot == null) {
                return;
            }
            File entryFile = new File(projRoot + File.separator + value);
            if (entryFile.exists()) {
                this.setMessage(null);
                this.setPageComplete(true);
                this.isNeedUpdateEntryFile = true;
            } else {
                this.setMessage("The entry file does not exist in current project, please reselect one.", 3);
                this.setPageComplete(false);
                this.isNeedUpdateEntryFile = false;
            }
        }
    }

    class EntryFileEditor
    extends StringButtonFieldEditor {
        public EntryFileEditor(String name, String labelText, Composite parent) {
            this.init(name, labelText);
            this.setChangeButtonText("Select...");
            this.createControl(parent);
            this.getTextControl().addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    ProjectUpgradeExplainWizardPage.this.updateUpgradeGroup();
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            this.getTextControl().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ProjectUpgradeExplainWizardPage.this.updateUpgradeGroup();
                }
            });
        }

        protected String changePressed() {
            return this.chooseEntryFile();
        }

        String chooseEntryFile() {
            File projRoot = ProjectUpgradeExplainWizardPage.this.getProjectRoot();
            EntryFileSelectionDialog dialog = new EntryFileSelectionDialog(this.getShell(), projRoot);
            if (ProjectManager.isCocosJSProject(projRoot)) {
                ProjectUpgradeExplainWizardPage.this.initialPattern = "*.js";
            } else if (ProjectManager.isCocosLuaProject(projRoot)) {
                ProjectUpgradeExplainWizardPage.this.initialPattern = "*.lua";
            }
            dialog.setInitialPattern(ProjectUpgradeExplainWizardPage.this.initialPattern);
            if (dialog.open() == 0) {
                String result = (String)dialog.getFirstResult();
                ProjectUpgradeExplainWizardPage.this.entryFile = result;
                ProjectUpgradeExplainWizardPage.this.setPageComplete(ProjectUpgradeExplainWizardPage.this.entryFile != null);
                return result;
            }
            return null;
        }
    }
}

