/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.wizard.pages;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ccdt.common.CommonConstants;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.manager.DecoupleManager;
import org.ccdt.common.manager.ProjectManager;
import org.ccdt.common.manager.ResourceManager;
import org.ccdt.common.ui.wizard.pages.CocosProjectImportWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ProjectImportWizardPage
extends WizardDataTransferPage {
    private static final String STORE_DIRECTORIES = "ProjectImportWizardPage.STORE_DIRECTORIES";
    private static final String STORE_COPY_PROJECT_ID = "ProjectImportWizardPage.STORE_COPY_PROJECT_ID";
    private Combo directoryPathField;
    private TreeViewer projectsList;
    private boolean nestedProjects = false;
    private boolean lastNestedProjects = false;
    private Button copyCheckbox;
    private boolean copyFiles = false;
    private boolean lastCopyFiles = false;
    private Group upgradeGroup;
    private Button upgradeCheckbox;
    private Label lblUpgradePrompt;
    private boolean upgradeProject = false;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private ProjectRecord currentProject = null;
    private static String previouslyBrowsedDirectory = "";
    private Button browseDirectoriesButton;
    private IProject[] wsProjects;
    IWorkingSet[] selectedWorkingSets;
    private String initialPath;
    private String lastPath;
    private long lastModified;
    private String projType;
    private WorkingSetGroup workingSetGroup;
    private IStructuredSelection currentSelection;
    List createdProjects;

    public ProjectImportWizardPage() {
        this("wizardImportCocosProjectsPage", null, null);
    }

    public ProjectImportWizardPage(String pageName) {
        this(pageName, null, null);
    }

    public ProjectImportWizardPage(String pageName, String initialPath, IStructuredSelection currentSelection) {
        super(pageName);
        this.initialPath = initialPath;
        this.currentSelection = currentSelection;
        this.setPageComplete(false);
        this.setTitle("Import Cocos Project");
        this.setDescription("Select a directory to search for existing Cocos project.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
        this.createUpgradeGroup(workArea);
        this.createOptionsGroup(workArea);
        this.createWorkingSetGroup(workArea);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createWorkingSetGroup(Composite workArea) {
        String[] workingSetIds = new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.dltk.ui.ScriptWorkingSetPage", "org.ccdt.jsdt.ui.JavaWorkingSetPage"};
        this.workingSetGroup = new WorkingSetGroup(workArea, this.currentSelection, workingSetIds);
    }

    private void createUpgradeGroup(Composite workArea) {
        this.upgradeGroup = new Group(workArea, 0);
        this.upgradeGroup.setFont(workArea.getFont());
        this.upgradeGroup.setText("Project upgrade");
        this.upgradeGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        this.upgradeGroup.setLayout((Layout)new GridLayout(1, false));
        this.upgradeCheckbox = new Button((Composite)this.upgradeGroup, 32);
        this.upgradeCheckbox.setText("Upgrade runtime/frameworks to new version.");
        this.upgradeCheckbox.setLayoutData((Object)new GridData(768));
        this.upgradeCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectImportWizardPage.this.upgradeProject = ProjectImportWizardPage.this.upgradeCheckbox.getSelection();
                if (!ProjectImportWizardPage.this.upgradeCheckbox.getSelection()) {
                    CocosProjectImportWizard wizard = (CocosProjectImportWizard)ProjectImportWizardPage.this.getWizard();
                    wizard.getExplainWizardPage().setPageComplete(true);
                }
                ProjectImportWizardPage.this.setPageComplete(ProjectImportWizardPage.this.canImportDirectly());
            }
        });
        this.upgradeCheckbox.setEnabled(false);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.copyCheckbox = new Button((Composite)optionsGroup, 32);
        this.copyCheckbox.setText("Copy project into workspace");
        this.copyCheckbox.setLayoutData((Object)new GridData(768));
        this.copyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectImportWizardPage.this.copyFiles = ProjectImportWizardPage.this.copyCheckbox.getSelection();
                ProjectImportWizardPage.this.updateProjectsList(ProjectImportWizardPage.this.directoryPathField.getText().trim());
            }
        });
    }

    private void createProjectsList(Composite workArea) {
        Composite topComp = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        topComp.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        topComp.setLayoutData((Object)gridData);
        Label title = new Label(topComp, 0);
        title.setText("Project root:");
        this.lblUpgradePrompt = new Label(topComp, 0);
        this.lblUpgradePrompt.setFont(this.getItalicFont());
        Composite listComposite = new Composite(workArea, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new TreeViewer(listComposite, 2048);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                ProjectRecord[] projRecords = ProjectImportWizardPage.this.getProjectRecords();
                if (projRecords.length == 1) {
                    return projRecords[0].getResources().toArray();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ProjectImportWizardPage.this.getProjectRecords();
            }

            public boolean hasChildren(Object element) {
                return element instanceof ProjectRecord;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof ResourceRecord) {
                    if (((ResourceRecord)element).isFolder) {
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
        });
        this.createSelectionButtons(listComposite);
    }

    private Font getItalicFont() {
        Font italic;
        Font textFont = JFaceResources.getTextFont();
        if (textFont == null) {
            return JFaceResources.getDefaultFont();
        }
        if (textFont.getFontData().length > 0 && (italic = JFaceResources.getFontRegistry().getItalic(textFont.getFontData()[0].getName())) != null) {
            return italic;
        }
        return textFont;
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText("Refresh");
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectImportWizardPage.this.updateProjectsList(ProjectImportWizardPage.this.directoryPathField.getText().trim());
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        new Label(projectGroup, 0).setText("Select project directory:");
        this.directoryPathField = new Combo(projectGroup, 2048);
        GridData directoryPathData = new GridData(768);
        directoryPathData.widthHint = new PixelConverter((Control)this.directoryPathField).convertWidthInCharsToPixels(25);
        this.directoryPathField.setLayoutData((Object)directoryPathData);
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText("B&rowse...");
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectImportWizardPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    ProjectImportWizardPage.this.updateProjectsList(ProjectImportWizardPage.this.directoryPathField.getText().trim());
                }
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ProjectImportWizardPage.this.updateProjectsList(ProjectImportWizardPage.this.directoryPathField.getText().trim());
            }
        });
        this.directoryPathField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectImportWizardPage.this.updateProjectsList(ProjectImportWizardPage.this.directoryPathField.getText().trim());
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.directoryPathField.setFocus();
        } else {
            this.setPageComplete(true);
        }
    }

    public void updateProjectsList(String path) {
        if (path == null || path.length() == 0) {
            this.setMessage("Select a directory to search for existing cocos projects.");
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.setPageComplete(this.canImportDirectly());
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified && this.lastNestedProjects == this.nestedProjects && this.lastCopyFiles == this.copyFiles) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        this.lastNestedProjects = this.nestedProjects;
        this.lastCopyFiles = this.copyFiles;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Searching for cocos project", 100);
                    ProjectImportWizardPage.this.selectedProjects = new ProjectRecord[0];
                    ArrayList files = new ArrayList();
                    monitor.worked(10);
                    if (directory.isDirectory()) {
                        if (!ProjectImportWizardPage.this.collectProjectFileFromDirectory(files, directory, monitor)) {
                            return;
                        }
                        Iterator filesIterator = files.iterator();
                        ProjectImportWizardPage.this.selectedProjects = new ProjectRecord[files.size()];
                        int index = 0;
                        monitor.worked(50);
                        monitor.subTask("Processing results");
                        while (filesIterator.hasNext()) {
                            File file = (File)filesIterator.next();
                            ((ProjectImportWizardPage)ProjectImportWizardPage.this).selectedProjects[index] = new ProjectRecord(file);
                            ++index;
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
        this.projectsList.refresh(true);
        this.projectsList.expandAll();
        ProjectRecord[] projects = this.getProjectRecords();
        boolean displayWarning = false;
        int i = 0;
        while (i < projects.length) {
            this.upgradeCheckbox.setEnabled(projects[i].canUpgrade);
            if (projects[i].hasConflicts) {
                displayWarning = true;
            }
            ++i;
        }
        if (projects.length == 1) {
            this.currentProject = projects[0];
            ((CocosProjectImportWizard)this.getWizard()).getContainer().updateTitleBar();
            if (this.currentProject.canUpgrade) {
                this.lblUpgradePrompt.setVisible(true);
                this.lblUpgradePrompt.setText("this project created by old engine, recommend to upgrade it.");
                this.lblUpgradePrompt.getParent().layout();
            } else {
                this.lblUpgradePrompt.setText("");
                this.lblUpgradePrompt.setVisible(false);
            }
            this.upgradeCheckbox.setSelection(this.currentProject.canUpgrade);
            this.upgradeCheckbox.notifyListeners(13, new Event());
        }
        if (displayWarning) {
            this.setMessage("the project cannot be imported because it already exists in the workspace", 2);
        } else {
            this.setMessage("Select a directory to search for existing cocos project.");
        }
        this.setPageComplete(this.canImportDirectly());
        if (this.selectedProjects.length == 0) {
            this.setMessage("No cocos project is found to import", 2);
        }
    }

    public Image getImage() {
        if (this.currentProject != null) {
            Image titleBar = ProjectManager.isCocosLuaProject(this.currentProject.projectRoot) ? ResourceManager.IMAGE.get("icons/import/import_proj_wizard_titlebar-lua.png") : ResourceManager.IMAGE.get("icons/import/import_proj_wizard_titlebar-js.png");
            return titleBar;
        }
        return super.getImage();
    }

    private boolean collectProjectFileFromDirectory(Collection files, File directory, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)"Checking: {0}", (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (ProjectManager.isCocosProject(directory)) {
            files.add(new File(String.valueOf(directory.getAbsolutePath()) + File.separator + ".project"));
        }
        return true;
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell(), 0x10000000);
        dialog.setMessage("Select root directory of the cocos project to import");
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
        }
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] selected = this.selectedProjects;
        this.createdProjects = new ArrayList();
        this.selectedWorkingSets = this.workingSetGroup.getSelectedWorkingSets();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Importing Project...", selected.length);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    int i = 0;
                    while (i < selected.length) {
                        ProjectImportWizardPage.this.createExistingProject((ProjectRecord)selected[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ++i;
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = "Creation Problems";
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public void performCancel() {
    }

    private boolean createExistingProject(ProjectRecord record, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IProject project;
        block28: {
            boolean upgraded;
            block27: {
                URI locationURI;
                String projectName = record.getProjectName();
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                project = workspace.getRoot().getProject(projectName);
                this.createdProjects.add(project);
                if (record.description == null) {
                    record.description = workspace.newProjectDescription(projectName);
                    Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
                    if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                        record.description.setLocation(null);
                    } else {
                        record.description.setLocation((IPath)locationPath);
                    }
                } else {
                    record.description.setName(projectName);
                }
                File importSource = null;
                if (this.copyFiles && (locationURI = record.description.getLocationURI()) != null) {
                    IStatus result = ResourcesPlugin.getWorkspace().validateProjectLocationURI(project, locationURI);
                    if (!result.isOK()) {
                        throw new InvocationTargetException(new CoreException(result));
                    }
                    importSource = new File(locationURI);
                    IProjectDescription desc = workspace.newProjectDescription(projectName);
                    desc.setBuildSpec(record.description.getBuildSpec());
                    desc.setComment(record.description.getComment());
                    desc.setDynamicReferences(record.description.getDynamicReferences());
                    desc.setNatureIds(record.description.getNatureIds());
                    desc.setReferencedProjects(record.description.getReferencedProjects());
                    record.description = desc;
                }
                try {
                    try {
                        monitor.beginTask("Creating Project", 100);
                        project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                        project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
                if (this.copyFiles && importSource != null) {
                    List filesToImport = FileSystemStructureProvider.INSTANCE.getChildren((Object)importSource);
                    ImportOperation operation = new ImportOperation(project.getFullPath(), (Object)importSource, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (IOverwriteQuery)this, filesToImport);
                    operation.setContext(this.getShell());
                    operation.setOverwriteResources(true);
                    operation.setCreateContainerStructure(false);
                    operation.run(monitor);
                }
                upgraded = false;
                if (!this.upgradeProject) break block27;
                monitor.subTask("Upgrading Project...");
                upgraded = this.upgradeCocosProject(record, project, monitor);
                if (upgraded) break block27;
                try {
                    project.refreshLocal(2, monitor);
                }
                catch (CoreException coreException) {}
                return false;
            }
            try {
                try {
                    DecoupleManager manager = null;
                    if (this.projType != null) {
                        manager = DecoupleManager.getInstance(this.projType);
                    }
                    if (manager == null) break block28;
                    manager.postActionForCocosProject(project, upgraded, this.selectedWorkingSets);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    CocosLogger.LOG.error((Object)"Upgrading Project Error", e);
                    try {
                        project.refreshLocal(2, monitor);
                    }
                    catch (CoreException coreException) {}
                }
            }
            catch (Throwable throwable) {
                try {
                    project.refreshLocal(2, monitor);
                }
                catch (CoreException coreException) {}
                throw throwable;
            }
        }
        try {
            project.refreshLocal(2, monitor);
        }
        catch (CoreException coreException) {}
        return true;
    }

    private boolean upgradeCocosProject(ProjectRecord record, IProject project, IProgressMonitor monitor) {
        boolean result = false;
        try {
            result = ProjectManager.upgradeCocosProject(project.getLocation().toFile());
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            String title = "Upgrade Error";
            String message = "There were errors during the upgrade process, we will revert to the previous version of the project.";
            Status status = new Status(4, "org.ccdt.common", 1, title, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
            monitor.subTask("Reverting...");
            ProjectManager.revertCocosProject(project.getLocation().toFile());
            try {
                project.delete(false, true, monitor);
            }
            catch (CoreException coreException) {}
            return false;
        }
        catch (CoreException e1) {
            String message = "Upgrade Problems";
            Status status = new Status(4, "org.ccdt.common", message, (Throwable)e1);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        return result;
    }

    public TreeViewer getProjectsList() {
        return this.projectsList;
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    public ProjectRecord[] getProjectRecords() {
        ArrayList<ProjectRecord> projectRecords = new ArrayList<ProjectRecord>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            if (this.isProjectInWorkspacePath(this.selectedProjects[i].getProjectName()) && this.copyFiles || this.isProjectInWorkspace(this.selectedProjects[i].getProjectName())) {
                this.selectedProjects[i].hasConflicts = true;
            }
            if (ProjectManager.canUpgrade(this.selectedProjects[i].projectRoot)) {
                this.selectedProjects[i].canUpgrade = true;
            }
            projectRecords.add(this.selectedProjects[i]);
            ++i;
        }
        return projectRecords.toArray(new ProjectRecord[projectRecords.size()]);
    }

    public File getCurrentProjectRoot() {
        if (this.currentProject != null) {
            return this.currentProject.projectRoot;
        }
        return null;
    }

    public IProject getCurrentProject() {
        if (this.currentProject == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.currentProject.projectName);
        return project;
    }

    private boolean isProjectInWorkspacePath(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath wsPath = workspace.getRoot().getLocation();
        IPath localProjectPath = wsPath.append(projectName);
        return localProjectPath.toFile().exists();
    }

    private boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean canImportDirectly() {
        if (this.selectedProjects.length == 0) {
            return false;
        }
        ProjectRecord projectRecord = this.selectedProjects[0];
        if (projectRecord.hasConflicts) {
            return false;
        }
        if (!projectRecord.hasConflicts && !projectRecord.canUpgrade) {
            return true;
        }
        return projectRecord.canUpgrade && !this.upgradeProject;
    }

    public boolean canFlipToNextPage() {
        boolean flag = this.canImportDirectly();
        if (flag) {
            return false;
        }
        if (this.selectedProjects.length == 0) {
            return false;
        }
        if (this.currentProject.hasConflicts) {
            return false;
        }
        return this.getNextPage() != null;
    }

    public void restoreWidgetValues() {
        boolean dir;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.restoreFromHistory(settings, STORE_DIRECTORIES, this.directoryPathField);
            this.copyFiles = settings.getBoolean(STORE_COPY_PROJECT_ID);
            this.copyCheckbox.setSelection(this.copyFiles);
            this.lastCopyFiles = this.copyFiles;
        }
        if ((this.initialPath != null || settings == null) && this.initialPath != null && (dir = new File(this.initialPath).isDirectory())) {
            this.directoryPathField.setText(this.initialPath);
            this.directoryPathField.setSelection(new Point(this.initialPath.length(), this.initialPath.length()));
        }
    }

    private void restoreFromHistory(IDialogSettings settings, String key, Combo combo) {
        String[] sourceNames = settings.getArray(key);
        if (sourceNames == null) {
            return;
        }
        int i = 0;
        while (i < sourceNames.length) {
            combo.add(sourceNames[i]);
            ++i;
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.saveInHistory(settings, STORE_DIRECTORIES, this.directoryPathField.getText());
            settings.put(STORE_COPY_PROJECT_ID, this.copyCheckbox.getSelection());
        }
    }

    private void saveInHistory(IDialogSettings settings, String key, String value) {
        String[] sourceNames = settings.getArray(key);
        if (sourceNames == null) {
            sourceNames = new String[]{};
        }
        sourceNames = this.addToHistory(sourceNames, value);
        settings.put(key, sourceNames);
    }

    public void handleEvent(Event event) {
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    private final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private boolean hasConflicts = false;

        private ProjectLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ProjectRecord) {
                return ((ProjectRecord)element).getProjectLabel();
            }
            if (element instanceof ResourceRecord) {
                return ((ResourceRecord)element).getLabel();
            }
            return "unknown";
        }

        public Image getImage(Object element) {
            if (element instanceof ProjectRecord) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (element instanceof ResourceRecord) {
                if (((ResourceRecord)element).isFolder) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof ProjectRecord) {
                ProjectRecord projectRecord = (ProjectRecord)element;
                this.hasConflicts = projectRecord.hasConflicts;
                if (projectRecord.hasConflicts) {
                    return ProjectImportWizardPage.this.getShell().getDisplay().getSystemColor(15);
                }
            } else if (element instanceof ResourceRecord && this.hasConflicts) {
                return ProjectImportWizardPage.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }
    }

    public class ProjectRecord {
        File projectSystemFile;
        File projectRoot;
        String projectName;
        int level;
        boolean hasConflicts;
        boolean canUpgrade = false;
        IProjectDescription description;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.projectRoot = file.getParentFile();
            this.setProjectName();
        }

        private void setProjectName() {
            try {
                if (this.projectName == null) {
                    Path path = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)path)) {
                        this.projectName = path.segment(path.segmentCount() - 2);
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)path);
                        this.projectName = this.description.getName();
                    }
                }
            }
            catch (CoreException coreException) {}
        }

        private boolean isDefaultLocation(IPath path) {
            if (path.segmentCount() < 2) {
                return false;
            }
            return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getProjectLabel() {
            if (this.description == null) {
                return this.projectName;
            }
            String path = this.projectSystemFile == null ? "NotSupportedProject" : this.projectSystemFile.getParent();
            ProjectImportWizardPage.this.projType = ProjectManager.isCocosLuaProject(this.projectRoot) ? "lua" : "js";
            return NLS.bind((String)"{0} [{1}] ({2})", (Object[])new String[]{this.projectName, ProjectImportWizardPage.this.projType, path});
        }

        public boolean hasConflicts() {
            return this.hasConflicts;
        }

        public List<ResourceRecord> getResources() {
            ArrayList<ResourceRecord> resources = new ArrayList<ResourceRecord>();
            File projRoot = this.projectSystemFile.getParentFile();
            if (projRoot != null && projRoot.exists() && projRoot.isDirectory()) {
                File[] fileArray = projRoot.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!f.getName().startsWith(".") && !CommonConstants.IGNORED_FILE_OR_DIR.contains(f.getName())) {
                        resources.add(new ResourceRecord(f.isDirectory(), f.getName()));
                    }
                    ++n2;
                }
            }
            return resources;
        }
    }

    class ResourceRecord {
        boolean isFolder;
        String name;

        public ResourceRecord(boolean isFolder, String name) {
            this.isFolder = isFolder;
            this.name = name;
        }

        public String getLabel() {
            return this.name;
        }
    }
}

