/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.wizard.pages;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.ccdt.common.CommonConsole;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.messages.Messages;
import org.ccdt.common.model.CocosProjectConfig;
import org.ccdt.common.ui.wizard.pages.CreateNativeWizard;
import org.ccdt.common.utils.FileUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CreateNativeWizardLogPage
extends WizardPage {
    private Label resultLabel;
    private boolean result = false;
    private String success = "You have already added native codes.\nAdd native codes for meet such purposes:\n  - Add special game logic in native codes\n  - Add third party libraries\n  - Customize script binding codes\n  - Package to apk for Android\n  - Package to ipa for iOS";
    private String failed = "Created native codes failed\n\n\nPlease, check the console view's error log.";

    public CreateNativeWizardLogPage() {
        super("CreateNativeWizardLogPage");
        this.setTitle(Messages.create_native_config_result_title);
    }

    public IWizardPage getPreviousPage() {
        return null;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.resultLabel = new Label(container, 64);
        this.resultLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.resultLabel.setText("");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.createNative();
        }
    }

    public void createNative() {
        final String projectName = ((CreateNativeWizard)this.getWizard()).getProjectName();
        final String tempPath = String.valueOf(((CreateNativeWizard)this.getWizard()).getProjectPath()) + File.separator + "temp";
        final String packageName = ((CreateNativeWizard)this.getWizard()).getNativePage().getPackageName();
        final String bundleId = ((CreateNativeWizard)this.getWizard()).getNativePage().getBundleIdentifier();
        final float consoleVersion = ((CreateNativeWizard)this.getWizard()).getConsoleVersion();
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                block18: {
                    try {
                        monitor.beginTask("Adding native codes, it will take several mintues...", -1);
                        String perspectiveId = ((CreateNativeWizard)CreateNativeWizardLogPage.this.getWizard()).getPerspectiveId();
                        String lan = "";
                        if (perspectiveId.equals("org.ccdt.lua.ui.perspectives.CocosPerspectives")) {
                            lan = "lua";
                        } else if (perspectiveId.equals("org.ccdt.js.ui.perspectives.CocosPerspective")) {
                            lan = "js";
                        }
                        boolean res = false;
                        res = consoleVersion >= 0.7f ? CommonConsole.getInstance().create(projectName, packageName, bundleId, tempPath, lan, true) : CommonConsole.getInstance().create(projectName, packageName, tempPath, lan, true);
                        if (!res) break block18;
                        String frameworkPath = String.valueOf(((CreateNativeWizard)CreateNativeWizardLogPage.this.getWizard()).getProjectPath()) + File.separator + "frameworks";
                        String tempFrameworkPath = String.valueOf(tempPath) + File.separator + projectName + File.separator + "frameworks";
                        try {
                            FileUtil.copyDirectory(tempFrameworkPath, frameworkPath);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        IProject proj = ((CreateNativeWizard)CreateNativeWizardLogPage.this.getWizard()).getProject();
                        CocosProjectConfig cocosProjectConfig = ConfigurationManager.getConfiguration(PathManager.instance.getCocosProjectConfigPath(proj)).getConfig(CocosProjectConfig.class);
                        cocosProjectConfig.setHasNative(true);
                        ConfigurationManager.getConfiguration(PathManager.instance.getCocosProjectConfigPath(proj)).save(cocosProjectConfig);
                        try {
                            proj.refreshLocal(2, null);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        CreateNativeWizardLogPage.this.result = true;
                    }
                    finally {
                        try {
                            FileUtil.deleteDirectory(tempPath);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        IProject proj = ((CreateNativeWizard)CreateNativeWizardLogPage.this.getWizard()).getProject();
                        try {
                            proj.refreshLocal(2, null);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        monitor.done();
                    }
                }
            }
        };
        try {
            pmd.run(true, false, op);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.buildResult();
    }

    private boolean getResult() {
        return this.result;
    }

    private void buildResult() {
        String result = "";
        if (this.getResult()) {
            result = this.success;
            this.setTitle(Messages.create_native_config_congratulations);
        } else {
            result = this.failed;
            this.setTitle(Messages.create_native_config_create_failed);
        }
        this.resultLabel.setText(result);
        this.resultLabel.getParent().layout();
    }
}

