/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.wizard.pages;

import org.ccdt.common.CommonConsole;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.config.model.JSConfig;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.model.CocosProjectConfig;
import org.ccdt.common.ui.wizard.pages.CreateNativeWizardLogPage;
import org.ccdt.common.ui.wizard.pages.CreateNativeWizardNativePage;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CreateNativeWizard
extends Wizard {
    private CreateNativeWizardNativePage nativePage;
    private CreateNativeWizardLogPage logPage;
    private IProject currProject;
    private String engineRoot;
    private String perspectiveId;
    private boolean hasNative = false;
    private float consoleVersion = 0.0f;

    public CreateNativeWizard(IProject proj) {
        this.setWindowTitle("Create Native Source Wizard");
        this.currProject = proj;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IPerspectiveDescriptor PerspectiveDescriptor = activePage.getPerspective();
        this.perspectiveId = PerspectiveDescriptor.getId();
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        if (this.perspectiveId.equals("org.ccdt.lua.ui.perspectives.CocosPerspectives")) {
            this.engineRoot = store.getString("org.ccdt.common.lua_engine_path");
        } else if (this.perspectiveId.equals("org.ccdt.js.ui.perspectives.CocosPerspective")) {
            JSConfig config = ConfigurationManager.COMMON.getConfig(JSConfig.class);
            this.engineRoot = config.getJsEnginePath();
        }
        this.consoleVersion = CommonConsole.getInstance().getConsoleVersion();
    }

    public void addPages() {
        try {
            CocosProjectConfig cocosProjectConfig = ConfigurationManager.getConfiguration(PathManager.instance.getCocosProjectConfigPath(this.currProject)).getConfig(CocosProjectConfig.class);
            this.hasNative = cocosProjectConfig.isHasNative();
            this.nativePage = new CreateNativeWizardNativePage();
            this.addPage((IWizardPage)this.nativePage);
            this.logPage = new CreateNativeWizardLogPage();
            this.addPage((IWizardPage)this.logPage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean performFinish() {
        return false;
    }

    public String getPerspectiveId() {
        if (this.perspectiveId == null) {
            return "";
        }
        return this.perspectiveId;
    }

    public String getEnginePath() {
        if (this.engineRoot == null) {
            return "";
        }
        return this.engineRoot;
    }

    public IProject getProject() {
        return this.currProject;
    }

    public String getProjectPath() {
        if (this.currProject == null) {
            return "";
        }
        return this.currProject.getProject().getLocation().toString();
    }

    public String getProjectName() {
        if (this.currProject == null) {
            return "";
        }
        return this.currProject.getProject().getName();
    }

    public boolean hasNative() {
        return this.hasNative;
    }

    public CreateNativeWizardNativePage getNativePage() {
        return this.nativePage;
    }

    public float getConsoleVersion() {
        return this.consoleVersion;
    }
}

