/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.wizard.pages;

import java.io.File;
import org.ccdt.common.CommonPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CocosWizardPythonWarningPage
extends WizardPage {
    public CocosWizardPythonWarningPage() {
        super("wizardPage");
        this.setTitle("Create Cocos Application");
        this.setDescription("Wizard Page description");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Label warningLabel = new Label(container, 64);
        warningLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        String text = "Unable to find python.\n\nPlease, click the setting button to set the python path, \n\nthen python 3.0 or later is not supported.";
        warningLabel.setText(text);
        new Label(container, 0);
        Button setting = new Button(container, 8);
        setting.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        setting.setText("Setting Python");
        setting.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CocosWizardPythonWarningPage.this.getShell().dispose();
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)window.getShell(), (String)"org.ccdt.common.ui.prefs.cocos", (String[])new String[]{"org.ccdt.common.ui.prefs.cocos"}, null);
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateStatus();
        this.setPageComplete(false);
    }

    private void updateStatus() {
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        String pythonPath = store.getString("org.ccdt.common.python_path");
        if (pythonPath.length() == 0) {
            this.setErrorMessage("The wizard need to set the Python Path.");
            return;
        }
        File file = new File(String.valueOf(pythonPath) + File.separator + "python");
        if (!file.exists()) {
            this.setErrorMessage("Please, check and ensure that python was already installed");
            return;
        }
    }
}

