/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.property;

import java.util.ArrayList;
import java.util.List;
import org.ccdt.common.CommonConstants;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.model.CocosProjectConfig;
import org.ccdt.common.ui.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AssetsManagePropertyPage
extends PropertyPage
implements ICheckStateListener {
    private IProject currentProj;
    private CheckboxTableViewer fListViewer;
    private final WorkbenchLabelProvider fLabelProvider = new WorkbenchLabelProvider();
    private CocosProjectConfig cocosProjectConfig;

    public void createControl(Composite parent) {
        this.setDescription(Messages.assets_manage_prop_page_desc);
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.createListViewer(composite);
        this.currentProj = this.getCurrentSelectedProject();
        this.fListViewer.setInput((Object)this.currentProj);
        this.cocosProjectConfig = ConfigurationManager.getConfiguration(PathManager.instance.getCocosProjectConfigPath(this.currentProj)).getConfig(CocosProjectConfig.class);
        this.refreshListViewer();
        return composite;
    }

    private IProject getCurrentSelectedProject() {
        IAdaptable adaptable = this.getElement();
        IProject project = (IProject)adaptable.getAdapter(IProject.class);
        return project;
    }

    private CheckboxTableViewer createListViewer(Composite parent) {
        this.fListViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        GridData data = new GridData(768);
        data.heightHint = 250;
        this.fListViewer.getTable().setLayoutData((Object)data);
        this.fListViewer.setContentProvider((IContentProvider)new AssetsContentProvider());
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new AssetsLabelProvider());
        this.fListViewer.addCheckStateListener((ICheckStateListener)this);
        return this.fListViewer;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
    }

    private List<IResource> getElementsToBeIgnored(IProject project) {
        ArrayList<IResource> elements = new ArrayList<IResource>();
        try {
            IResource[] members;
            IResource[] iResourceArray = members = project.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (!member.getName().startsWith(".") && !CommonConstants.IGNORED_FILE_OR_DIR.contains(member.getName())) {
                    elements.add(member);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        return elements;
    }

    private boolean saveValues() {
        Object[] checkedElements;
        ArrayList<String> ignores = new ArrayList<String>();
        Object[] objectArray = checkedElements = this.fListViewer.getCheckedElements();
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                ignores.add(((IResource)element).getName());
            }
            ++n2;
        }
        this.cocosProjectConfig.getAssets().setIgnores(ignores);
        ConfigurationManager.getConfiguration(PathManager.instance.getCocosProjectConfigPath(this.currentProj)).save(this.cocosProjectConfig);
        return true;
    }

    private void resetValues() {
        this.fListViewer.setAllChecked(false);
        this.fListViewer.refresh();
    }

    private void refreshListViewer() {
        List<IResource> elements = this.getElementsToBeIgnored(this.currentProj);
        List<Object> ignores = new ArrayList();
        ignores = this.cocosProjectConfig.getAssets().getIgnores();
        ArrayList<IResource> checkedElements = new ArrayList<IResource>();
        for (IResource res : elements) {
            for (String string : ignores) {
                if (!res.getName().equals(string)) continue;
                checkedElements.add(res);
            }
        }
        this.fListViewer.setCheckedElements(checkedElements.toArray());
        this.fListViewer.refresh();
    }

    protected void performApply() {
        this.saveValues();
        super.performApply();
    }

    public boolean performOk() {
        return this.saveValues() && super.performOk();
    }

    protected void performDefaults() {
        this.resetValues();
        super.performDefaults();
    }

    private class AssetsContentProvider
    implements IStructuredContentProvider {
        private final Object[] EMPTY = new Object[0];

        private AssetsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IProject) {
                IProject proj = (IProject)inputElement;
                return AssetsManagePropertyPage.this.getElementsToBeIgnored(proj).toArray();
            }
            return this.EMPTY;
        }
    }

    private class AssetsLabelProvider
    extends LabelProvider {
        private AssetsLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IResource) {
                IResource resource = (IResource)element;
                Image image = AssetsManagePropertyPage.this.fLabelProvider.getImage((Object)resource);
                return image;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getName();
            }
            return "unknown";
        }
    }
}

