/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.preferences;

import java.util.Arrays;
import java.util.Comparator;
import org.ccdt.common.ui.preferences.ICocosTarget;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CocosTargetSelector {
    private ICocosTarget[] mTargets;
    private final boolean mAllowSelection;
    private SelectionListener mSelectionListener;
    private Table mTable;
    private Label mDescription;
    private Composite mInnerGroup;
    private static int sCheckboxWidth = -1;

    public CocosTargetSelector(Composite parent, ICocosTarget[] targets) {
        this(parent, targets, true);
    }

    public CocosTargetSelector(Composite parent, ICocosTarget[] targets, boolean allowSelection) {
        this.mInnerGroup = new Composite(parent, 0);
        this.mInnerGroup.setLayout((Layout)new GridLayout());
        this.mInnerGroup.setLayoutData((Object)new GridData(1808));
        this.mInnerGroup.setFont(parent.getFont());
        this.mAllowSelection = allowSelection;
        int style = 67588;
        if (allowSelection) {
            style |= 0x20;
        }
        this.mTable = new Table(this.mInnerGroup, style);
        this.mTable.setHeaderVisible(true);
        this.mTable.setLinesVisible(false);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.mTable.setLayoutData((Object)data);
        this.mDescription = new Label(this.mInnerGroup, 64);
        this.mDescription.setLayoutData((Object)new GridData(768));
        TableColumn column0 = new TableColumn(this.mTable, 0);
        column0.setText("Target Name");
        TableColumn column1 = new TableColumn(this.mTable, 0);
        column1.setText("Vendor");
        TableColumn column2 = new TableColumn(this.mTable, 0);
        column2.setText("Platform");
        TableColumn column3 = new TableColumn(this.mTable, 0);
        column3.setText("API Level");
        this.adjustColumnsWidth(this.mTable, column0, column1, column2, column3);
        this.setupSelectionListener(this.mTable);
        this.setTargets(targets);
        this.setupTooltip(this.mTable);
    }

    public Object getLayoutData() {
        return this.mInnerGroup.getLayoutData();
    }

    public ICocosTarget[] getTargets() {
        return this.mTargets;
    }

    public void setTargets(ICocosTarget[] targets) {
        this.mTargets = targets;
        if (this.mTargets != null) {
            Arrays.sort(this.mTargets, new Comparator<ICocosTarget>(){

                @Override
                public int compare(ICocosTarget o1, ICocosTarget o2) {
                    return o1.compareTo(o2);
                }
            });
        }
        this.fillTable(this.mTable);
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.mSelectionListener = selectionListener;
    }

    public boolean setSelection(ICocosTarget target) {
        if (!this.mAllowSelection) {
            return false;
        }
        boolean found = false;
        boolean modified = false;
        if (this.mTable != null && !this.mTable.isDisposed()) {
            TableItem[] tableItemArray = this.mTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem i = tableItemArray[n2];
                if ((ICocosTarget)i.getData() == target) {
                    found = true;
                    if (!i.getChecked()) {
                        modified = true;
                        i.setChecked(true);
                    }
                } else if (i.getChecked()) {
                    modified = true;
                    i.setChecked(false);
                }
                ++n2;
            }
        }
        if (modified && this.mSelectionListener != null) {
            this.mSelectionListener.widgetSelected(null);
        }
        return found;
    }

    public ICocosTarget getSelected() {
        if (this.mTable == null || this.mTable.isDisposed()) {
            return null;
        }
        TableItem[] tableItemArray = this.mTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem i = tableItemArray[n2];
            if (i.getChecked()) {
                return (ICocosTarget)i.getData();
            }
            ++n2;
        }
        return null;
    }

    private void adjustColumnsWidth(final Table table, final TableColumn column0, final TableColumn column1, final TableColumn column2, final TableColumn column3) {
        table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = table.getClientArea();
                int width = r.width;
                if (CocosTargetSelector.this.mAllowSelection) {
                    width -= CocosTargetSelector.this.getCheckboxWidth();
                }
                column0.setWidth(width * 30 / 100);
                column1.setWidth(width * 45 / 100);
                column2.setWidth(width * 15 / 100);
                column3.setWidth(width * 10 / 100);
            }
        });
    }

    private void setupSelectionListener(Table table) {
        if (!this.mAllowSelection) {
            return;
        }
        table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem i;
                    i.setChecked(!(i = (TableItem)e.item).getChecked());
                    this.enforceSingleSelection(i);
                    CocosTargetSelector.this.updateDescription(i);
                }
                if (CocosTargetSelector.this.mSelectionListener != null) {
                    CocosTargetSelector.this.mSelectionListener.widgetDefaultSelected(e);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem i = (TableItem)e.item;
                    this.enforceSingleSelection(i);
                    CocosTargetSelector.this.updateDescription(i);
                }
                if (CocosTargetSelector.this.mSelectionListener != null) {
                    CocosTargetSelector.this.mSelectionListener.widgetSelected(e);
                }
            }

            private void enforceSingleSelection(TableItem item) {
                if (item.getChecked()) {
                    Table parentTable = item.getParent();
                    TableItem[] tableItemArray = parentTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem i2 = tableItemArray[n2];
                        if (i2 != item && i2.getChecked()) {
                            i2.setChecked(false);
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void fillTable(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        table.removeAll();
        if (this.mTargets != null && this.mTargets.length > 0) {
            table.setEnabled(true);
            ICocosTarget[] iCocosTargetArray = this.mTargets;
            int n = this.mTargets.length;
            int n2 = 0;
            while (n2 < n) {
                ICocosTarget target = iCocosTargetArray[n2];
                TableItem item = new TableItem(table, 0);
                item.setData((Object)target);
                item.setText(0, target.getName());
                item.setText(1, target.getVendor());
                item.setText(2, target.getVersionName());
                item.setText(3, target.getVersion());
                ++n2;
            }
        } else {
            table.setEnabled(false);
            TableItem item = new TableItem(table, 0);
            item.setData(null);
            item.setText(0, "--");
            item.setText(1, "No target available");
            item.setText(2, "--");
            item.setText(3, "--");
        }
    }

    private void setupTooltip(final Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        Listener listener1 = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 3: 
                    case 7: {
                        return;
                    }
                    case 32: {
                        CocosTargetSelector.this.updateDescription(table.getItem(new Point(event.x, event.y)));
                        break;
                    }
                    case 13: {
                        if (!(event.item instanceof TableItem)) break;
                        CocosTargetSelector.this.updateDescription((TableItem)event.item);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        };
        table.addListener(12, listener1);
        table.addListener(1, listener1);
        table.addListener(5, listener1);
        table.addListener(32, listener1);
    }

    private void updateDescription(TableItem item) {
        Object data;
        if (item != null && (data = item.getData()) instanceof ICocosTarget) {
            String newTooltip = ((ICocosTarget)data).getDescription();
            this.mDescription.setText(newTooltip == null ? "" : newTooltip);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.mInnerGroup != null && this.mTable != null && !this.mTable.isDisposed()) {
            this.enableControl((Control)this.mInnerGroup, enabled);
        }
    }

    private void enableControl(Control c, boolean enabled) {
        c.setEnabled(enabled);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c2 = controlArray[n2];
                this.enableControl(c2, enabled);
                ++n2;
            }
        }
    }

    private int getCheckboxWidth() {
        if (sCheckboxWidth == -1) {
            Shell shell = new Shell(this.mTable.getShell(), 8);
            Button checkBox = new Button((Composite)shell, 32);
            sCheckboxWidth = checkBox.computeSize((int)-1, (int)-1).x;
            shell.dispose();
        }
        return sCheckboxWidth;
    }
}

