/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.ccdt.common.CommonJDK;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.CommonPython;
import org.ccdt.common.ui.preferences.CocosEditComboFieldEditor;
import org.ccdt.common.utils.SystemInfo;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CocosPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.ccdt.common.ui.prefs.cocos";
    private CocosDirectoryFieldEditor enginePath;
    private CocosDirectoryFieldEditor sdkPath;
    private CocosDirectoryFieldEditor ndkPath;
    private CocosDirectoryFieldEditor antPath;
    private CocosEditComboFieldEditor pythonCombo;
    private CocosEditComboFieldEditor jdkCombo;
    private Group androidGroup;
    private Group pythonGroup;
    boolean supportVersion = true;

    public CocosPreferencePage() {
        super(1);
        this.setPreferenceStore(CommonPlugin.getDefault().getPreferenceStore());
        this.setDescription("Cocos Code IDE Settings");
    }

    public void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        this.pythonGroup = new Group(composite, 0);
        this.pythonGroup.setLayout((Layout)new GridLayout(3, false));
        GridData pythonGrid = new GridData(4, 4, true, false, 3, 1);
        this.pythonGroup.setLayoutData((Object)pythonGrid);
        this.pythonGroup.setText("Python");
        List<String[]> pythons = CommonPython.loadSystemPython();
        if (pythons == null) {
            ArrayList<String[]> temp = new ArrayList<String[]>();
            this.pythonCombo = new CocosEditComboFieldEditor("org.ccdt.common.python_path", "org.ccdt.common.python_custompath", "Python Location:", temp, (Composite)this.pythonGroup);
        } else {
            int i = 0;
            while (i < pythons.size()) {
                pythons.get((int)i)[0] = pythons.get(i)[1];
                ++i;
            }
            this.pythonCombo = new CocosEditComboFieldEditor("org.ccdt.common.python_path", "org.ccdt.common.python_custompath", "Python Location:", pythons, (Composite)this.pythonGroup);
        }
        this.pythonCombo.getComboBoxControl((Composite)this.pythonGroup).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CocosPreferencePage.this.onTextChanged();
            }
        });
        this.addField(this.pythonCombo);
        this.androidGroup = new Group(composite, 0);
        this.androidGroup.setLayout((Layout)new GridLayout(3, false));
        GridData androidGrid = new GridData(4, 4, true, false, 3, 2);
        this.androidGroup.setLayoutData((Object)androidGrid);
        this.androidGroup.setText("Android");
        this.sdkPath = new CocosDirectoryFieldEditor(this, "org.ccdt.common.sdk_path", "SDK Location:", (Composite)this.androidGroup){

            protected boolean checkState() {
                return this.onTextChanged();
            }
        };
        this.addField((FieldEditor)this.sdkPath);
        this.ndkPath = new CocosDirectoryFieldEditor(this, "org.ccdt.common.ndk_path", "NDK Location:", (Composite)this.androidGroup){

            protected boolean checkState() {
                return this.onTextChanged();
            }
        };
        this.addField((FieldEditor)this.ndkPath);
        this.antPath = new CocosDirectoryFieldEditor(this, "org.ccdt.common.ant_path", "ANT Location:", (Composite)this.androidGroup){

            protected boolean checkState() {
                return this.onTextChanged();
            }
        };
        this.addField((FieldEditor)this.antPath);
        Composite jdkComp = new Composite((Composite)this.androidGroup, 0);
        jdkComp.setLayout((Layout)new GridLayout(3, false));
        GridData jdkGrid = new GridData(4, 4, true, false, 3, 1);
        jdkComp.setLayoutData((Object)jdkGrid);
        List<String[]> jdks = CommonJDK.loadSystemJDK();
        if (jdks == null) {
            ArrayList<String[]> temp = new ArrayList<String[]>();
            this.jdkCombo = new CocosEditComboFieldEditor("org.ccdt.common.jdk_path", "org.ccdt.common.jdk_custompath", "JDK Location:", temp, jdkComp);
        } else {
            int i = 0;
            while (i < jdks.size()) {
                jdks.get((int)i)[0] = jdks.get(i)[1];
                ++i;
            }
            this.jdkCombo = new CocosEditComboFieldEditor("org.ccdt.common.jdk_path", "org.ccdt.common.jdk_custompath", "JDK Location:", jdks, jdkComp);
        }
        this.jdkCombo.getComboBoxControl(jdkComp).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CocosPreferencePage.this.onTextChanged();
            }
        });
        this.addField(this.jdkCombo);
        this.onTextChanged();
    }

    public void init(IWorkbench workbench) {
    }

    private boolean onTextChanged() {
        String antfileName;
        String jdkPath;
        String pyPath;
        File file;
        String sdkfileName = this.sdkPath.getTextControl((Composite)this.androidGroup).getText();
        if (sdkfileName.length() != 0 && !(file = new File(sdkfileName = sdkfileName.trim())).isDirectory()) {
            this.setErrorMessage("SDK path must be an existing directory");
            return false;
        }
        String ndkfileName = this.ndkPath.getTextControl((Composite)this.androidGroup).getText();
        if (ndkfileName.length() != 0) {
            if (ndkfileName.indexOf(" ") > -1) {
                this.setErrorMessage("NDK path cannot exist space character");
                return false;
            }
            File file2 = new File(ndkfileName);
            if (!file2.isDirectory()) {
                this.setErrorMessage("NDK path must be an existing directory");
                return false;
            }
        }
        if ((pyPath = this.pythonCombo.getCurStringVal()) != null) {
            if (pyPath.length() == 0) {
                this.setErrorMessage("Python path must be an existing directory");
                this.setValid(false);
                return false;
            }
            File f = null;
            if (SystemInfo.isWindows) {
                f = new File(String.valueOf(pyPath) + File.separator + "python.exe");
            } else if (SystemInfo.isMac) {
                f = new File(String.valueOf(pyPath) + File.separator + "python");
            }
            if (!f.exists()) {
                this.setErrorMessage("Cannot find python in the directory");
                this.setValid(false);
                return false;
            }
            if (!this.supportVersion) {
                this.setErrorMessage("Python 3.0 or later is not supported");
                this.setValid(false);
                return false;
            }
        }
        if ((jdkPath = this.jdkCombo.getCurStringVal()) != null) {
            if (jdkPath.length() == 0) {
                this.setErrorMessage("JDK path must be an existing directory");
                this.setValid(false);
                return false;
            }
            File f = null;
            if (SystemInfo.isWindows) {
                f = new File(String.valueOf(jdkPath) + File.separator + "javac.exe");
            } else if (SystemInfo.isMac) {
                f = new File(String.valueOf(jdkPath) + File.separator + "javac");
            }
            if (!f.exists()) {
                this.setErrorMessage("Cannot find javac in the directory");
                this.setValid(false);
                return false;
            }
        }
        if ((antfileName = this.antPath.getTextControl((Composite)this.androidGroup).getText()).length() != 0) {
            String[] bfs;
            String[] fs;
            File file3 = new File(antfileName = antfileName.trim());
            if (!file3.isDirectory()) {
                this.setErrorMessage("ANT path must be an existing directory");
                return false;
            }
            String[] stringArray = fs = file3.list();
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                String fn = stringArray[n2];
                if (fn.equals("ant")) {
                    this.setErrorMessage(null);
                    return true;
                }
                ++n2;
            }
            String binPath = "";
            binPath = antfileName.substring(antfileName.length() - 1).equals("\\") || antfileName.substring(antfileName.length() - 1).equals("/") ? String.valueOf(antfileName) + "bin" : String.valueOf(antfileName) + File.separator + "bin";
            File binFolder = new File(binPath);
            if (!binFolder.isDirectory()) {
                this.setErrorMessage("ANT path must be an existing directory");
                return false;
            }
            String[] stringArray2 = bfs = binFolder.list();
            int n3 = bfs.length;
            int n4 = 0;
            while (n4 < n3) {
                String bfn = stringArray2[n4];
                if (bfn.equals("ant")) {
                    this.setErrorMessage(null);
                    return true;
                }
                ++n4;
            }
            this.setErrorMessage("Cannot find ant in the ant path");
            return false;
        }
        this.setValid(true);
        this.setErrorMessage(null);
        return true;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public void dispose() {
        super.dispose();
        if (this.enginePath != null) {
            this.enginePath.dispose();
            this.enginePath = null;
        }
        if (this.sdkPath != null) {
            this.sdkPath.dispose();
            this.sdkPath = null;
        }
        if (this.ndkPath != null) {
            this.ndkPath.dispose();
            this.ndkPath = null;
        }
        if (this.antPath != null) {
            this.antPath.dispose();
            this.antPath = null;
        }
    }

    public class CocosComboFieldEditor
    extends FieldEditor {
        private Combo fCombo;
        private String fValue;
        private String[][] fEntryNamesAndValues;
        private String comboCurVal = null;

        public CocosComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
            this.init(name, labelText);
            Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
            this.fEntryNamesAndValues = entryNamesAndValues;
            this.createControl(parent);
        }

        public String getCurStringVal() {
            return this.comboCurVal;
        }

        private boolean checkArray(String[][] table) {
            if (table == null) {
                return false;
            }
            int i = 0;
            while (i < table.length) {
                String[] array = table[i];
                if (array == null || array.length != 2) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected void adjustForNumColumns(int numColumns) {
            if (numColumns > 1) {
                Label control = this.getLabelControl();
                int left = numColumns;
                if (control != null) {
                    ((GridData)control.getLayoutData()).horizontalSpan = 1;
                    --left;
                }
                ((GridData)this.fCombo.getLayoutData()).horizontalSpan = left;
            } else {
                Label control = this.getLabelControl();
                if (control != null) {
                    ((GridData)control.getLayoutData()).horizontalSpan = 1;
                }
                ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
            }
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            int comboC = 1;
            if (numColumns > 1) {
                comboC = numColumns - 1;
            }
            Label control = this.getLabelControl(parent);
            GridData gd = new GridData();
            gd.horizontalSpan = 1;
            control.setLayoutData((Object)gd);
            control = this.getComboBoxControl(parent);
            gd = new GridData();
            gd.horizontalSpan = comboC;
            gd.horizontalAlignment = 4;
            control.setLayoutData((Object)gd);
            control.setFont(parent.getFont());
        }

        protected void doLoad() {
            this.comboCurVal = this.getPreferenceStore().getString(this.getPreferenceName());
            this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
        }

        protected void doLoadDefault() {
            this.comboCurVal = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
        }

        protected void doStore() {
            if (this.fValue == null) {
                this.getPreferenceStore().setToDefault(this.getPreferenceName());
                return;
            }
            this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
        }

        public int getNumberOfControls() {
            return 2;
        }

        public Combo getComboBoxControl(Composite parent) {
            if (this.fCombo == null) {
                this.fCombo = new Combo(parent, 8);
                this.fCombo.setFont(parent.getFont());
                int i = 0;
                while (i < this.fEntryNamesAndValues.length) {
                    this.fCombo.add(this.fEntryNamesAndValues[i][0], i);
                    ++i;
                }
                this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        String oldValue = CocosComboFieldEditor.this.fValue;
                        String name = CocosComboFieldEditor.this.fCombo.getText();
                        CocosComboFieldEditor.this.fValue = CocosComboFieldEditor.this.getValueForName(name);
                        CocosComboFieldEditor.this.setPresentsDefaultValue(false);
                        CocosComboFieldEditor.this.fireValueChanged("field_editor_value", oldValue, CocosComboFieldEditor.this.fValue);
                    }
                });
            }
            return this.fCombo;
        }

        public String getValueForName(String name) {
            int i = 0;
            while (i < this.fEntryNamesAndValues.length) {
                String[] entry = this.fEntryNamesAndValues[i];
                if (name.equals(entry[0])) {
                    return entry[1];
                }
                ++i;
            }
            return this.fEntryNamesAndValues[0][0];
        }

        public void updateComboForValue(String value) {
            this.fValue = value;
            int i = 0;
            while (i < this.fEntryNamesAndValues.length) {
                if (value.equals(this.fEntryNamesAndValues[i][1])) {
                    this.fCombo.setText(this.fEntryNamesAndValues[i][0]);
                    return;
                }
                ++i;
            }
            if (this.fEntryNamesAndValues.length > 0) {
                this.fValue = this.fEntryNamesAndValues[0][1];
                this.fCombo.setText(this.fEntryNamesAndValues[0][0]);
            }
        }

        protected void fireValueChanged(String property, Object oldValue, Object newValue) {
            this.comboCurVal = newValue.toString();
            super.fireValueChanged(property, oldValue, newValue);
        }

        public void setEnabled(boolean enabled, Composite parent) {
            super.setEnabled(enabled, parent);
            this.getComboBoxControl(parent).setEnabled(enabled);
        }
    }

    private class CocosDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public CocosDirectoryFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setEmptyStringAllowed(true);
        }

        protected boolean doCheckState() {
            String fileName = this.getTextControl().getText();
            fileName = fileName.trim();
            if (this.getTextControl().getText().length() == 0) {
                this.setErrorMessage("Value must be an existing directory");
                return false;
            }
            if (fileName.indexOf(44) >= 0 || fileName.indexOf(59) >= 0) {
                this.setErrorMessage("Value must be an existing directory");
                return false;
            }
            File file = new File(fileName);
            if (!file.isDirectory()) {
                this.setErrorMessage("Value must be an existing directory");
                return false;
            }
            return true;
        }

        protected void doStore() {
            super.doStore();
        }

        public Text getTextControl(Composite parent) {
            this.setValidateStrategy(0);
            return super.getTextControl(parent);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            super.doFillIntoGrid(parent, numColumns);
        }

        public void dispose() {
            super.dispose();
        }
    }
}

