/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.utils.CharacterUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class CocosEditComboFieldEditor
extends FieldEditor {
    private static final String SPECIAL_PREFIX = "[custom]";
    private Combo fCombo;
    private String fValue;
    private String fCustomName;
    private int tag = -1;
    private List<String[]> fEntryKeysAndValues = null;
    private String[] fCustomKeyAndValue = null;

    public CocosEditComboFieldEditor(String name, String customName, String labelText, List<String[]> entryKeysAndValues, Composite parent) {
        this.init(name, labelText);
        this.fCustomName = customName;
        this.fEntryKeysAndValues = entryKeysAndValues;
        this.fCustomKeyAndValue = new String[]{"", ""};
        Assert.isTrue((boolean)this.checkArray());
        this.createControl(parent);
    }

    public String getCurStringVal() {
        String str = this.fCombo.getText();
        if (str.startsWith(SPECIAL_PREFIX)) {
            str = str.substring(SPECIAL_PREFIX.length());
        }
        return str;
    }

    private boolean checkArray() {
        if (this.fEntryKeysAndValues == null) {
            this.fEntryKeysAndValues = new ArrayList<String[]>();
        }
        int i = 0;
        while (i < this.fEntryKeysAndValues.size()) {
            String[] array = this.fEntryKeysAndValues.get(i);
            if (array == null || array.length != 2) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String[] loadCustomValues() {
        if (this.fCustomName == null) {
            return null;
        }
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        if (store.getString(this.fCustomName).length() == 0) {
            return null;
        }
        String[] values = new String[]{"", ""};
        values[0] = SPECIAL_PREFIX + store.getString(this.fCustomName);
        values[1] = store.getString(this.fCustomName);
        return values;
    }

    private void saveCustomValues() {
        if (this.fCustomKeyAndValue[0].length() == 0 || this.fCustomKeyAndValue[1].length() == 0) {
            return;
        }
        String paths = this.fEntryKeysAndValues.get(this.fEntryKeysAndValues.size() - 1)[1];
        if (paths.length() != 0) {
            IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
            store.setValue(this.fCustomName, paths);
        }
    }

    private void defaultCustomValue() {
        if (this.tag == -1 || this.tag >= this.fEntryKeysAndValues.size()) {
            return;
        }
        this.fEntryKeysAndValues.remove(this.tag);
        this.fCombo.remove(this.tag);
        this.tag = -1;
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        store.setValue(this.fCustomName, "");
        this.setPresentsDefaultValue(false);
    }

    protected void adjustForNumColumns(int numColumns) {
        numColumns = 2;
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            int left = numColumns;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = left;
            ((GridData)this.fCombo.getLayoutData()).grabExcessHorizontalSpace = true;
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboC = 1;
        if (numColumns > 1) {
            comboC = numColumns - 1;
        }
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    protected void doLoad() {
        this.getPreferenceStore().getString(this.getPreferenceName());
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.defaultCustomValue();
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.saveCustomValues();
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    public int getNumberOfControls() {
        return 2;
    }

    public Combo getComboBoxControl(final Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 8);
            this.fCombo.setFont(parent.getFont());
            String[] custom = this.loadCustomValues();
            if (custom != null) {
                this.fEntryKeysAndValues.add(custom);
                this.tag = this.fEntryKeysAndValues.size() - 1;
            }
            int i = 0;
            while (i < this.fEntryKeysAndValues.size()) {
                this.fCombo.add(this.fEntryKeysAndValues.get(i)[0], i);
                ++i;
            }
            int size = this.fEntryKeysAndValues.size();
            this.fCombo.add("custom...", size);
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    if (CocosEditComboFieldEditor.this.fCombo.getText().equals("custom...")) {
                        Shell shell = parent.getShell();
                        DirectoryDialog dialog = new DirectoryDialog(shell);
                        String path = dialog.open();
                        if (!CharacterUtil.instance.isEmpty(path)) {
                            if (CocosEditComboFieldEditor.this.tag == -1) {
                                CocosEditComboFieldEditor.this.fEntryKeysAndValues.add(new String[]{"", ""});
                                ((CocosEditComboFieldEditor)CocosEditComboFieldEditor.this).fCustomKeyAndValue[0] = CocosEditComboFieldEditor.SPECIAL_PREFIX + path;
                                ((CocosEditComboFieldEditor)CocosEditComboFieldEditor.this).fCustomKeyAndValue[1] = path;
                                CocosEditComboFieldEditor.this.fEntryKeysAndValues.set(CocosEditComboFieldEditor.this.fEntryKeysAndValues.size() - 1, CocosEditComboFieldEditor.this.fCustomKeyAndValue);
                                CocosEditComboFieldEditor.this.fCombo.setItem(CocosEditComboFieldEditor.this.fEntryKeysAndValues.size() - 1, CocosEditComboFieldEditor.this.fCustomKeyAndValue[0]);
                                CocosEditComboFieldEditor.this.fCombo.add("custom...", CocosEditComboFieldEditor.this.fEntryKeysAndValues.size());
                                CocosEditComboFieldEditor.this.updateComboForValue(path);
                                CocosEditComboFieldEditor.this.tag = CocosEditComboFieldEditor.this.fEntryKeysAndValues.size() - 1;
                            } else {
                                ((CocosEditComboFieldEditor)CocosEditComboFieldEditor.this).fCustomKeyAndValue[0] = CocosEditComboFieldEditor.SPECIAL_PREFIX + path;
                                ((CocosEditComboFieldEditor)CocosEditComboFieldEditor.this).fCustomKeyAndValue[1] = path;
                                CocosEditComboFieldEditor.this.fEntryKeysAndValues.set(CocosEditComboFieldEditor.this.fEntryKeysAndValues.size() - 1, CocosEditComboFieldEditor.this.fCustomKeyAndValue);
                                CocosEditComboFieldEditor.this.fCombo.setItem(CocosEditComboFieldEditor.this.fEntryKeysAndValues.size() - 1, CocosEditComboFieldEditor.this.fCustomKeyAndValue[0]);
                                CocosEditComboFieldEditor.this.updateComboForValue(path);
                            }
                            String oldValue = CocosEditComboFieldEditor.this.fValue;
                            String name = CocosEditComboFieldEditor.this.fCombo.getText();
                            CocosEditComboFieldEditor.this.fValue = CocosEditComboFieldEditor.this.getValueForName(name);
                            CocosEditComboFieldEditor.this.setPresentsDefaultValue(false);
                            CocosEditComboFieldEditor.this.fireValueChanged("field_editor_value", oldValue, CocosEditComboFieldEditor.this.fValue);
                        } else {
                            CocosEditComboFieldEditor.this.updateComboForValue(CocosEditComboFieldEditor.this.getPreferenceStore().getString(CocosEditComboFieldEditor.this.getPreferenceName()));
                        }
                    } else {
                        String oldValue = CocosEditComboFieldEditor.this.fValue;
                        String name = CocosEditComboFieldEditor.this.fCombo.getText();
                        CocosEditComboFieldEditor.this.fValue = CocosEditComboFieldEditor.this.getValueForName(name);
                        CocosEditComboFieldEditor.this.setPresentsDefaultValue(false);
                        CocosEditComboFieldEditor.this.fireValueChanged("field_editor_value", oldValue, CocosEditComboFieldEditor.this.fValue);
                    }
                }
            });
        }
        return this.fCombo;
    }

    public String getValueForName(String name) {
        int i = 0;
        while (i < this.fEntryKeysAndValues.size()) {
            String[] entry = this.fEntryKeysAndValues.get(i);
            if (name.equals(entry[0])) {
                return entry[1];
            }
            ++i;
        }
        return this.fEntryKeysAndValues.get(0)[0];
    }

    public void updateComboForValue(String value) {
        this.fValue = value;
        int i = 0;
        while (i < this.fEntryKeysAndValues.size()) {
            if (value.equals(this.fEntryKeysAndValues.get(i)[1])) {
                this.fCombo.setText(this.fEntryKeysAndValues.get(i)[0]);
                return;
            }
            ++i;
        }
        if (this.fEntryKeysAndValues.size() > 0) {
            this.fValue = this.fEntryKeysAndValues.get(0)[1];
            this.fCombo.setText(this.fEntryKeysAndValues.get(0)[0]);
        } else {
            this.fCombo.removeAll();
            int size = this.fEntryKeysAndValues.size();
            this.fCombo.add("custom...", size);
        }
    }

    protected void fireValueChanged(String property, Object oldValue, Object newValue) {
        newValue.toString();
        super.fireValueChanged(property, oldValue, newValue);
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getComboBoxControl(parent).setEnabled(enabled);
    }
}

