/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.handlers;

import org.ccdt.common.manager.ProjectManager;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.ui.wizard.pages.CocosProjectUpgradeWizard;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UpgradeCocosProjectHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean isYes;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IProject project = ProjectManager.getCurrentProject();
        if (project == null) {
            Dialogs.showMessageDialog("Can not get the project, please select one project and try again.", 2);
            return null;
        }
        boolean canUpgrade = ProjectManager.canUpgrade(project.getLocation().toFile());
        if (!canUpgrade && !(isYes = MessageDialog.openQuestion((Shell)window.getShell(), (String)"Upgrade Cocos Project", (String)"The project you selected has the same version of the engine, \"Yes\" to upgrade again, \"No\" to cancel."))) {
            return null;
        }
        CocosProjectUpgradeWizard wizard = new CocosProjectUpgradeWizard(project);
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
        dialog.open();
        return null;
    }
}

