/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.handlers;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.manager.CocosLaunchManager;
import org.ccdt.common.utils.SystemInfo;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class DebugHandler
extends AbstractHandler
implements IElementUpdater {
    private LaunchConfigChangedListener launchconfigChangedListener = new LaunchConfigChangedListener();
    private IWorkbenchWindow wbwindow = null;
    private IWorkbenchPage activePage = null;
    private SelectionChangedListener selectionChangedListener = new SelectionChangedListener();

    public DebugHandler() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this.launchconfigChangedListener);
        this.wbwindow = CommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        this.activePage = this.wbwindow.getActivePage();
        this.activePage.addSelectionListener((ISelectionListener)this.selectionChangedListener);
    }

    public void finalize() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this.launchconfigChangedListener);
        this.activePage.removeSelectionListener((ISelectionListener)this.selectionChangedListener);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CocosLaunchManager.launchCurrentProject("debug");
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        try {
            String configName = CocosLaunchManager.getTargetProjectName("debug");
            ILaunchConfiguration config = CocosLaunchManager.getLaunchConfig(configName);
            int platform = CocosLaunchManager.getPlatformByLaunchConfig(config);
            if (platform == 0) {
                platform = SystemInfo.isMac ? 2 : 4;
            }
            String icon = null;
            String tooltip = null;
            switch (platform) {
                case 1: {
                    icon = "debug_ios.png";
                    tooltip = "Debug iOS";
                    break;
                }
                case 2: {
                    icon = "debug_mac.png";
                    tooltip = "Debug Mac";
                    break;
                }
                case 3: {
                    icon = "debug_android.png";
                    tooltip = "Debug Android";
                    break;
                }
                case 4: {
                    icon = "debug_win32.png";
                    tooltip = "Debug Win32";
                }
            }
            URL iconUrl = FileLocator.toFileURL((URL)CommonPlugin.getDefault().getBundle().getEntry(String.format("icons/%s", icon)));
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)iconUrl);
            element.setIcon(desc);
            element.setTooltip(tooltip);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void requestRefresh() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
        if (commandService != null) {
            commandService.refreshElements("org.ccdt.common.ui.command.debug", null);
        }
    }

    class LaunchConfigChangedListener
    implements ILaunchConfigurationListener {
        LaunchConfigChangedListener() {
        }

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            DebugHandler.this.requestRefresh();
        }

        public void launchConfigurationChanged(ILaunchConfiguration configuration) {
            DebugHandler.this.requestRefresh();
        }

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            DebugHandler.this.requestRefresh();
        }
    }

    class SelectionChangedListener
    implements ISelectionListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            DebugHandler.this.requestRefresh();
        }
    }
}

