/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class ResourceSelectionDialog
extends FilteredResourcesSelectionDialog {
    private String extension = "";
    private String msg = "";

    public ResourceSelectionDialog(Shell shell, boolean multi, IContainer container, String extension, String msg) {
        super(shell, multi, container, 3);
        this.extension = extension;
        this.msg = msg;
        this.setInitialPattern("*." + extension);
    }

    protected String getMessage() {
        return this.msg;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FileFilter();
    }

    class FileFilter
    extends FilteredResourcesSelectionDialog.ResourceFilter {
        FileFilter() {
            super((FilteredResourcesSelectionDialog)ResourceSelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            return super.matchItem(item) && this.isExtensionRight((IResource)item);
        }

        boolean isExtensionRight(IResource file) {
            String fileExtension = file.getFileExtension();
            if (fileExtension == null) {
                return false;
            }
            return fileExtension.equalsIgnoreCase(ResourceSelectionDialog.this.extension);
        }
    }
}

