/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.ccdt.common.CommonConstants;
import org.ccdt.common.CommonPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class EntryFileSelectionDialog
extends FilteredItemsSelectionDialog {
    private static List<String> resources = new ArrayList<String>();
    private File projRoot;
    private static final String DIALOG_SETTINGS = "FilteredResourcesSelectionDialogSettings";

    private EntryFileSelectionDialog(Shell shell) {
        super(shell);
    }

    private EntryFileSelectionDialog(Shell shell, boolean multi) {
        super(shell, multi);
        this.setTitle("Filtered Resources Selection Dialog");
    }

    public EntryFileSelectionDialog(Shell shell, File projRoot) {
        this(shell, false);
        this.setTitle("Filtered Resources Selection Dialog");
        this.projRoot = projRoot;
        this.loadScripts();
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = CommonPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = CommonPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ResourceFilter();
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
    }

    protected Comparator getItemsComparator() {
        return new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        };
    }

    protected void applyFilter() {
        super.applyFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask("Searching", resources.size());
        Iterator<String> iter = resources.iterator();
        while (iter.hasNext()) {
            contentProvider.add((Object)iter.next(), itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    protected void loadScripts() {
        block5: {
            File[] files;
            if (this.projRoot == null) break block5;
            File[] fileArray = files = this.projRoot.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    File f;
                    block6: {
                        f = fileArray[n2];
                        if (!f.isDirectory()) break block6;
                        if (CommonConstants.IGNORED_FILE_OR_DIR.contains(f.getName())) break block7;
                        this.collectScriptsInProject(f, resources);
                    }
                    if (f.getAbsolutePath().toLowerCase().endsWith(".lua") || f.getAbsolutePath().toLowerCase().endsWith(".js")) {
                        String relativePath = f.getAbsolutePath().substring(this.projRoot.getAbsolutePath().length() + 1);
                        String path = relativePath.replaceAll("\\\\", "/");
                        resources.add(path);
                    }
                }
                ++n2;
            }
        }
    }

    private void collectScriptsInProject(File directory, List<String> list) {
        File[] files;
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.collectScriptsInProject(f, list);
            }
            if (f.getAbsolutePath().toLowerCase().endsWith(".lua") || f.getAbsolutePath().toLowerCase().endsWith(".js")) {
                String relativePath = f.getAbsolutePath().substring(this.projRoot.getAbsolutePath().length() + 1);
                String path = relativePath.replaceAll("\\\\", "/");
                list.add(path);
            }
            ++n2;
        }
    }

    public String getElementName(Object item) {
        return item.toString();
    }

    private class ResourceFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private ResourceFilter() {
            super((FilteredItemsSelectionDialog)EntryFileSelectionDialog.this);
        }

        public boolean matchItem(Object item) {
            String resource = item.toString();
            return this.matches(resource);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }
    }
}

