/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.dialogs;

import org.ccdt.common.ui.dialogs.WizardDialogWithCloseButton;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class Dialogs {
    public static void showPreferencesDialog(String message, String prefPageID) {
        Dialogs.showPreferencesDialog(message, prefPageID, 1);
    }

    public static void showPreferencesDialog(final String message, final String prefPageID, final int type) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PreferenceDialog pref;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog dialog = new MessageDialog(shell, "Cocos", null, message, type, new String[]{"Open Prefrences ...", "Cancel"}, 0);
                int result = dialog.open();
                if (result == 0 && (pref = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)prefPageID, null, null)) != null) {
                    pref.open();
                }
            }
        });
    }

    public static void showWizardDialog(String message, IWizard wizard) {
        Dialogs.showWizardDialog(message, wizard, 1);
    }

    public static void showWizardDialog(final String message, final IWizard wizard, final int type) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                WizardDialogWithCloseButton wd;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog dialog = new MessageDialog(shell, "Cocos", null, message, type, new String[]{"Yes", "No"}, 0);
                int result = dialog.open();
                if (result == 0 && (wd = new WizardDialogWithCloseButton(shell, wizard){

                    protected void nextPressed() {
                        super.nextPressed();
                    }
                }) != null) {
                    wd.open();
                }
            }
        });
    }

    public static void showWizardDialog(final IWizard wizard, final IPreAction preAction) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                WizardDialogWithCloseButton wd;
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                boolean doit = preAction.doit(shell);
                if (doit && (wd = new WizardDialogWithCloseButton(shell, wizard){

                    protected void nextPressed() {
                        super.nextPressed();
                    }
                }) != null) {
                    wd.open();
                }
            }
        });
    }

    public static void showMessageDialog(String message) {
        Dialogs.showMessageDialog(message, 1);
    }

    public static void showMessageDialog(final String message, final int type) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog dialog = new MessageDialog(shell, "Cocos", null, message, type, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    public static void showMessageBox(String message) {
        Dialogs.showMessageBox(message, 4);
    }

    public static void showMessageBox(final String message, final int type) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageBox messageBox = new MessageBox(shell, type | 0x40 | 0x80);
                messageBox.setMessage(message);
                messageBox.open();
            }
        });
    }

    public static void openLaunchConfigurationDialog(final String message, final String mode) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String label = null;
                label = mode.equals("debug") ? "Open Debug Configurations ..." : "Open Run Configurations ...";
                MessageDialog dialog = new MessageDialog(shell, "Cocos", null, message, 1, new String[]{label, "Cancel"}, 0);
                int result = dialog.open();
                if (result == 0) {
                    IWorkbenchWindow dwindow = DebugUIPlugin.getActiveWorkbenchWindow();
                    if (dwindow == null) {
                        return;
                    }
                    LaunchConfigurationsDialog config = new LaunchConfigurationsDialog(DebugUIPlugin.getShell(), DebugUIPlugin.getDefault().getLaunchConfigurationManager().getDefaultLaunchGroup(mode));
                    config.setOpenMode(2);
                    config.open();
                }
            }
        });
    }

    public static interface IPreAction {
        public boolean doit(Shell var1);
    }
}

