/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.ui.control;

import org.ccdt.common.CommonPlugin;
import org.ccdt.common.manager.CocosLaunchManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class CurrentProjectLabel
extends WorkbenchWindowControlContribution {
    static final String TARGET_PROJECT = "Target:";
    private IWorkbenchWindow wbwindow = null;
    private IWorkbenchPage activePage = null;
    private SelectionChangedListener selectionChangedListener = new SelectionChangedListener();
    private Composite comp = null;
    private Label label;
    private Label project = null;

    public CurrentProjectLabel() {
        this.wbwindow = CommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        this.activePage = this.wbwindow.getActivePage();
        this.activePage.addSelectionListener((ISelectionListener)this.selectionChangedListener);
    }

    public void finalize() {
        this.activePage.removeSelectionListener((ISelectionListener)this.selectionChangedListener);
    }

    protected Control createControl(Composite parent) {
        this.comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 2;
        layout.marginWidth = 0;
        this.comp.setLayout((Layout)layout);
        this.label = new Label(this.comp, 131072);
        this.label.setText(TARGET_PROJECT);
        this.project = new Label(this.comp, 16384);
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = 2;
        griddata.grabExcessHorizontalSpace = true;
        this.project.setLayoutData((Object)griddata);
        this.updateLabel();
        return this.comp;
    }

    private void updateLabel() {
        String text = "None";
        String tooltip = String.format("%sNone", TARGET_PROJECT);
        String name = CocosLaunchManager.getTargetProjectName("debug");
        if (this.project.isDisposed() || this.project.getText().equals(name)) {
            return;
        }
        if (name != null && !name.isEmpty()) {
            text = name;
            this.project.setText(name);
            tooltip = String.format("%s%s", TARGET_PROJECT, name);
        }
        this.label.setToolTipText(tooltip);
        this.project.setText(text);
        this.project.setToolTipText(tooltip);
        IWorkbenchWindow activeWorkbenchWindow = CommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null || activeWorkbenchWindow.getActivePage() == null || activeWorkbenchWindow.getActivePage().getActivePart() == null) {
            return;
        }
        IWorkbenchPart activePart = activeWorkbenchWindow.getActivePage().getActivePart();
        if ("org.ccdt.lua.ui.explorer.CocosExplorer".equals(activePart.getClass().getName()) || "org.ccdt.js.ui.explorer.CocosExplorer".equals(activePart.getClass().getName())) {
            this.resizeToolbar();
        }
    }

    void resizeToolbar() {
        try {
            int width = 0;
            GC gc = new GC((Drawable)this.project);
            String text = this.project.getText();
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                width += gc.getAdvanceWidth(c);
                ++i;
            }
            this.project.getShell().setRedraw(false);
            Point size = this.project.getParent().getParent().getParent().computeSize(this.label.getBounds().width + width + 10, -1);
            this.project.getParent().getParent().getParent().setSize(size);
            this.project.getParent().getParent().setSize(size);
            this.project.getParent().setSize(size);
            this.project.setSize(size);
            IWorkbenchWindow activeWorkbenchWindow = CommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow instanceof WorkbenchWindow) {
                WorkbenchWindow window = (WorkbenchWindow)activeWorkbenchWindow;
                window.toggleToolbarVisibility();
                window.toggleToolbarVisibility();
            }
            this.project.getShell().setRedraw(true);
            gc.dispose();
        }
        catch (Throwable throwable) {}
    }

    class SelectionChangedListener
    implements ISelectionListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            CurrentProjectLabel.this.updateLabel();
        }
    }
}

