/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.search.source.show;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class SourceCompletionProposal
implements ICompletionProposalExtension6,
ICompletionProposal {
    public static int WORKSPACE_TYPE_FILE = 0;
    public static int SEARCH_TYPE_FILE = 1;
    public static int WORKSPACE_TYPE_FOLDER = 2;
    public static int SEARCH_TYPE_FOLDER = 3;
    private int fType;
    private String fKey;
    private List<Integer> fPositions;
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private String fAdditionalProposalInfo;
    private StyledString.Styler styler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            Display display = Display.getDefault();
            textStyle.foreground = display.getSystemColor(2);
            Font font = JFaceResources.getDefaultFont();
            FontData[] fds = font.getFontData();
            if (fds.length > 0) {
                FontData data = fds[0];
                textStyle.font = new Font((Device)display, data.getName(), data.getHeight(), 1);
            }
        }
    };

    public SourceCompletionProposal(int type, String key, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        this.fKey = key;
        this.fType = type;
    }

    public SourceCompletionProposal(int type, List<Integer> positions, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        this.fPositions = positions;
        this.fType = type;
    }

    public SourceCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public StyledString getStyledDisplayString() {
        StyledString styledString = new StyledString(this.fDisplayString);
        int styledStringLength = styledString.length();
        if (this.fKey != null) {
            int offset = this.fDisplayString.toLowerCase().indexOf(this.fKey.toLowerCase());
            int length = this.fKey.length();
            if (offset > -1 && length > 0 && length <= styledStringLength) {
                styledString.setStyle(offset, length, this.styler);
            }
        } else if (this.fPositions != null) {
            int i = 0;
            while (i < this.fPositions.size()) {
                Integer position = this.fPositions.get(i);
                if (position >= 0 && position <= styledStringLength) {
                    styledString.setStyle(position.intValue(), 1, this.styler);
                }
                ++i;
            }
        }
        return styledString;
    }

    public int getType() {
        return this.fType;
    }
}

