/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.search.source.key;

import java.util.ArrayList;
import java.util.List;
import org.ccdt.common.search.source.key.CollectionKeys;
import org.ccdt.common.search.source.key.KeySearch;
import org.ccdt.common.search.source.key.SelfKeyRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class LuaKeySearch
extends KeySearch {
    private IDocument document;
    private int start;
    private int end;
    private int position;
    private String leftStr;
    private String twoSideStr;
    private List<String> keys = new ArrayList<String>();

    public LuaKeySearch(IDocument document, int start, int end, int position) {
        this.document = document;
        this.start = start;
        this.end = end;
        this.position = position;
    }

    @Override
    public List<String> createKeys() {
        int strStart = this.start + 1;
        int strLength = this.end - this.start - 2;
        int strEnd = strStart + strLength;
        try {
            this.leftStr = this.document.get(strStart, this.position - strStart);
            this.twoSideStr = this.document.get(strStart, strLength);
        }
        catch (BadLocationException badLocationException) {}
        this.collectKeys(this.leftStr);
        if (this.position == strEnd) {
            this.type = 0;
        } else {
            this.type = 1;
            this.collectKeys(this.twoSideStr);
        }
        return this.keys;
    }

    private void collectKeys(String str) {
        if (str != null && str.length() >= 2) {
            CollectionKeys collectionKeys = new CollectionKeys(str);
            collectionKeys.addRule(new SelfKeyRule());
            this.keys.addAll(collectionKeys.collectRules());
        }
    }
}

