/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.search.source.filter;

import java.util.List;
import org.ccdt.common.search.source.ISearchSource;

public abstract class FilterHandler {
    protected FilterHandler nextFilterHandler;
    protected List<ISearchSource> sources;
    protected List<ISearchSource> filterSources;
    protected List<String> keys;

    public FilterHandler() {
    }

    public FilterHandler(List<ISearchSource> sources, List<String> keys) {
        this.sources = sources;
        this.keys = keys;
    }

    public void setSources(List<ISearchSource> sources) {
        this.sources = sources;
    }

    public void setKeys(List<String> keys) {
        this.keys = keys;
    }

    public List<ISearchSource> getFilterSources() {
        return this.filterSources;
    }

    public void handFilter() {
        this.doFilter();
        if (this.nextFilterHandler != null && this.filterSources != null) {
            this.nextFilterHandler.setSources(this.filterSources);
            this.nextFilterHandler.setKeys(this.keys);
            this.nextFilterHandler.handFilter();
            List<ISearchSource> nextFilterSources = this.nextFilterHandler.getFilterSources();
            if (nextFilterSources != null) {
                this.filterSources = nextFilterSources;
            }
        }
    }

    protected abstract void doFilter();

    public FilterHandler getNextFilterHandler() {
        return this.nextFilterHandler;
    }

    public void setNextFilterHandler(FilterHandler nextFilterHandler) {
        this.nextFilterHandler = nextFilterHandler;
    }
}

