/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.search.source;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ccdt.common.search.source.ISearchSource;
import org.ccdt.common.search.source.key.SourceKeySearch;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class WorkspaceSearchSource
implements ISearchSource {
    private IResource resource;
    private String showPath;
    private String showPathByIndex;
    private Map<String, List<Integer>> keyInfos = new HashMap<String, List<Integer>>();

    public WorkspaceSearchSource(IResource resource) {
        this.resource = resource;
        this.init();
    }

    public WorkspaceSearchSource(IResource resource, boolean onlyFileName) {
        String name;
        int lastIndex;
        this.resource = resource;
        this.init();
        if (onlyFileName && (lastIndex = (name = resource.getName()).lastIndexOf(46)) > 1) {
            this.showPath = name = name.substring(0, lastIndex);
            this.showPathByIndex = name;
        }
    }

    @Override
    public void setSource(Object object) {
        if (object instanceof IResource) {
            this.resource = (IResource)object;
            this.init();
        }
    }

    private void init() {
        IPath path;
        if ((this.resource instanceof IFolder || this.resource instanceof IFile) && (path = this.resource.getProjectRelativePath()) != null) {
            this.showPath = path.toString();
            StringBuffer pathByIndex = new StringBuffer();
            String[] segments = path.segments();
            int i = 0;
            while (i < segments.length) {
                String segment = segments[i];
                pathByIndex.append(segment);
                if (i < segments.length - 1) {
                    pathByIndex.append(".");
                }
                ++i;
            }
            this.showPathByIndex = pathByIndex.toString();
            String name = this.resource.getName();
            int lastIndex = name.lastIndexOf(46);
            if (lastIndex > 1) {
                name = name.substring(0, lastIndex);
            }
            int lastSep = this.showPath.lastIndexOf(47);
            int start = 0;
            if (lastSep > 0) {
                start = lastSep + 1;
            }
            SourceKeySearch sourceKeySearch = new SourceKeySearch(start, name);
            this.keyInfos.putAll(sourceKeySearch.createKeyInfos());
        }
    }

    @Override
    public boolean isFolder() {
        return this.resource instanceof IFolder;
    }

    @Override
    public boolean isFile() {
        return this.resource instanceof File;
    }

    @Override
    public boolean exists() {
        return this.resource != null && this.resource.exists();
    }

    @Override
    public String getFileName() {
        if (this.resource instanceof File) {
            File file = (File)this.resource;
            return file.getName();
        }
        return null;
    }

    @Override
    public String getFileExt() {
        if (this.resource instanceof File) {
            File file = (File)this.resource;
            return file.getFileExtension();
        }
        return null;
    }

    @Override
    public String getShowPath() {
        return this.showPath;
    }

    @Override
    public void setShowPath(String path) {
        this.showPath = path;
    }

    @Override
    public String getShowPathByIndex() {
        return this.showPathByIndex;
    }

    @Override
    public void setShowPathByIndex(String path) {
        this.showPathByIndex = path;
    }

    @Override
    public Map<String, List<Integer>> getKeyInfos() {
        return this.keyInfos;
    }
}

