/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.search.source;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.manager.ResourceManager;
import org.ccdt.common.search.source.FileSourceCollection;
import org.ccdt.common.search.source.ISearchSource;
import org.ccdt.common.search.source.ISearchVaildator;
import org.ccdt.common.search.source.ProjectSourceCollection;
import org.ccdt.common.search.source.SourceCollection;
import org.ccdt.common.search.source.key.KeySearch;
import org.ccdt.common.search.source.key.LuaKeySearch;
import org.ccdt.common.search.source.show.SourceCompletionProposal;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.program.Program;

public class SourceSearchUtils {
    private static final String LUA_EXT = ".lua";
    private static final String SEARCH_PATHS_SEQ = " - <searchPath>:";

    static {
        ResourceManager.IMAGE.put("icons/search/folder.gif", CommonPlugin.getImageDescriptor("icons/search/folder.gif"));
        ResourceManager.IMAGE.put("icons/search/file.gif", CommonPlugin.getImageDescriptor("icons/search/file.gif"));
    }

    public static List<ICompletionProposal> createSearchSourcesProposals(IProject project, Set<String> searchPaths, List<ISearchVaildator> vaildators, IDocument document, int start, int end, int position, boolean isAddSearchPath) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        ArrayList<ISearchSource> list = new ArrayList<ISearchSource>();
        if (project != null) {
            ProjectSourceCollection projectSourceCollection = new ProjectSourceCollection();
            projectSourceCollection.addAllSearchVaildator(vaildators);
            ((SourceCollection)projectSourceCollection).find(project);
            List<ISearchSource> searchSources = projectSourceCollection.getSearchSources();
            list.addAll(searchSources);
        }
        LuaKeySearch keySearch = new LuaKeySearch(document, start, end, position);
        List<String> keys = ((KeySearch)keySearch).createKeys();
        int i = 0;
        while (i < list.size()) {
            ISearchSource searchSource = (ISearchSource)list.get(i);
            Map<String, List<Integer>> sourceKeyInfos = searchSource.getKeyInfos();
            int j = 0;
            while (j < keys.size()) {
                String key = keys.get(j);
                for (Map.Entry<String, List<Integer>> entry : sourceKeyInfos.entrySet()) {
                    String sourceKey = entry.getKey();
                    List<Integer> positions = entry.getValue();
                    String showPath = searchSource.getShowPath();
                    String showPathByIndex = searchSource.getShowPathByIndex();
                    if (sourceKey == null || showPath == null) continue;
                    if (showPathByIndex.toLowerCase().indexOf(key.toLowerCase()) > -1 || showPath.toLowerCase().indexOf(key.toLowerCase()) > -1) {
                        SourceSearchUtils.createCompletionProposal(key, proposals, start, end, searchSource);
                        if (!isAddSearchPath || searchPaths == null) break;
                        SourceSearchUtils.createSearchPathsCompletionProposal(key, proposals, project, start, end, searchSource, searchPaths);
                        break;
                    }
                    if (!sourceKey.toLowerCase().startsWith(key.toLowerCase())) continue;
                    int keyLength = key.length();
                    List<Integer> newPositions = new ArrayList<Integer>();
                    if (positions != null) {
                        newPositions = positions.subList(0, keyLength);
                    }
                    SourceSearchUtils.createCompletionProposal(newPositions, proposals, start, end, searchSource);
                    if (!isAddSearchPath || searchPaths == null) break;
                    SourceSearchUtils.createSearchPathsCompletionProposal(newPositions, proposals, project, start, end, searchSource, searchPaths);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return proposals;
    }

    public static List<ICompletionProposal> createSearchSourcesProposals(File file, List<String> searchPaths, List<ISearchVaildator> vaildators, IDocument document, int start, int end, int position) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (file == null || !file.exists()) {
            return proposals;
        }
        ArrayList<ISearchSource> list = new ArrayList<ISearchSource>();
        FileSourceCollection projectSourceCollection = new FileSourceCollection();
        projectSourceCollection.addAllSearchVaildator(vaildators);
        ((SourceCollection)projectSourceCollection).find(file);
        List<ISearchSource> searchSources = projectSourceCollection.getSearchSources();
        list.addAll(searchSources);
        LuaKeySearch keySearch = new LuaKeySearch(document, start, end, position);
        List<String> keys = ((KeySearch)keySearch).createKeys();
        int i = 0;
        while (i < list.size()) {
            ISearchSource searchSource = (ISearchSource)list.get(i);
            Map<String, List<Integer>> sourceKeyInfos = searchSource.getKeyInfos();
            int j = 0;
            while (j < keys.size()) {
                String key = keys.get(j);
                for (Map.Entry<String, List<Integer>> entry : sourceKeyInfos.entrySet()) {
                    String sourceKey = entry.getKey();
                    List<Integer> positions = entry.getValue();
                    String showPath = searchSource.getShowPath();
                    if (sourceKey == null || showPath == null) continue;
                    if (showPath.toLowerCase().indexOf(key.toLowerCase()) > -1) {
                        SourceSearchUtils.createCompletionProposal(key, proposals, start, end, searchSource);
                        break;
                    }
                    if (!sourceKey.toLowerCase().startsWith(key.toLowerCase())) continue;
                    int keyLength = key.length();
                    List<Integer> newPositions = new ArrayList<Integer>();
                    if (positions != null) {
                        newPositions = positions.subList(0, keyLength);
                    }
                    SourceSearchUtils.createCompletionProposal(newPositions, proposals, start, end, searchSource);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return proposals;
    }

    public static List<ICompletionProposal> createRequireSearchSourcesProposals(IProject project, Set<String> searchPaths, List<ISearchVaildator> vaildators, IDocument document, int start, int end, int position) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        ArrayList<ISearchSource> list = new ArrayList<ISearchSource>();
        if (project != null) {
            ProjectSourceCollection projectSourceCollection = new ProjectSourceCollection();
            projectSourceCollection.addAllSearchVaildator(vaildators);
            ((SourceCollection)projectSourceCollection).find(project);
            List<ISearchSource> searchSources = projectSourceCollection.getSearchSources();
            list.addAll(searchSources);
        }
        LuaKeySearch keySearch = new LuaKeySearch(document, start, end, position);
        List<String> keys = ((KeySearch)keySearch).createKeys();
        int i = 0;
        while (i < list.size()) {
            ISearchSource searchSource = (ISearchSource)list.get(i);
            Map<String, List<Integer>> sourceKeyInfos = searchSource.getKeyInfos();
            int j = 0;
            while (j < keys.size()) {
                String key = keys.get(j);
                for (Map.Entry<String, List<Integer>> entry : sourceKeyInfos.entrySet()) {
                    String sourceKey = entry.getKey();
                    List<Integer> positions = entry.getValue();
                    String showPath = searchSource.getShowPath();
                    String showPathByIndex = searchSource.getShowPathByIndex();
                    if (sourceKey == null || showPath == null) continue;
                    if (showPathByIndex.toLowerCase().indexOf(key.toLowerCase()) > -1 || showPath.toLowerCase().indexOf(key.toLowerCase()) > -1) {
                        SourceSearchUtils.createRequireCompletionProposals(key, proposals, start, end, searchSource);
                        if (searchPaths == null) break;
                        SourceSearchUtils.createRequireSearchPathsCompletionProposal(key, proposals, project, start, end, searchSource, searchPaths);
                        break;
                    }
                    if (!sourceKey.toLowerCase().startsWith(key.toLowerCase())) continue;
                    int keyLength = key.length();
                    List<Integer> newPositions = new ArrayList<Integer>();
                    if (positions != null) {
                        newPositions = positions.subList(0, keyLength);
                    }
                    SourceSearchUtils.createRequireCompletionProposals(key, newPositions, proposals, start, end, searchSource);
                    if (searchPaths == null) break;
                    SourceSearchUtils.createRequireSearchPathsCompletionProposal(newPositions, proposals, project, start, end, searchSource, searchPaths);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return proposals;
    }

    public static List<ICompletionProposal> createRequireSearchSourcesProposals(File file, Set<String> searchPaths, List<ISearchVaildator> vaildators, IDocument document, int start, int end, int position) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (file == null || !file.exists()) {
            return proposals;
        }
        ArrayList<ISearchSource> list = new ArrayList<ISearchSource>();
        FileSourceCollection fileSourceCollection = new FileSourceCollection();
        fileSourceCollection.addAllSearchVaildator(vaildators);
        ((SourceCollection)fileSourceCollection).find(file);
        List<ISearchSource> searchSources = fileSourceCollection.getSearchSources();
        list.addAll(searchSources);
        LuaKeySearch keySearch = new LuaKeySearch(document, start, end, position);
        List<String> keys = ((KeySearch)keySearch).createKeys();
        int i = 0;
        while (i < list.size()) {
            ISearchSource searchSource = (ISearchSource)list.get(i);
            Map<String, List<Integer>> sourceKeyInfos = searchSource.getKeyInfos();
            int j = 0;
            while (j < keys.size()) {
                String key = keys.get(j);
                for (Map.Entry<String, List<Integer>> entry : sourceKeyInfos.entrySet()) {
                    String sourceKey = entry.getKey();
                    List<Integer> positions = entry.getValue();
                    String showPath = searchSource.getShowPath();
                    String showPathByIndex = searchSource.getShowPathByIndex();
                    if (sourceKey == null || showPath == null) continue;
                    if (showPathByIndex != null && showPathByIndex.toLowerCase().indexOf(key.toLowerCase()) > -1 || showPath.toLowerCase().indexOf(key.toLowerCase()) > -1) {
                        SourceSearchUtils.createRequireCompletionProposals(key, proposals, start, end, searchSource);
                        break;
                    }
                    if (!sourceKey.toLowerCase().startsWith(key.toLowerCase())) continue;
                    int keyLength = key.length();
                    List<Integer> newPositions = new ArrayList<Integer>();
                    if (positions != null) {
                        newPositions = positions.subList(0, keyLength);
                    }
                    SourceSearchUtils.createRequireCompletionProposals(key, newPositions, proposals, start, end, searchSource);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return proposals;
    }

    private static void createRequireCompletionProposals(String key, List<ICompletionProposal> proposals, int start, int end, ISearchSource searchSource) {
        SourceCompletionProposal sourceCompletionProposal;
        String additionalProposalInfo;
        IContextInformation contextInformation;
        String displayString;
        Image image;
        int cursorPosition;
        int replacementOffset;
        int replacementLength;
        String showPath = searchSource.getShowPath();
        String showPathByIndex = searchSource.getShowPathByIndex();
        if (showPathByIndex != null && showPathByIndex.toLowerCase().indexOf(key.toLowerCase()) > -1) {
            if (showPathByIndex.endsWith(LUA_EXT)) {
                int length = showPathByIndex.length();
                showPathByIndex = showPathByIndex.substring(0, length - LUA_EXT.length());
            }
            String replacementString = showPathByIndex;
            replacementLength = end - start - 2;
            replacementOffset = start + 1;
            cursorPosition = replacementString.length();
            image = SourceSearchUtils.createImage(searchSource);
            displayString = showPathByIndex;
            contextInformation = null;
            additionalProposalInfo = null;
            sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.WORKSPACE_TYPE_FOLDER : SourceCompletionProposal.WORKSPACE_TYPE_FILE, key, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
            proposals.add(sourceCompletionProposal);
        }
        if (showPathByIndex != null && showPath.toLowerCase().indexOf(key.toLowerCase()) > -1 && !showPath.toLowerCase().equals(showPathByIndex.toLowerCase())) {
            if (showPath.endsWith(LUA_EXT)) {
                int length = showPath.length();
                showPath = showPath.substring(0, length - LUA_EXT.length());
            }
            String replacementString = showPath;
            replacementLength = end - start - 2;
            replacementOffset = start + 1;
            cursorPosition = replacementString.length();
            image = SourceSearchUtils.createImage(searchSource);
            displayString = showPath;
            contextInformation = null;
            additionalProposalInfo = null;
            sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.WORKSPACE_TYPE_FOLDER : SourceCompletionProposal.WORKSPACE_TYPE_FILE, key, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
            proposals.add(sourceCompletionProposal);
        }
    }

    private static void createRequireCompletionProposals(String key, List<Integer> positions, List<ICompletionProposal> proposals, int start, int end, ISearchSource searchSource) {
        String showPath = searchSource.getShowPath();
        String showPathByIndex = searchSource.getShowPathByIndex();
        if (showPathByIndex.endsWith(LUA_EXT)) {
            int length = showPathByIndex.length();
            showPathByIndex = showPathByIndex.substring(0, length - LUA_EXT.length());
        }
        String replacementString = showPathByIndex;
        int replacementLength = end - start - 2;
        int replacementOffset = start + 1;
        int cursorPosition = replacementString.length();
        Image image = SourceSearchUtils.createImage(searchSource);
        String displayString = showPathByIndex;
        IContextInformation contextInformation = null;
        String additionalProposalInfo = null;
        SourceCompletionProposal sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.WORKSPACE_TYPE_FOLDER : SourceCompletionProposal.WORKSPACE_TYPE_FILE, positions, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        proposals.add(sourceCompletionProposal);
        if (showPath.endsWith(LUA_EXT)) {
            int length = showPath.length();
            showPath = showPath.substring(0, length - LUA_EXT.length());
        }
        replacementString = showPath;
        replacementLength = end - start - 2;
        replacementOffset = start + 1;
        cursorPosition = replacementString.length();
        image = SourceSearchUtils.createImage(searchSource);
        displayString = showPath;
        contextInformation = null;
        additionalProposalInfo = null;
        sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.WORKSPACE_TYPE_FOLDER : SourceCompletionProposal.WORKSPACE_TYPE_FILE, positions, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        proposals.add(sourceCompletionProposal);
    }

    private static void createCompletionProposal(String key, List<ICompletionProposal> proposals, int start, int end, ISearchSource searchSource) {
        String showPath;
        String replacementString = showPath = searchSource.getShowPath();
        int replacementLength = end - start - 2;
        int replacementOffset = start + 1;
        int cursorPosition = replacementString.length();
        Image image = SourceSearchUtils.createImage(searchSource);
        String displayString = showPath;
        IContextInformation contextInformation = null;
        String additionalProposalInfo = null;
        SourceCompletionProposal sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.WORKSPACE_TYPE_FOLDER : SourceCompletionProposal.WORKSPACE_TYPE_FILE, key, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        proposals.add(sourceCompletionProposal);
    }

    private static void createCompletionProposal(List<Integer> positions, List<ICompletionProposal> proposals, int start, int end, ISearchSource searchSource) {
        String showPath;
        String replacementString = showPath = searchSource.getShowPath();
        int replacementLength = end - start - 2;
        int replacementOffset = start + 1;
        int cursorPosition = replacementString.length();
        Image image = SourceSearchUtils.createImage(searchSource);
        String displayString = showPath;
        IContextInformation contextInformation = null;
        String additionalProposalInfo = null;
        SourceCompletionProposal sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.WORKSPACE_TYPE_FOLDER : SourceCompletionProposal.WORKSPACE_TYPE_FILE, positions, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
        proposals.add(sourceCompletionProposal);
    }

    private static SourceCompletionProposal createSearchPathsCompletionProposal(String key, List<ICompletionProposal> proposals, IProject project, int start, int end, ISearchSource searchSource, Set<String> searchPaths) {
        String showPath = searchSource.getShowPath();
        for (String searchPath : searchPaths) {
            IResource resource = project.findMember(searchPath);
            String parentPath = resource.getProjectRelativePath().toString();
            if (!showPath.startsWith(parentPath) || showPath.length() <= parentPath.length()) continue;
            String replacementString = showPath.substring(parentPath.length() + 1);
            int replacementLength = end - start - 2;
            int replacementOffset = start + 1;
            int cursorPosition = replacementString.length();
            Image image = SourceSearchUtils.createImage(searchSource);
            String displayString = String.valueOf(replacementString) + SEARCH_PATHS_SEQ + parentPath;
            IContextInformation contextInformation = null;
            String additionalProposalInfo = null;
            SourceCompletionProposal sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.SEARCH_TYPE_FOLDER : SourceCompletionProposal.SEARCH_TYPE_FILE, key, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
            proposals.add(sourceCompletionProposal);
        }
        return null;
    }

    private static SourceCompletionProposal createSearchPathsCompletionProposal(List<Integer> positions, List<ICompletionProposal> proposals, IProject project, int start, int end, ISearchSource searchSource, Set<String> searchPaths) {
        String showPath = searchSource.getShowPath();
        for (String searchPath : searchPaths) {
            IResource resource = project.findMember(searchPath);
            String parentPath = resource.getProjectRelativePath().toString();
            if (!showPath.startsWith(parentPath) || showPath.length() <= parentPath.length()) continue;
            int parentPathLength = parentPath.length();
            String replacementString = showPath.substring(parentPathLength + 1);
            ArrayList<Integer> searchPositions = new ArrayList<Integer>();
            int j = 0;
            while (j < positions.size()) {
                Integer position = positions.get(j);
                position = position - parentPathLength - 1;
                searchPositions.add(position);
                ++j;
            }
            int replacementLength = end - start - 2;
            int replacementOffset = start + 1;
            int cursorPosition = replacementString.length();
            Image image = SourceSearchUtils.createImage(searchSource);
            String displayString = String.valueOf(replacementString) + SEARCH_PATHS_SEQ + parentPath;
            IContextInformation contextInformation = null;
            String additionalProposalInfo = null;
            SourceCompletionProposal sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.SEARCH_TYPE_FOLDER : SourceCompletionProposal.SEARCH_TYPE_FILE, searchPositions, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
            proposals.add(sourceCompletionProposal);
        }
        return null;
    }

    private static SourceCompletionProposal createRequireSearchPathsCompletionProposal(String key, List<ICompletionProposal> proposals, IProject project, int start, int end, ISearchSource searchSource, Set<String> searchPaths) {
        String showPath = searchSource.getShowPath();
        String showPathByIndex = searchSource.getShowPathByIndex();
        for (String searchPath : searchPaths) {
            String replacementStringByIndex;
            IResource resource = project.findMember(searchPath);
            String parentPath = resource.getProjectRelativePath().toString();
            if (showPath.equals(parentPath) || !showPath.startsWith(parentPath) || showPath.length() <= parentPath.length()) continue;
            if (showPath.endsWith(LUA_EXT)) {
                int length = showPath.length();
                showPath = showPath.substring(0, length - LUA_EXT.length());
            }
            String replacementStringByShow = showPath.substring(parentPath.length() + 1);
            int replacementLength = end - start - 2;
            int replacementOffset = start + 1;
            int cursorPosition = replacementStringByShow.length();
            Image image = SourceSearchUtils.createImage(searchSource);
            String displayString = String.valueOf(replacementStringByShow) + SEARCH_PATHS_SEQ + parentPath;
            IContextInformation contextInformation = null;
            String additionalProposalInfo = null;
            SourceCompletionProposal sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.SEARCH_TYPE_FOLDER : SourceCompletionProposal.SEARCH_TYPE_FILE, key, replacementStringByShow, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
            proposals.add(sourceCompletionProposal);
            if (showPathByIndex.endsWith(LUA_EXT)) {
                int length = showPathByIndex.length();
                showPathByIndex = showPathByIndex.substring(0, length - LUA_EXT.length());
            }
            if ((replacementStringByIndex = showPathByIndex.substring(parentPath.length() + 1)).equals(replacementStringByShow)) continue;
            replacementLength = end - start - 2;
            replacementOffset = start + 1;
            cursorPosition = replacementStringByIndex.length();
            image = SourceSearchUtils.createImage(searchSource);
            displayString = String.valueOf(replacementStringByIndex) + SEARCH_PATHS_SEQ + parentPath;
            contextInformation = null;
            additionalProposalInfo = null;
            sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.SEARCH_TYPE_FOLDER : SourceCompletionProposal.SEARCH_TYPE_FILE, key, replacementStringByIndex, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
            proposals.add(sourceCompletionProposal);
        }
        return null;
    }

    private static SourceCompletionProposal createRequireSearchPathsCompletionProposal(List<Integer> positions, List<ICompletionProposal> proposals, IProject project, int start, int end, ISearchSource searchSource, Set<String> searchPaths) {
        String showPath = searchSource.getShowPath();
        String showPathByIndex = searchSource.getShowPathByIndex();
        for (String searchPath : searchPaths) {
            String replacementStringByIndex;
            IResource resource = project.findMember(searchPath);
            String parentPath = resource.getProjectRelativePath().toString();
            if (showPath.equals(parentPath) || !showPath.startsWith(parentPath) || showPath.length() <= parentPath.length()) continue;
            int parentPathLength = parentPath.length();
            ArrayList<Integer> searchPositions = new ArrayList<Integer>();
            int j = 0;
            while (j < positions.size()) {
                Integer position = positions.get(j);
                position = position - parentPathLength - 1;
                searchPositions.add(position);
                ++j;
            }
            if (showPath.endsWith(LUA_EXT)) {
                int length = showPath.length();
                showPath = showPath.substring(0, length - LUA_EXT.length());
            }
            String replacementStringByShow = showPath.substring(parentPathLength + 1);
            int replacementLength = end - start - 2;
            int replacementOffset = start + 1;
            int cursorPosition = replacementStringByShow.length();
            Image image = SourceSearchUtils.createImage(searchSource);
            String displayString = String.valueOf(replacementStringByShow) + SEARCH_PATHS_SEQ + parentPath;
            IContextInformation contextInformation = null;
            String additionalProposalInfo = null;
            SourceCompletionProposal sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.SEARCH_TYPE_FOLDER : SourceCompletionProposal.SEARCH_TYPE_FILE, searchPositions, replacementStringByShow, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
            proposals.add(sourceCompletionProposal);
            if (showPathByIndex.endsWith(LUA_EXT)) {
                int length = showPathByIndex.length();
                showPathByIndex = showPathByIndex.substring(0, length - LUA_EXT.length());
            }
            if ((replacementStringByIndex = showPathByIndex.substring(parentPathLength + 1)).equals(replacementStringByShow)) continue;
            replacementLength = end - start - 2;
            replacementOffset = start + 1;
            cursorPosition = replacementStringByIndex.length();
            image = SourceSearchUtils.createImage(searchSource);
            displayString = String.valueOf(replacementStringByIndex) + SEARCH_PATHS_SEQ + parentPath;
            contextInformation = null;
            additionalProposalInfo = null;
            sourceCompletionProposal = new SourceCompletionProposal(searchSource.isFolder() ? SourceCompletionProposal.SEARCH_TYPE_FOLDER : SourceCompletionProposal.SEARCH_TYPE_FILE, searchPositions, replacementStringByIndex, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo);
            proposals.add(sourceCompletionProposal);
        }
        return null;
    }

    private static Image createImage(ISearchSource searchSource) {
        Image image = null;
        if (searchSource.isFolder()) {
            image = ResourceManager.IMAGE.get("icons/search/folder.gif");
        } else {
            String fileExt = searchSource.getFileExt();
            if (fileExt != null) {
                image = SourceSearchUtils.loadProgramImage(fileExt);
            }
            if (image == null) {
                image = ResourceManager.IMAGE.get("icons/search/file.gif");
            }
        }
        return image;
    }

    private static Image loadProgramImage(String extension) {
        ImageData imageData;
        Program program;
        Image iconImage = ResourceManager.IMAGE.get(extension);
        if (iconImage == null && (program = Program.findProgram((String)extension)) != null && (imageData = program.getImageData()) != null) {
            imageData = imageData.scaledTo(16, 16);
            iconImage = new Image(null, imageData, imageData.getTransparencyMask());
            ResourceManager.IMAGE.put(extension, iconImage);
        }
        return iconImage;
    }
}

