/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.search.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class LuaSearchPath {
    private static Map<IResource, List<String>> searchPaths = new HashMap<IResource, List<String>>();

    public static boolean hasResource(IResource resource) {
        return searchPaths.containsKey(resource);
    }

    public static void putPath(IResource resource, List<String> paths) {
        List<String> rightPaths = LuaSearchPath.checkExistPaths(resource, paths);
        if (rightPaths != null && rightPaths.size() > 0) {
            searchPaths.put(resource, rightPaths);
        } else {
            searchPaths.remove(resource);
        }
    }

    public static void removePath(IResource resource) {
        searchPaths.remove(resource);
    }

    public static Set<String> getSearchPathWithProject(IProject project) {
        HashSet<String> paths = new HashSet<String>();
        for (Map.Entry<IResource, List<String>> entry : searchPaths.entrySet()) {
            IResource resource = entry.getKey();
            if (project != resource.getProject()) continue;
            paths.addAll((Collection<String>)entry.getValue());
        }
        return paths;
    }

    private static List<String> checkExistPaths(IResource resource, List<String> paths) {
        ArrayList<String> rightPaths = new ArrayList<String>();
        IProject project = resource.getProject();
        int i = 0;
        while (i < paths.size()) {
            String path = paths.get(i);
            IResource findResource = project.findMember(path);
            if (findResource != null && 2 == findResource.getType()) {
                rightPaths.add(path);
            }
            ++i;
        }
        return rightPaths;
    }
}

