/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.search.source;

import org.ccdt.common.CommonConstants;
import org.ccdt.common.search.source.ISearchSource;
import org.ccdt.common.search.source.ISearchVaildator;

public class LuaProjectVaildator
implements ISearchVaildator {
    private String[] includePaths = new String[0];
    private String[] excludePaths = (String[])CommonConstants.IGNORED_FILE_OR_DIR.toArray();
    private String[] cocos2dxPaths = new String[]{"frameworks/cocos2d-x/cocos/scripting/lua-bindings/script"};

    @Override
    public boolean vailate(ISearchSource searchSource) {
        String path = searchSource.getShowPath();
        if (path == null) {
            return true;
        }
        return !this.isIncludePathsOrSubPaths(path) && this.isExcludePathsOrSubPaths(path);
    }

    private boolean isCocos2dxPathsOrSubPaths(String path) {
        int i = 0;
        while (i < this.cocos2dxPaths.length) {
            String cocos2dxPath = this.cocos2dxPaths[i];
            if (path.startsWith(cocos2dxPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isIncludePathsOrSubPaths(String path) {
        int i = 0;
        while (i < this.includePaths.length) {
            String includePath = this.includePaths[i];
            if (path.startsWith(includePath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isExcludePathsOrSubPaths(String path) {
        int i = 0;
        while (i < this.excludePaths.length) {
            String excludePath = this.excludePaths[i];
            if (path.startsWith(excludePath) || path.startsWith(".")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

