/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.search.source;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.ccdt.common.search.source.FileSearchSource;
import org.ccdt.common.search.source.ISearchSource;
import org.ccdt.common.search.source.ISearchVaildator;
import org.ccdt.common.search.source.SourceCollection;

public class FileSourceCollection
extends SourceCollection {
    @Override
    public void find(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            this.searchSources.addAll(this.createFileSearchSource(file));
        }
    }

    private List<ISearchSource> createFileSearchSource(File file) {
        ArrayList<ISearchSource> fileSearchSources = new ArrayList<ISearchSource>();
        FileSearchSource searchSource = new FileSearchSource(file);
        if (!this.validate(searchSource)) {
            fileSearchSources.add(searchSource);
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                File childFile = files[i];
                fileSearchSources.addAll(this.createFileSearchSource(childFile));
                ++i;
            }
        }
        return fileSearchSources;
    }

    private boolean validate(ISearchSource searchSource) {
        int i = 0;
        while (i < this.searchVaildators.size()) {
            ISearchVaildator searchVaildator = (ISearchVaildator)this.searchVaildators.get(i);
            boolean result = searchVaildator.vailate(searchSource);
            if (result) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

