/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.search.source;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ccdt.common.search.source.ISearchSource;
import org.ccdt.common.search.source.key.SourceKeySearch;

public class FileSearchSource
implements ISearchSource {
    private File file;
    private String showPath;
    private String showPathByIndex;
    private Map<String, List<Integer>> keyInfos = new HashMap<String, List<Integer>>();

    public FileSearchSource(File file) {
        this.file = file;
        this.init();
    }

    @Override
    public void setSource(Object object) {
        if (object instanceof File) {
            this.file = (File)object;
        }
    }

    private void init() {
        String path = this.file.getAbsolutePath();
        if (path != null) {
            this.showPath = path;
            int lastSep = this.showPath.lastIndexOf(47);
            int start = 0;
            if (lastSep > 0) {
                start = lastSep + 1;
            }
            this.showPathByIndex = this.showPath.replaceAll("\\\\", "\\.");
            String name = this.file.getName();
            SourceKeySearch sourceKeySearch = new SourceKeySearch(start, name);
            this.keyInfos.putAll(sourceKeySearch.createKeyInfos());
        }
    }

    @Override
    public boolean isFolder() {
        return this.file != null && this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.file != null && this.file.isFile();
    }

    @Override
    public boolean exists() {
        return this.file != null && this.file.exists();
    }

    @Override
    public String getFileName() {
        String targetFileName;
        int lastIndex;
        File targetfile;
        String name = null;
        if (this.file != null && this.file.isFile() && (targetfile = this.file) != null && (lastIndex = (targetFileName = targetfile.getName()).lastIndexOf(46)) > -1) {
            name = targetFileName.substring(0, lastIndex);
        }
        return name;
    }

    @Override
    public String getFileExt() {
        String targetFileName;
        int lastIndex;
        File targetfile;
        String ext = null;
        if (this.file != null && this.file.isFile() && (targetfile = this.file) != null && (lastIndex = (targetFileName = targetfile.getName()).lastIndexOf(46)) > -1) {
            ext = targetFileName.substring(lastIndex + 1);
        }
        return ext;
    }

    @Override
    public String getShowPath() {
        return this.showPath;
    }

    @Override
    public void setShowPath(String path) {
        this.showPath = path;
    }

    @Override
    public String getShowPathByIndex() {
        return this.showPathByIndex;
    }

    @Override
    public void setShowPathByIndex(String path) {
        this.showPathByIndex = path;
    }

    @Override
    public Map<String, List<Integer>> getKeyInfos() {
        return this.keyInfos;
    }
}

