/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.search;

import java.util.ArrayList;
import org.ccdt.common.search.CCDTTextSearchInput;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.swt.widgets.Display;

public enum Searcher {
    instance;

    private static final String FILTER_NAME_RUNTIME = "runtime";
    private static final String FILTER_NAME_FRAMEWORK = "frameworks";

    public boolean query(final CCDTTextSearchInput input) {
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ISearchQuery query = null;
                        try {
                            query = TextSearchQueryProvider.getPreferred().createQuery((TextSearchQueryProvider.TextSearchInput)input);
                            NewSearchUI.runQueryInBackground((ISearchQuery)query);
                        }
                        catch (CoreException coreException) {
                            return;
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return true;
    }

    public FileTextSearchScope getEnclosingProjectScope(IContainer project) {
        ArrayList<IResource> results = new ArrayList<IResource>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = project.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (!(resource instanceof IFolder) || !FILTER_NAME_FRAMEWORK.equals(resource.getName()) && !FILTER_NAME_RUNTIME.equals(resource.getName())) {
                    results.add(resource);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return FileTextSearchScope.newSearchScope((IResource[])results.toArray(new IResource[results.size()]), (String[])new String[]{"*"}, (boolean)false);
    }
}

