/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.search;

import org.ccdt.common.search.CCDTTextSearchInput;
import org.ccdt.common.search.Searcher;
import org.ccdt.common.utils.CharacterUtil;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class QuickSearchHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        AbstractTextEditor editor;
        IEditorInput input;
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (part instanceof AbstractTextEditor && (input = (editor = (AbstractTextEditor)part).getEditorInput()) instanceof FileEditorInput && (selection = editor.getSelectionProvider().getSelection()) instanceof TextSelection) {
            FileEditorInput fileInput = (FileEditorInput)input;
            IDocument document = editor.getDocumentProvider().getDocument((Object)fileInput);
            String searchContent = this.getSearchContent((TextSelection)selection, document);
            IProject project = fileInput.getFile().getProject();
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
            FileTextSearchScope scope = Searcher.instance.getEnclosingProjectScope((IContainer)project);
            if (!CharacterUtil.instance.isEmpty(searchContent)) {
                Searcher.instance.query(new CCDTTextSearchInput(searchContent, scope));
            }
        }
        return null;
    }

    private String getSearchContent(TextSelection textSelection, IDocument docment) {
        int offset = textSelection.getOffset();
        int length = textSelection.getLength();
        String result = null;
        if (length == 0) {
            StringBuilder buff = new StringBuilder();
            int currOffset = -1;
            char currChar = '\uffff';
            try {
                currOffset = offset;
                while (CharacterUtil.instance.isIndentifyChar(currChar = (char)docment.getChar(currOffset))) {
                    buff.append(currChar);
                    ++currOffset;
                }
                currOffset = offset - 1;
                while (CharacterUtil.instance.isIndentifyChar(currChar = docment.getChar(currOffset))) {
                    buff.insert(0, currChar);
                    --currOffset;
                }
                result = buff.toString();
            }
            catch (BadLocationException badLocationException) {
                result = buff.toString();
            }
        } else {
            try {
                result = docment.get(offset, length);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return result;
    }
}

