/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.resource;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.zip.Deflater;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.ccconsole.CCConsole;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.resource.Protos;
import org.ccdt.common.resource.ResourceChangeListener;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.ccdt.common.utils.ResourceUtil;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class UploadManager {
    private static String OLD_RUNTIME_VERSION = "1.1";
    private static String UPDATE_TAG = "update:";
    private static String DELETE_TAG = "delete:";
    private static int UPLOAD_FILE_SEQ = 1;
    private static int UPLOAD_FILE_COMPLETE_SEQ = 2;
    private static String PROTO_START = "RuntimeSend:";
    private static int PER_BUFFER_SIZE = 0x100000;
    private static int SEND_BUFFER_NUM = 10;
    private CCConsole console;
    private String projName;
    private String projDir;
    private String host;
    private int port;
    private boolean needUpload = true;
    private boolean isInitializing = false;
    private String runtimeVersion = null;
    private Thread checkWaitingThread = null;
    private Thread checkBufferThread = null;
    private Thread checkResponseThread = null;
    private volatile boolean isDisconnected = true;
    private IResourceChangeListener resourceChangeListener = null;
    BlockingQueue<String> waitingSendQueue = new LinkedBlockingQueue<String>();
    BlockingQueue<byte[]> sendingBuffers = new ArrayBlockingQueue<byte[]>(SEND_BUFFER_NUM);
    ArrayList<String> sendingFileList = new ArrayList();
    ArrayList<String> updatedFileList = new ArrayList();
    private static UploadManager sManager = null;
    private SyncerCallback callback;
    private static final String FILE_NAME = "filename";
    private static final String LAST_MODIFY_TIME = "lastmodifytime";

    public static void destruct() {
        if (sManager != null) {
            sManager.dispose();
            sManager = null;
        }
    }

    public static UploadManager getInstance(String projName, CCConsole console, String host, int port, boolean needUpload) throws Exception {
        UploadManager.destruct();
        sManager = new UploadManager(projName, console, host, port, needUpload);
        return sManager;
    }

    public void initResourceToRuntime() throws Exception {
        CocosLogger.getLogger((String)"UploadManager").info((Object)"initResourceToRuntime start");
        this.isInitializing = true;
        Map fileinfo = CCConsole.getCCConsole().getFileInfo();
        Map<String, Collection<String>> result = ResourceUtil.getUploadAndDeleteFiles(this.projName, fileinfo);
        if (result.get("deleted").size() > 0) {
            this.removeFileByRelativePath(result.get("deleted"));
        }
        Collection<String> relativePaths = result.get("uploaded");
        Iterator<String> iter = relativePaths.iterator();
        while (iter.hasNext()) {
            this.addUpdateToQueueByRelativePath(iter.next());
        }
        while (!this.waitingSendQueue.isEmpty() || !this.sendingFileList.isEmpty()) {
            Thread.sleep(100L);
        }
        this.isInitializing = false;
        CocosLogger.getLogger((String)"UploadManager").info((Object)"initResourceToRuntime finish");
    }

    public void removeFileByRelativePath(Collection<String> collection) throws CoreException {
        try {
            System.out.println("delete:" + collection.toString());
            this.console.removeFiles(new ArrayList<String>(collection));
        }
        catch (Exception e) {
            Status status = new Status(4, "org.ccdt.common", "Error in remove file on runtime.", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        this.updatedFileList.addAll(collection);
    }

    public void setReloadCallback(SyncerCallback callback) {
        this.callback = callback;
    }

    private UploadManager(String projName, CCConsole console, String host, int port, boolean needUpload) throws Exception {
        this.projName = projName;
        this.projDir = ResourcesPlugin.getWorkspace().getRoot().getProject(projName).getLocation().toString();
        this.console = console;
        this.host = host;
        this.port = port;
        this.needUpload = needUpload;
        CheckWaitingRunnable checkWaitingQueue = new CheckWaitingRunnable();
        this.checkWaitingThread = new Thread((Runnable)checkWaitingQueue, "CheckWaitingQueue");
        this.checkWaitingThread.setDaemon(true);
        this.checkWaitingThread.start();
        if (needUpload) {
            this.runtimeVersion = console.getRuntimeVersion();
            if (this.runtimeVersion != null & !this.runtimeVersion.equals(OLD_RUNTIME_VERSION)) {
                Socket socket = new Socket(host, port);
                CheckBufferRunnable checkBufferRunnable = new CheckBufferRunnable(socket);
                this.checkBufferThread = new Thread((Runnable)checkBufferRunnable, "CheckBuffer");
                this.checkBufferThread.setDaemon(true);
                this.checkBufferThread.start();
                CheckResponseRunnable checkResponseRunnable = new CheckResponseRunnable(socket);
                this.checkResponseThread = new Thread((Runnable)checkResponseRunnable, "CheckResponse");
                this.checkResponseThread.setDaemon(true);
                this.checkResponseThread.start();
            }
        }
        this.resourceChangeListener = new ResourceChangeListener(this, console, this.projDir);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    private void dispose() {
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
        this.resourceChangeListener = null;
        this.waitingSendQueue.clear();
        this.sendingBuffers.clear();
        this.sendingFileList.clear();
        this.updatedFileList.clear();
        if (this.checkWaitingThread != null) {
            this.checkWaitingThread.interrupt();
            this.checkWaitingThread = null;
        }
        if (this.checkBufferThread != null) {
            this.checkBufferThread.interrupt();
            this.checkBufferThread = null;
        }
        if (this.checkResponseThread != null) {
            this.checkResponseThread.interrupt();
            this.checkResponseThread = null;
        }
    }

    /*
     * Loose catch block
     */
    private void doUpload(String fullpath, String relativepath) throws CoreException {
        block69: {
            Socket socket = null;
            OutputStream os = null;
            BufferedReader br = null;
            FileInputStream is = null;
            try {
                int size;
                File file = new File(fullpath);
                socket = new Socket(this.host, this.port);
                socket.setSoTimeout(1000);
                os = socket.getOutputStream();
                br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String lastModified = String.valueOf(file.lastModified());
                Gson header = new Gson();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(FILE_NAME, relativepath);
                map.put(LAST_MODIFY_TIME, lastModified);
                byte[] header_bytes = header.toJson(map).getBytes();
                os.write(String.format("%04d", header.toJson(map).length()).getBytes());
                os.write(header_bytes);
                os.flush();
                is = new FileInputStream(file);
                byte[] buffer = new byte[PER_BUFFER_SIZE];
                while ((size = is.read(buffer)) != -1) {
                    os.write(buffer, 0, size);
                }
                os.flush();
                socket.shutdownOutput();
                br.readLine();
                System.out.println("finish upload:" + fullpath);
                System.out.println("filename=" + relativepath + " modifytime=" + lastModified);
                os.close();
                br.close();
                is.close();
                socket.close();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (socket != null) {
                        socket.close();
                    }
                    break block69;
                }
                catch (IOException iOException) {}
                break block69;
            }
            catch (UnknownHostException e) {
                CommonPlugin.logError("upload file error, unknown host", e);
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (socket != null) {
                        socket.close();
                    }
                    break block69;
                }
                catch (IOException iOException) {}
                break block69;
            }
            catch (IOException e) {
                CommonPlugin.logError("upload file error, io exception", e);
                {
                    catch (Throwable throwable) {
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (br != null) {
                                br.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (socket != null) {
                        socket.close();
                    }
                    break block69;
                }
                catch (IOException iOException) {}
                break block69;
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void sendDataToBuffer(String fullpath, String relativepath) throws Exception {
        FileInputStream fis = null;
        try {
            File file = new File(fullpath);
            if (!file.exists()) {
                return;
            }
            this.sendingFileList.add(relativepath);
            fis = new FileInputStream(file);
            if (fis.available() > 0) {
                byte[] rawBuf;
                int package_sum = (int)Math.ceil((double)fis.available() / (double)PER_BUFFER_SIZE);
                int package_seq = 1;
                int size = 0;
                while ((size = fis.read(rawBuf = new byte[PER_BUFFER_SIZE])) != -1) {
                    if (size < PER_BUFFER_SIZE) {
                        rawBuf = UploadManager.cutOutByte(rawBuf, size);
                    }
                    byte[] compressedBuf = UploadManager.compress(rawBuf);
                    Protos.FileSendProtos.Builder builder = Protos.FileSendProtos.newBuilder();
                    builder.setFileName(relativepath);
                    builder.setPackageSum(package_sum);
                    builder.setPackageSeq(package_seq);
                    builder.setContentSize(compressedBuf.length);
                    builder.setCompressType(Protos.FileSendProtos.CompressType.ZIP);
                    builder.setUncompressSize(size);
                    if (package_seq == 1) {
                        builder.setModifiedTime(file.lastModified());
                    }
                    byte[] headerBuf = UploadManager.getHeaderBuffer(builder);
                    this.sendingBuffers.put(headerBuf);
                    this.sendingBuffers.put(compressedBuf);
                    ++package_seq;
                }
            } else {
                byte[] rawBuf = " ".getBytes();
                byte[] compressedBuf = UploadManager.compress(rawBuf);
                Protos.FileSendProtos.Builder builder = Protos.FileSendProtos.newBuilder();
                builder.setFileName(relativepath);
                builder.setPackageSum(1);
                builder.setPackageSeq(1);
                builder.setContentSize(compressedBuf.length);
                builder.setCompressType(Protos.FileSendProtos.CompressType.ZIP);
                builder.setUncompressSize(rawBuf.length);
                builder.setModifiedTime(file.lastModified());
                byte[] headerBuf = UploadManager.getHeaderBuffer(builder);
                this.sendingBuffers.put(headerBuf);
                this.sendingBuffers.put(compressedBuf);
            }
        }
        catch (IOException e) {
            CommonPlugin.logError("upload file error, io exception", e);
        }
    }

    private static byte[] getHeaderBuffer(Protos.FileSendProtos.Builder builder) throws IOException {
        byte[] protoStart = PROTO_START.getBytes();
        byte[] protoSeq = UploadManager.numberToBytes(UPLOAD_FILE_SEQ);
        Protos.FileSendProtos fileSendProto = builder.build();
        byte[] protobuf = fileSendProto.toByteArray();
        byte[] protobufLength = UploadManager.numberToBytes(protobuf.length);
        int fileSendHeaderLength = protoStart.length + protoSeq.length + protobufLength.length + protobuf.length;
        byte[] headerBuffer = new byte[fileSendHeaderLength];
        int offset = 0;
        System.arraycopy(protoStart, 0, headerBuffer, offset, protoStart.length);
        System.arraycopy(protoSeq, 0, headerBuffer, offset += protoStart.length, protoSeq.length);
        System.arraycopy(protobufLength, 0, headerBuffer, offset += protoSeq.length, protobufLength.length);
        System.arraycopy(protobuf, 0, headerBuffer, offset += protobufLength.length, protobuf.length);
        offset += protobuf.length;
        return headerBuffer;
    }

    private static byte[] getBytes(InputStream stream, int length) throws IOException {
        int n = 0;
        int off = 0;
        byte[] bytes = new byte[length];
        while (n < length) {
            int count = stream.read(bytes, off + n, length - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        return bytes;
    }

    private static byte[] numberToBytes(int n) {
        byte[] array = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return array;
    }

    private static int bytesToNumber(byte[] array) {
        int n = 0;
        n += array[1] << 8 & 0xFF;
        return n += array[0] & 0xFF;
    }

    private static byte[] cutOutByte(byte[] b, int j) {
        if (b.length == 0 || j == 0) {
            return null;
        }
        byte[] bjq = new byte[j];
        int i = 0;
        while (i < j) {
            bjq[i] = b[i];
            ++i;
        }
        return bjq;
    }

    private static byte[] compress(byte[] data) {
        Deflater compresser;
        byte[] output;
        block12: {
            output = new byte[]{};
            compresser = new Deflater();
            compresser.reset();
            compresser.setInput(data);
            compresser.finish();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
            try {
                try {
                    byte[] buf = new byte[1024];
                    while (!compresser.finished()) {
                        int i = compresser.deflate(buf);
                        bos.write(buf, 0, i);
                    }
                    output = bos.toByteArray();
                }
                catch (Exception e) {
                    output = data;
                    e.printStackTrace();
                    try {
                        bos.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        compresser.end();
        return output;
    }

    private void reloadRuntime() {
        if (!this.waitingSendQueue.isEmpty()) {
            return;
        }
        if (!this.sendingFileList.isEmpty()) {
            return;
        }
        if (this.updatedFileList.isEmpty()) {
            return;
        }
        if (!this.isInitializing) {
            this.callback.reload(this.updatedFileList);
        }
        this.updatedFileList.clear();
    }

    private int getIndex(List<String> list, String value) {
        int i = 0;
        while (i < list.size()) {
            if (value.equals(list.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void uploadFileByRelativePath(String relativepath) throws Exception {
        String fullpath = String.valueOf(this.projDir) + File.separator + relativepath;
        fullpath = fullpath.replaceAll("[\\\\]", "/");
        System.out.println("start upload:" + relativepath);
        if (this.runtimeVersion.equals(OLD_RUNTIME_VERSION)) {
            this.doUpload(fullpath, relativepath);
            this.updatedFileList.add(relativepath);
        } else {
            this.sendDataToBuffer(fullpath, relativepath);
        }
    }

    public void addDeleteToQueueByRelativePath(String relativepath) {
        String command = String.valueOf(DELETE_TAG) + relativepath;
        try {
            if (!this.waitingSendQueue.contains(command)) {
                this.waitingSendQueue.put(command);
            }
        }
        catch (InterruptedException e) {
            CommonPlugin.logError("addDeleteToQueue error, be interrupted", e);
        }
    }

    public void addUpdateToQueueByRelativePath(String relativepath) {
        String command = String.valueOf(UPDATE_TAG) + relativepath;
        try {
            if (!this.waitingSendQueue.contains(command)) {
                this.waitingSendQueue.put(command);
            }
        }
        catch (InterruptedException e) {
            CommonPlugin.logError("addUploadToQueue error, be interrupted", e);
        }
    }

    class CheckBufferRunnable
    implements Runnable {
        private OutputStream os = null;

        public CheckBufferRunnable(Socket socket) {
            try {
                this.os = socket.getOutputStream();
            }
            catch (IOException e) {
                CommonPlugin.logError("upload file buffer error, io exception", e);
            }
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted() && UploadManager.this.isDisconnected) {
                try {
                    byte[] buffer = UploadManager.this.sendingBuffers.take();
                    this.os.write(buffer);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                catch (IOException iOException) {
                    UploadManager.destruct();
                }
            }
            try {
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    class CheckResponseRunnable
    implements Runnable {
        private InputStream inputStream = null;
        Socket socket = null;

        public CheckResponseRunnable(Socket socket) {
            try {
                this.socket = socket;
                this.inputStream = socket.getInputStream();
            }
            catch (IOException e) {
                CommonPlugin.logError("upload file response error, io exception", e);
            }
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted() && UploadManager.this.isDisconnected) {
                try {
                    Protos.FileSendComplete.RESULTTYPE result;
                    String str;
                    int seq = 0;
                    int protoLength = 0;
                    StringBuffer buffer = new StringBuffer();
                    int c = -1;
                    boolean r = false;
                    while (!r && (c = this.inputStream.read()) > -1) {
                        buffer.append((char)c);
                        boolean bl = r = c == 58;
                    }
                    if (c == -1) {
                        UploadManager.this.isDisconnected = false;
                    }
                    if (!r || !(str = buffer.toString()).endsWith(PROTO_START)) continue;
                    byte[] seqBytes = UploadManager.getBytes(this.inputStream, 2);
                    seq = UploadManager.bytesToNumber(seqBytes);
                    byte[] lengthBytes = UploadManager.getBytes(this.inputStream, 2);
                    protoLength = UploadManager.bytesToNumber(lengthBytes);
                    byte[] bufferBytes = UploadManager.getBytes(this.inputStream, protoLength);
                    if (seq != UPLOAD_FILE_COMPLETE_SEQ) continue;
                    Protos.FileSendComplete fileSendComplete = Protos.FileSendComplete.parseFrom(bufferBytes);
                    String fileName = fileSendComplete.getFileName();
                    int index = UploadManager.this.getIndex(UploadManager.this.sendingFileList, fileName);
                    if (index != -1) {
                        UploadManager.this.sendingFileList.remove(index);
                    }
                    if ((result = fileSendComplete.getResult()) == Protos.FileSendComplete.RESULTTYPE.SUCCESS) {
                        UploadManager.this.updatedFileList.add(fileName);
                    } else if (result == Protos.FileSendComplete.RESULTTYPE.UNCOMPRESS_ERROR) {
                        UploadManager.this.addUpdateToQueueByRelativePath(fileName);
                    } else {
                        int errno = fileSendComplete.getErrorNum();
                        CocosLogger.LOG.error((Object)String.format("%s upload failed for error number is %d", fileName, errno));
                        if (errno == 28) {
                            Dialogs.showMessageDialog(String.format("device has not enough space to upload %s", fileName));
                            throw new IOException("device has not enough space");
                        }
                        UploadManager.this.addUpdateToQueueByRelativePath(fileName);
                    }
                    UploadManager.this.reloadRuntime();
                }
                catch (IOException iOException) {
                    UploadManager.destruct();
                }
            }
            if (!UploadManager.this.isDisconnected) {
                UploadManager.this.dispose();
            }
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    class CheckWaitingRunnable
    implements Runnable {
        CheckWaitingRunnable() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted() && UploadManager.this.isDisconnected) {
                try {
                    String member = UploadManager.this.waitingSendQueue.take();
                    if (member.endsWith("Thumbs.db") || member.endsWith(".DS_Store")) continue;
                    String cmd = null;
                    if (member.startsWith(UPDATE_TAG)) {
                        cmd = UPDATE_TAG;
                    } else if (member.startsWith(DELETE_TAG)) {
                        cmd = DELETE_TAG;
                    }
                    String relativepath = member.replaceFirst(cmd, "");
                    try {
                        if (UploadManager.this.needUpload) {
                            if (cmd.equals(UPDATE_TAG)) {
                                UploadManager.this.uploadFileByRelativePath(relativepath);
                                continue;
                            }
                            UploadManager.this.removeFileByRelativePath(Arrays.asList(relativepath));
                            continue;
                        }
                        UploadManager.this.updatedFileList.add(relativepath);
                        UploadManager.this.reloadRuntime();
                    }
                    catch (Exception e) {
                        CommonPlugin.logError("error in check waiting thread", e);
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public static interface SyncerCallback {
        public void reload(List<String> var1);
    }
}

