/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.resource;

import java.io.File;
import org.ccdt.common.ccconsole.CCConsole;
import org.ccdt.common.resource.UploadManager;
import org.ccdt.common.utils.ConsoleFactory;
import org.ccdt.common.utils.ResourceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class ResourceChangeListener
implements IResourceChangeListener {
    private UploadManager uploadManager = null;
    private CCConsole console = null;
    private String projDir;

    public ResourceChangeListener(UploadManager uploadManager, CCConsole console, String projDir) {
        this.uploadManager = uploadManager;
        this.console = console;
        this.projDir = projDir;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.console == null || this.console.isDisconnected()) {
            return;
        }
        if (1 == event.getType()) {
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getParent() instanceof IProject && (ResourceUtil.isIgnoredFileOrFolder(resource.getName()) || ResourceUtil.isCustomIgnoredFileOrFolder((IProject)resource.getParent(), resource.getName()))) {
                            return false;
                        }
                        if (!(resource instanceof IFile)) {
                            return true;
                        }
                        IFile file = (IFile)resource;
                        if (file.getProject() == null || !file.getLocation().toString().startsWith(ResourceChangeListener.this.projDir)) {
                            return false;
                        }
                        String fullpath = resource.getLocation().toString();
                        String relativePath = fullpath.substring((String.valueOf(ResourceChangeListener.this.projDir) + File.separator).length());
                        if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0 || delta.getKind() == 1) {
                            if (relativePath.equals("project.json") || relativePath.equals("config.json")) {
                                ConsoleFactory.showLine(String.format("%s have been modified, please run/debug again to make effect", relativePath), true);
                            }
                            ResourceChangeListener.this.uploadManager.addUpdateToQueueByRelativePath(relativePath);
                            return false;
                        }
                        if (delta.getKind() == 2) {
                            if (relativePath.endsWith(".js") || relativePath.endsWith(".lua")) {
                                ConsoleFactory.showLine(String.format("%s have been deleted, please run/debug again to make effect", relativePath), true);
                            }
                            ResourceChangeListener.this.uploadManager.addDeleteToQueueByRelativePath(relativePath);
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

