/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.ccdt.common.model.ProposalCount;

public class ProposalCounter {
    private List<ProposalCount> counter = Collections.synchronizedList(new ArrayList());

    public List<ProposalCount> getSortCounter() {
        Collections.sort(this.counter, new Comparator<ProposalCount>(){

            @Override
            public int compare(ProposalCount o1, ProposalCount o2) {
                return o2.getCount() - o1.getCount();
            }
        });
        return this.counter;
    }

    public ProposalCount getProposalCount(String proposal) {
        if (proposal == null) {
            return null;
        }
        for (ProposalCount curr : this.counter) {
            if (!proposal.equals(curr.getContent())) continue;
            return curr;
        }
        return null;
    }

    public void addProposal(String proposal) {
        List<ProposalCount> counter = this.getSortCounter();
        Iterator<ProposalCount> iter = counter.iterator();
        int MAXCOUNT = 20;
        int index = 0;
        ProposalCount curr = null;
        while (iter.hasNext()) {
            curr = iter.next();
            curr.setCount(MAXCOUNT - ++index);
            if (curr.getCount() > 0) continue;
            iter.remove();
        }
        ProposalCount find = this.getProposalCount(proposal);
        if (find == null) {
            find = new ProposalCount(proposal);
            counter.add(find);
        }
        find.setCount(MAXCOUNT);
    }
}

