/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.manager;

import java.util.ArrayList;
import java.util.List;
import org.ccdt.common.manager.CocosLaunchManager;
import org.ccdt.common.manager.DecoupleManager;
import org.ccdt.common.manager.ProjectManager;
import org.ccdt.common.ui.dialogs.Dialogs;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class RuntimeBuilderManager {
    public static final int ACTION_ADD_NATIVE = 1;
    public static final int ACTION_BUILD_RUNTIME = 2;
    public static final int ACTION_PACKAGE_ANDROID = 3;
    public static final int ACTION_PACKAGE_IOS = 4;
    private static int lastAction = 2;
    private static List<IRuntimeBuilder> builders = new ArrayList<IRuntimeBuilder>();

    public static void runActionCurrentProject(int action) {
        ILaunchConfiguration config;
        String projectName;
        IProject project = ProjectManager.getCurrentProject();
        if (project == null && (projectName = CocosLaunchManager.getProjectNameByLaunchConfig(config = CocosLaunchManager.getLastLaunch("debug"))) != null) {
            project = ProjectManager.getProjectByName(projectName);
        }
        RuntimeBuilderManager.runAction(project, action);
    }

    public static void runAction(IProject project, int action) {
        if (project == null) {
            Dialogs.showMessageDialog("Please select a project then continue.", 4);
            return;
        }
        RuntimeBuilderManager.initBuilders();
        for (IRuntimeBuilder builder : builders) {
            if (!builder.canHandle(project)) continue;
            switch (action) {
                case 1: {
                    builder.addNativeSource(project);
                    break;
                }
                case 2: {
                    builder.buildRuntime(project);
                    break;
                }
                case 3: {
                    builder.packageAndroid(project);
                    break;
                }
                case 4: {
                    builder.packageIOS(project);
                    break;
                }
            }
        }
        RuntimeBuilderManager.updateLastAction(action);
    }

    public static int getLastAction() {
        return lastAction;
    }

    static void initBuilders() {
        if (!builders.isEmpty()) {
            return;
        }
        builders.add(DecoupleManager.getInstance("lua").getRuntimeBuilder());
        builders.add(DecoupleManager.getInstance("js").getRuntimeBuilder());
    }

    static void updateLastAction(int action) {
        if (action == 1) {
            return;
        }
        lastAction = action;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
        if (commandService != null) {
            commandService.refreshElements("org.ccdt.common.ui.command.runtime", null);
        }
    }

    public static interface IRuntimeBuilder {
        public boolean canHandle(IProject var1);

        public void addNativeSource(IProject var1);

        public void buildRuntime(IProject var1);

        public void packageAndroid(IProject var1);

        public void packageIOS(IProject var1);
    }
}

