/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.manager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.ccdt.common.CommonConsole;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.logger.CocosLogger;
import org.ccdt.common.manager.ConfigurationManager;
import org.ccdt.common.manager.DecoupleManager;
import org.ccdt.common.manager.PathManager;
import org.ccdt.common.model.CocosProjectConfig;
import org.ccdt.common.model.ProjectSettings;
import org.ccdt.common.model.RuntimeConfig;
import org.ccdt.common.utils.CommandHelper;
import org.ccdt.common.utils.SystemInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ProjectManager {
    private static final String JS_TEMPLATE_PATH = "templates" + File.separator + "js-template-runtime";
    private static final String LUA_TEMPLATE_PATH = "templates" + File.separator + "lua-template-runtime";

    public static IProject getProjectByName(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.exists() || !project.isOpen()) {
            return null;
        }
        return project;
    }

    public static IProject getCurrentProject() {
        Object object;
        IProject project = null;
        IWorkbenchWindow wbwindow = CommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = wbwindow.getActivePage();
        IEditorPart part = activePage.getActiveEditor();
        ISelectionService service = wbwindow.getSelectionService();
        ISelection selection = service.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IResource) {
                project = ((IResource)element).getProject();
            }
            if (project == null) {
                project = DecoupleManager.getInstance("lua").convertToIProject(element);
            }
            if (project == null) {
                project = DecoupleManager.getInstance("js").convertToIProject(element);
            }
        }
        if (project == null && part != null && (object = part.getEditorInput().getAdapter(IFile.class)) != null) {
            project = ((IFile)object).getProject();
        }
        return project;
    }

    public static ILaunchConfiguration[] getCompleteLaunchHistory(IProject curProj, LaunchConfigAttributesCallBack callback, String groupid) {
        LaunchConfigurationManager manager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        LaunchHistory launchHistory = manager.getLaunchHistory(groupid);
        ILaunchConfiguration[] results = null;
        if (launchHistory != null) {
            results = launchHistory.getCompleteLaunchHistory();
        }
        List<ILaunchConfiguration> list = Arrays.asList(results);
        list = new ArrayList(list);
        ILaunchConfiguration[] iLaunchConfigurationArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
            try {
                ILaunchConfigurationWorkingCopy workingCopy = launchConfig.getWorkingCopy();
                String projName = null;
                projName = callback.getAttribute(workingCopy);
                if (!curProj.getName().equals(projName)) {
                    list.remove(launchConfig);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return list.toArray(new ILaunchConfiguration[0]);
    }

    public static boolean isCocosProject(File projRoot) {
        boolean result = false;
        File dotProjFile = new File(String.valueOf(projRoot.getAbsolutePath()) + File.separator + ".project");
        if (!dotProjFile.exists() || dotProjFile.isDirectory()) {
            return false;
        }
        Path path = new Path(dotProjFile.getPath());
        try {
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
            result = description.hasNature("org.ccdt.cocosproject");
        }
        catch (CoreException e) {
            CocosLogger.LOG.error((Object)"error in load project description", (Throwable)e);
        }
        return result;
    }

    public static boolean isCocosLuaProject(File projRoot) {
        boolean result = false;
        File dotProjFile = new File(String.valueOf(projRoot.getAbsolutePath()) + File.separator + ".project");
        if (!dotProjFile.exists() || dotProjFile.isDirectory()) {
            return false;
        }
        Path path = new Path(dotProjFile.getPath());
        try {
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
            result = description.hasNature("org.eclipse.koneki.ldt.nature");
        }
        catch (CoreException e) {
            CocosLogger.LOG.error((Object)"error in load project description", (Throwable)e);
        }
        return result;
    }

    public static boolean isCocosJSProject(File projRoot) {
        boolean result = false;
        File dotProjFile = new File(String.valueOf(projRoot.getAbsolutePath()) + File.separator + ".project");
        if (!dotProjFile.exists() || dotProjFile.isDirectory()) {
            return false;
        }
        Path path = new Path(dotProjFile.getPath());
        try {
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
            result = description.hasNature("org.ccdt.jsdt.core.jsNature");
        }
        catch (CoreException e) {
            CocosLogger.LOG.error((Object)"error in load project description", (Throwable)e);
        }
        return result;
    }

    public static String getProjectTemplateVersion(File projRoot) {
        ProjectSettings result = ConfigurationManager.getConfiguration(PathManager.instance.getProjectVersionConfigPath(projRoot)).getConfig(ProjectSettings.class);
        if (result == null) {
            return null;
        }
        String version = result.getTemplateVersion();
        if (version != null && !"".equals(version)) {
            return version;
        }
        return null;
    }

    public static String getProjectName(File projRoot) throws CoreException {
        File dotProjFile = new File(String.valueOf(projRoot.getAbsolutePath()) + File.separator + ".project");
        if (dotProjFile.exists()) {
            Path path = new Path(dotProjFile.getPath());
            IProjectDescription description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)path);
            return description.getName();
        }
        return null;
    }

    private static void updateProjectVersions(File projRoot) {
        ProjectSettings result = ConfigurationManager.getConfiguration(PathManager.instance.getProjectVersionConfigPath(projRoot)).getConfig(ProjectSettings.class);
        if (result == null) {
            return;
        }
        String templateVersion = null;
        String engineVersion = null;
        if (ProjectManager.isCocosJSProject(projRoot)) {
            templateVersion = ProjectManager.getJSEngineTemplateVersion();
            engineVersion = SystemInfo.getJSEngineVersion();
        } else if (ProjectManager.isCocosLuaProject(projRoot)) {
            templateVersion = ProjectManager.getLuaEngineTemplateVersion();
            engineVersion = SystemInfo.getLuaEngineVersion();
        }
        result.setTemplateVersion(templateVersion);
        result.setEngineVersion(engineVersion);
        result.setIdeVersion("v1.0.0.RC0");
        ConfigurationManager.getConfiguration(PathManager.instance.getProjectVersionConfigPath(projRoot)).save(result);
    }

    public static void updateEntryFile(File projRoot, String entryFile) {
        String configJsonPath = String.valueOf(projRoot.getAbsolutePath()) + File.separator + "config.json";
        if (!new File(configJsonPath).exists()) {
            return;
        }
        RuntimeConfig runtimeConfig = ConfigurationManager.getConfiguration(configJsonPath).getConfig(RuntimeConfig.class);
        runtimeConfig.getInit_cfg().setEntry(entryFile);
        if (runtimeConfig.getInit_cfg().getConsolePort() == 0) {
            if (ProjectManager.isCocosLuaProject(projRoot)) {
                runtimeConfig.getInit_cfg().setConsolePort(6010);
            } else {
                runtimeConfig.getInit_cfg().setConsolePort(6050);
            }
        }
        if (runtimeConfig.getInit_cfg().getDebugPort() == 0 && ProjectManager.isCocosJSProject(projRoot)) {
            runtimeConfig.getInit_cfg().setDebugPort(5086);
        }
        ConfigurationManager.getConfiguration(configJsonPath).save(runtimeConfig);
    }

    private static void updateHasNativeToFalse(File projRoot) {
        CocosProjectConfig config = ConfigurationManager.getConfiguration(PathManager.instance.getCocosProjectConfigPath(projRoot)).getConfig(CocosProjectConfig.class);
        config.setHasNative(false);
        ConfigurationManager.getConfiguration(PathManager.instance.getCocosProjectConfigPath(projRoot)).save(config);
    }

    public static String getLuaEngineTemplateVersion() {
        ProjectSettings result = ConfigurationManager.getConfiguration(PathManager.instance.getLuaTemplateVersionPath()).getConfig(ProjectSettings.class);
        if (result == null) {
            return null;
        }
        String version = result.getTemplateVersion();
        if (version != null && !"".equals(version)) {
            return version;
        }
        return null;
    }

    public static String getJSEngineTemplateVersion() {
        ProjectSettings result = ConfigurationManager.getConfiguration(PathManager.instance.getJSTemplateVersionPath()).getConfig(ProjectSettings.class);
        if (result == null) {
            return null;
        }
        String version = result.getTemplateVersion();
        if (version != null && !"".equals(version)) {
            return version;
        }
        return null;
    }

    public static boolean canUpgrade(File projRoot) {
        String projTempVer = ProjectManager.getProjectTemplateVersion(projRoot);
        String engineTempVer = null;
        if (ProjectManager.isCocosJSProject(projRoot)) {
            engineTempVer = ProjectManager.getJSEngineTemplateVersion();
        } else if (ProjectManager.isCocosLuaProject(projRoot)) {
            engineTempVer = ProjectManager.getLuaEngineTemplateVersion();
        }
        if (engineTempVer == null) {
            return false;
        }
        if (projTempVer == null) {
            return true;
        }
        String[] projvers = projTempVer.split("\\.");
        String[] enginevers = engineTempVer.split("\\.");
        int i = 0;
        while (i < enginevers.length && i < projvers.length) {
            int v1 = -1;
            int v2 = -1;
            try {
                v1 = Integer.parseInt(projvers[i]);
            }
            catch (NumberFormatException numberFormatException) {
                v1 = -1;
            }
            try {
                v2 = Integer.parseInt(enginevers[i]);
            }
            catch (NumberFormatException numberFormatException) {
                v2 = -1;
            }
            if (v1 < v2) {
                return true;
            }
            if (v1 > v2) {
                return false;
            }
            ++i;
        }
        if (projvers.length > enginevers.length) {
            return false;
        }
        return projvers.length < enginevers.length;
    }

    public static boolean upgradeCocosProject(File projRoot) throws IOException, CoreException {
        File projRuntimePath = new File(String.valueOf(projRoot.getAbsolutePath()) + File.separator + "runtime");
        File projFrameworksPath = new File(String.valueOf(projRoot.getAbsolutePath()) + File.separator + "frameworks");
        File projUpgradeBakPath = new File(String.valueOf(projRoot.getAbsolutePath()) + File.separator + "upgrade_bak");
        String engineTemplatePath = null;
        String language = null;
        String enginePath = null;
        if (ProjectManager.isCocosJSProject(projRoot)) {
            enginePath = PathManager.instance.getJSEnginePath();
            engineTemplatePath = String.valueOf(enginePath) + File.separator + JS_TEMPLATE_PATH;
            language = "js";
        } else if (ProjectManager.isCocosLuaProject(projRoot)) {
            enginePath = PathManager.instance.getLUAEnginePath();
            engineTemplatePath = String.valueOf(enginePath) + File.separator + LUA_TEMPLATE_PATH;
            language = "lua";
        }
        if (enginePath != null && engineTemplatePath != null) {
            block16: {
                String projName = null;
                projName = ProjectManager.getProjectName(projRoot);
                if (projName == null) {
                    Status status = new Status(4, "org.ccdt.common", "can not get project name.");
                    throw new CoreException((IStatus)status);
                }
                String tempProjPath = String.valueOf(projUpgradeBakPath.getAbsolutePath()) + File.separator + "temp";
                FileUtils.deleteDirectory((File)new File(tempProjPath));
                boolean result = CommonConsole.getInstance().create(projName, "org.cocos2dx.Game", tempProjPath, language, false);
                if (result) {
                    try {
                        ProjectManager.copyDirectoryToDirectory(projRuntimePath, projUpgradeBakPath);
                        ProjectManager.copyDirectoryToDirectory(projFrameworksPath, projUpgradeBakPath);
                        FileUtils.deleteDirectory((File)projRuntimePath);
                        FileUtils.deleteDirectory((File)projFrameworksPath);
                    }
                    catch (IOException e) {
                        throw new IOException("backup cocos project error", e);
                    }
                    File templateRuntimePath = new File(String.valueOf(tempProjPath) + File.separator + projName + File.separator + "runtime");
                    File templateFrameworksPath = new File(String.valueOf(tempProjPath) + File.separator + projName + File.separator + "frameworks");
                    File templateProjectSettingPath = new File(String.valueOf(tempProjPath) + File.separator + projName + File.separator + ".settings");
                    try {
                        try {
                            ProjectManager.copyDirectoryToDirectory(templateRuntimePath, projRoot);
                            ProjectManager.copyDirectoryToDirectory(templateFrameworksPath, projRoot);
                            ProjectManager.copyDirectoryToDirectory(templateProjectSettingPath, projRoot);
                            File confJson = new File(projRoot + File.separator + File.separator + "config.json");
                            File tempConfJson = new File(String.valueOf(tempProjPath) + File.separator + projName + File.separator + "config.json");
                            if (!confJson.exists()) {
                                FileUtils.copyFileToDirectory((File)tempConfJson, (File)projRoot);
                            }
                            ProjectManager.updateHasNativeToFalse(projRoot);
                            ProjectManager.updateProjectVersions(projRoot);
                            break block16;
                        }
                        catch (IOException e) {
                            throw new IOException("upgrade cocos project error", e);
                        }
                    }
                    finally {
                        FileUtils.deleteDirectory((File)new File(tempProjPath));
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean copyDirectoryToDirectory(File srcDir, File destDir) throws IOException {
        String cmd = null;
        if (SystemInfo.isMac) {
            cmd = String.format("cp -R %s %s", srcDir.getAbsolutePath(), String.valueOf(destDir.getAbsolutePath()) + File.separator);
            final ArrayList result = new ArrayList();
            CommandHelper.ProcessListener listener = new CommandHelper.ProcessListener(){

                @Override
                public void readLine(String line) {
                }

                @Override
                public void processFailed() {
                    result.add("failed");
                }

                @Override
                public void processComplete() {
                    result.add("success");
                }
            };
            CommandHelper.execute(cmd, null, listener, null, true);
            if (result.size() == 1) {
                return "success".equals(result.get(0));
            }
            throw new IOException("can not copy directory from " + srcDir.getAbsolutePath() + " to " + destDir.getAbsolutePath() + ", may be some files are being used by other application, please check it.");
        }
        FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
        return true;
    }

    public static String getProjectType(File projRoot) {
        if (ProjectManager.isCocosLuaProject(projRoot)) {
            return "lua";
        }
        if (ProjectManager.isCocosJSProject(projRoot)) {
            return "js";
        }
        return null;
    }

    public static boolean revertCocosProject(File projRoot) {
        File projUpgradeBakPath = new File(String.valueOf(projRoot.getAbsolutePath()) + File.separator + "upgrade_bak");
        File bakupRuntimePath = new File(String.valueOf(projUpgradeBakPath.getAbsolutePath()) + File.separator + "runtime");
        File bakFrameworksPath = new File(String.valueOf(projUpgradeBakPath.getAbsolutePath()) + File.separator + "frameworks");
        try {
            FileUtils.copyDirectoryToDirectory((File)bakupRuntimePath, (File)projRoot);
            FileUtils.copyDirectoryToDirectory((File)bakFrameworksPath, (File)projRoot);
            return true;
        }
        catch (IOException e) {
            CocosLogger.LOG.error((Object)"revert cocos project error", (Throwable)e);
            return false;
        }
    }

    public static interface LaunchConfigAttributesCallBack {
        public String getAttribute(ILaunchConfigurationWorkingCopy var1);
    }
}

