/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.manager;

import java.io.File;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.config.model.JSConfig;
import org.ccdt.common.manager.ConfigurationManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;

public enum PathManager {
    instance;


    public String getPlatformPath() {
        return Platform.getInstallLocation().getURL().getPath();
    }

    public String getConfigurationPath() {
        return String.valueOf(this.getPlatformPath()) + File.separator + (Object)((Object)FOLDER.configuration);
    }

    public String getProposalConfigPath() {
        return String.valueOf(this.getConfigurationPath()) + File.separator + (Object)((Object)FILE.proposal);
    }

    public String getTemplatesPath() {
        return String.valueOf(this.getConfigurationPath()) + File.separator + (Object)((Object)FOLDER.templates);
    }

    public String getProjectJSConfigPath(IProject project) {
        return String.valueOf(project.getLocation().toString()) + File.separator + (Object)((Object)FILE.js_config);
    }

    public String getProjectLuaConfigPath(IProject project) {
        return String.valueOf(project.getLocation().toString()) + File.separator + (Object)((Object)FILE.lua_config);
    }

    public String getProjectConfigPath(IProject project) {
        return String.valueOf(project.getLocation().toString()) + File.separator + (Object)((Object)FILE.config);
    }

    public String getProjectVersionConfigPath(IProject project) {
        return this.getProjectVersionConfigPath(project.getLocation().toFile());
    }

    public String getProjectVersionConfigPath(File projRoot) {
        return String.valueOf(projRoot.getAbsolutePath()) + File.separator + (Object)((Object)FOLDER.settings) + File.separator + (Object)((Object)FILE.version);
    }

    public String getCocosProjectConfigPath(IProject project) {
        return this.getCocosProjectConfigPath(project.getLocation().toFile());
    }

    public String getCocosProjectConfigPath(File projRoot) {
        return String.valueOf(projRoot.getAbsolutePath()) + File.separator + (Object)((Object)FILE.cocos_project_config);
    }

    public String getJSEnginePath() {
        JSConfig config = ConfigurationManager.COMMON.getConfig(JSConfig.class);
        return config.getJsEnginePath();
    }

    public String getJSConfigPath() {
        String jsEngine = this.getJSEnginePath();
        if (jsEngine == null) {
            return null;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(jsEngine).append(File.separator).append((Object)FOLDER.templates).append(File.separator).append((Object)FOLDER.js_template_runtime).append(File.separator).append((Object)FILE.js_config);
        return buff.toString();
    }

    public String getJSTemplateVersionPath() {
        String jsEngine = this.getJSEnginePath();
        if (jsEngine == null) {
            return null;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(jsEngine).append(File.separator).append((Object)FOLDER.templates).append(File.separator).append((Object)FOLDER.js_template_runtime).append(File.separator).append((Object)FOLDER.settings).append(File.separator).append((Object)FILE.version);
        return buff.toString();
    }

    public String getLUAEnginePath() {
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        return store.getString("org.ccdt.common.lua_engine_path");
    }

    public String getLUAConfigPath() {
        String luaEngine = this.getLUAEnginePath();
        if (luaEngine == null) {
            return null;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(luaEngine).append(File.separator).append((Object)FOLDER.templates).append(File.separator).append((Object)FOLDER.lua_template_runtime).append(File.separator).append((Object)FILE.js_config);
        return buff.toString();
    }

    public String getLuaTemplateVersionPath() {
        String luaEngine = this.getLUAEnginePath();
        if (luaEngine == null) {
            return null;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(luaEngine).append(File.separator).append((Object)FOLDER.templates).append(File.separator).append((Object)FOLDER.lua_template_runtime).append(File.separator).append((Object)FOLDER.settings).append(File.separator).append((Object)FILE.version);
        return buff.toString();
    }

    public String getPythonPath() {
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        return store.getString("org.ccdt.common.python_path");
    }

    public String getAndroidSDKPath() {
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        return store.getString("org.ccdt.common.sdk_path");
    }

    public String getAndroidNDKPath() {
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        return store.getString("org.ccdt.common.ndk_path");
    }

    public String getANTPath() {
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        return store.getString("org.ccdt.common.ant_path");
    }

    public String getJDKPath() {
        IPreferenceStore store = CommonPlugin.getDefault().getPreferenceStore();
        return store.getString("org.ccdt.common.jdk_path");
    }

    private static enum FILE {
        proposal("proposal.json"),
        js_config("config.json"),
        lua_config("config.json"),
        config("config.json"),
        scene_template("scene_template"),
        version("version.json"),
        cocos_project_config(".cocos-project.json");

        private String name;

        private FILE(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum FOLDER {
        templates("templates"),
        configuration("configuration"),
        js_template_runtime("js-template-runtime"),
        lua_template_runtime("lua-template-runtime"),
        settings(".settings");

        private String name;

        private FOLDER(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

