/*
 * Decompiled with CFR 0.152.
 */
package org.ccdt.common.manager;

import java.util.HashMap;
import java.util.Map;
import org.ccdt.common.CommonPlugin;
import org.ccdt.common.config.IConfiguration;
import org.ccdt.common.config.INIConfiguration;
import org.ccdt.common.config.JsonConfiguration;
import org.ccdt.common.config.PreferenceConfiguration;

public final class ConfigurationManager {
    public static final IConfiguration COMMON = new PreferenceConfiguration(CommonPlugin.getDefault().getPreferenceStore());
    private static final Map<String, IConfiguration> iniConfigurations = new HashMap<String, IConfiguration>();
    private static final String INI_FILE_SUFFIX = ".ini";
    private static final String JSON_FILE_SUFFIX = ".json";

    public static IConfiguration getConfiguration(String filePath) {
        if (filePath == null) {
            return null;
        }
        if (iniConfigurations.containsKey(filePath)) {
            return iniConfigurations.get(filePath);
        }
        IConfiguration configuration = null;
        if (filePath.endsWith(INI_FILE_SUFFIX)) {
            configuration = new INIConfiguration(filePath);
        } else if (filePath.endsWith(JSON_FILE_SUFFIX)) {
            configuration = new JsonConfiguration(filePath);
        }
        if (configuration != null) {
            iniConfigurations.put(filePath, configuration);
        }
        return configuration;
    }

    private ConfigurationManager() {
    }
}

